package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiToolbarButton implements UiObject {


	protected String buttonId;
	protected UiTemplate template;
	protected boolean visible = true;

	@JsonSerialize(using = ObjectSerializer.class)
	@JsonDeserialize(using = ObjectDeserializer.class)
	protected Object recordData;
	protected String togglesFullScreenOnComponent;
	protected String openNewTabWithUrl;
	protected boolean hasDropDown;
	protected UiComponentReference dropDownComponent;
	protected int dropDownPanelWidth = 450;
	protected UiColor backgroundColor;
	protected UiColor hoverBackgroundColor;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiToolbarButton() {
		// default constructor for Jackson
	}

	public UiToolbarButton(String buttonId, UiTemplate template, Object recordData) {
		this.buttonId = buttonId;
		this.template = template;
		this.recordData = recordData;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_TOOLBAR_BUTTON;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("buttonId=" + buttonId).append(", ")
				.append(template != null ? "template={" + template.toString() + "}" : "").append(", ")
				.append("visible=" + visible).append(", ")
				.append("recordData=" + recordData).append(", ")
				.append("togglesFullScreenOnComponent=" + togglesFullScreenOnComponent).append(", ")
				.append("openNewTabWithUrl=" + openNewTabWithUrl).append(", ")
				.append("hasDropDown=" + hasDropDown).append(", ")
				.append("dropDownPanelWidth=" + dropDownPanelWidth).append(", ")
				.append(dropDownComponent != null ? "dropDownComponent={" + dropDownComponent.toString() + "}" : "").append(", ")
				.append(backgroundColor != null ? "backgroundColor={" + backgroundColor.toString() + "}" : "").append(", ")
				.append(hoverBackgroundColor != null ? "hoverBackgroundColor={" + hoverBackgroundColor.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("buttonId")
	public String getButtonId() {
		return buttonId;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("template")
	public UiTemplate getTemplate() {
		return template;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("visible")
	public boolean getVisible() {
		return visible;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("recordData")
	public Object getRecordData() {
		return recordData;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("togglesFullScreenOnComponent")
	public String getTogglesFullScreenOnComponent() {
		return togglesFullScreenOnComponent;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("openNewTabWithUrl")
	public String getOpenNewTabWithUrl() {
		return openNewTabWithUrl;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("hasDropDown")
	public boolean getHasDropDown() {
		return hasDropDown;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("dropDownComponent")
	public UiComponentReference getDropDownComponent() {
		return dropDownComponent;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("dropDownPanelWidth")
	public int getDropDownPanelWidth() {
		return dropDownPanelWidth;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
	public UiColor getBackgroundColor() {
		return backgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("hoverBackgroundColor")
	public UiColor getHoverBackgroundColor() {
		return hoverBackgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiToolbarButton setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("togglesFullScreenOnComponent")
	public UiToolbarButton setTogglesFullScreenOnComponent(String togglesFullScreenOnComponent) {
		this.togglesFullScreenOnComponent = togglesFullScreenOnComponent;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("openNewTabWithUrl")
	public UiToolbarButton setOpenNewTabWithUrl(String openNewTabWithUrl) {
		this.openNewTabWithUrl = openNewTabWithUrl;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("hasDropDown")
	public UiToolbarButton setHasDropDown(boolean hasDropDown) {
		this.hasDropDown = hasDropDown;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("dropDownComponent")
	public UiToolbarButton setDropDownComponent(UiComponentReference dropDownComponent) {
		this.dropDownComponent = dropDownComponent;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("dropDownPanelWidth")
	public UiToolbarButton setDropDownPanelWidth(int dropDownPanelWidth) {
		this.dropDownPanelWidth = dropDownPanelWidth;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundColor")
	public UiToolbarButton setBackgroundColor(UiColor backgroundColor) {
		this.backgroundColor = backgroundColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("hoverBackgroundColor")
	public UiToolbarButton setHoverBackgroundColor(UiColor hoverBackgroundColor) {
		this.hoverBackgroundColor = hoverBackgroundColor;
		return this;
	}






}