package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiWebRtcPlayer extends UiComponent implements UiObject {


	protected UiWebRtcPlayingSettings playingSettings;
	protected String backgroundImageUrl;

	public UiWebRtcPlayer() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_WEB_RTC_PLAYER;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("backgroundImageUrl=" + backgroundImageUrl).append(", ")
				.append(playingSettings != null ? "playingSettings={" + playingSettings.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("playingSettings")
	public UiWebRtcPlayingSettings getPlayingSettings() {
		return playingSettings;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundImageUrl")
	public String getBackgroundImageUrl() {
		return backgroundImageUrl;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiWebRtcPlayer setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiWebRtcPlayer setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiWebRtcPlayer setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("playingSettings")
	public UiWebRtcPlayer setPlayingSettings(UiWebRtcPlayingSettings playingSettings) {
		this.playingSettings = playingSettings;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundImageUrl")
	public UiWebRtcPlayer setBackgroundImageUrl(String backgroundImageUrl) {
		this.backgroundImageUrl = backgroundImageUrl;
		return this;
	}


	public static class PlayCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiWebRtcPlayingSettings settings;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public PlayCommand() {
			// default constructor for Jackson
		}

		public PlayCommand(String componentId, UiWebRtcPlayingSettings settings) {
			this.componentId = componentId;
			this.settings = settings;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(settings != null ? "settings={" + settings.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("settings")
		public UiWebRtcPlayingSettings getSettings() {
			return settings;
		}

	}

	public static class StopPlayingCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public StopPlayingCommand() {
			// default constructor for Jackson
		}

		public StopPlayingCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class SetBackgroundImageUrlCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String backgroundImageUrl;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetBackgroundImageUrlCommand() {
			// default constructor for Jackson
		}

		public SetBackgroundImageUrlCommand(String componentId, String backgroundImageUrl) {
			this.componentId = componentId;
			this.backgroundImageUrl = backgroundImageUrl;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("backgroundImageUrl=" + backgroundImageUrl)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("backgroundImageUrl")
		public String getBackgroundImageUrl() {
			return backgroundImageUrl;
		}

	}

	public static class GetPlayableVideoCodecsCommand implements UiCommand<List<UiVideoCodec>> {


		public GetPlayableVideoCodecsCommand() {
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.toString();
		}


		public String getComponentId() {
			return null;
		}

	}




}