/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.ser.std.EnumSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;

public class ObjectSerializer
extends JsonSerializer<Object> {
    private final StdTypeResolverBuilder typeResolverBuilder;
    private final TeamAppsJacksonTypeIdResolver typeIdResolver;
    private HashMap<Class<?>, TypeSerializer> typeSerializersCache = new HashMap();
    private final Map<Class, BeanDescription> beanDescriptionsCache = new ConcurrentHashMap<Class, BeanDescription>();

    public ObjectSerializer() {
        this.typeIdResolver = new TeamAppsJacksonTypeIdResolver();
        this.typeResolverBuilder = new ObjectMapper.DefaultTypeResolverBuilder(ObjectMapper.DefaultTyping.NON_FINAL).inclusion(JsonTypeInfo.As.PROPERTY).init(JsonTypeInfo.Id.CLASS, (TypeIdResolver)this.typeIdResolver).typeProperty("_type");
    }

    public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        if (value == null) {
            gen.writeNull();
        } else if (value instanceof List) {
            gen.writeStartArray();
            for (Object entry : (List)value) {
                this.serialize(entry, gen, serializers);
            }
            gen.writeEndArray();
        } else if (value instanceof Map) {
            gen.writeStartObject();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                gen.writeFieldName((String)entry.getKey());
                this.serialize(entry.getValue(), gen, serializers);
            }
            gen.writeEndObject();
        } else if (value instanceof Enum) {
            JsonSerializer valueSerializer = serializers.findValueSerializer(value.getClass());
            if (!(valueSerializer instanceof EnumSerializer)) {
                valueSerializer.serialize(value, gen, serializers);
            } else {
                this.serializeEnum((Enum)value, gen, serializers);
            }
        } else {
            TypeSerializer typeSerializer = this.typeSerializersCache.computeIfAbsent(value.getClass(), clazz -> this.typeResolverBuilder.buildTypeSerializer(serializers.getConfig(), serializers.getTypeFactory().constructType((Type)clazz), null));
            if (typeSerializer != null) {
                this.serializeWithType(value, gen, serializers, typeSerializer);
            } else {
                gen.writeObject(value);
            }
        }
    }

    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        if (List.class.isInstance(value) || Map.class.isInstance(value)) {
            this.serialize(value, gen, serializers);
        } else {
            serializers.findValueSerializer(value.getClass()).serializeWithType(value, gen, serializers, typeSer);
        }
    }

    public void serializeEnum(Enum value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeFieldName("_type");
        gen.writeString(this.typeIdResolver.idFromClass(value.getDeclaringClass()));
        gen.writeFieldName("_name");
        gen.writeString(value.name());
        BeanDescription beanDescription = this.beanDescriptionsCache.computeIfAbsent(value.getClass(), aClass -> {
            JavaType javaType = serializers.getTypeFactory().constructType((Type)aClass);
            return serializers.getConfig().introspect(javaType);
        });
        for (BeanPropertyDefinition property : beanDescription.findProperties()) {
            JsonSerializer serializer;
            Object propertyValue;
            if (property.getName().equals("declaringClass") || (propertyValue = property.getAccessor().getValue((Object)value)) == null || (serializer = serializers.findValueSerializer(propertyValue.getClass())).isEmpty(serializers, propertyValue)) continue;
            gen.writeFieldName(property.getName());
            serializer.serialize(propertyValue, gen, serializers);
        }
        gen.writeEndObject();
    }
}

