/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiNewChatMessage;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiChatInput
extends UiComponent
implements UiObject {
    protected String defaultFileIcon;
    protected long maxBytesPerUpload = 5000000L;
    protected String uploadUrl = "/upload";

    @Deprecated
    public UiChatInput() {
    }

    public UiChatInput(String defaultFileIcon) {
        this.defaultFileIcon = defaultFileIcon;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_CHAT_INPUT;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("defaultFileIcon=" + this.defaultFileIcon) + ", " + ("maxBytesPerUpload=" + this.maxBytesPerUpload) + ", " + ("uploadUrl=" + this.uploadUrl);
    }

    @JsonGetter(value="defaultFileIcon")
    public String getDefaultFileIcon() {
        return this.defaultFileIcon;
    }

    @JsonGetter(value="maxBytesPerUpload")
    public long getMaxBytesPerUpload() {
        return this.maxBytesPerUpload;
    }

    @JsonGetter(value="uploadUrl")
    public String getUploadUrl() {
        return this.uploadUrl;
    }

    @Override
    @JsonSetter(value="id")
    public UiChatInput setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiChatInput setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiChatInput setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="maxBytesPerUpload")
    public UiChatInput setMaxBytesPerUpload(long maxBytesPerUpload) {
        this.maxBytesPerUpload = maxBytesPerUpload;
        return this;
    }

    @JsonSetter(value="uploadUrl")
    public UiChatInput setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
        return this;
    }

    public static class FileItemRemovedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String fileItemUuid;

        @Deprecated
        public FileItemRemovedEvent() {
        }

        public FileItemRemovedEvent(String componentId, String fileItemUuid) {
            this.componentId = componentId;
            this.fileItemUuid = fileItemUuid;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_CHAT_INPUT_FILE_ITEM_REMOVED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileItemUuid=" + this.fileItemUuid);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileItemUuid")
        public String getFileItemUuid() {
            return this.fileItemUuid;
        }
    }

    public static class FileItemClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String fileItemUuid;

        @Deprecated
        public FileItemClickedEvent() {
        }

        public FileItemClickedEvent(String componentId, String fileItemUuid) {
            this.componentId = componentId;
            this.fileItemUuid = fileItemUuid;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_CHAT_INPUT_FILE_ITEM_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileItemUuid=" + this.fileItemUuid);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileItemUuid")
        public String getFileItemUuid() {
            return this.fileItemUuid;
        }
    }

    public static class UploadSuccessfulEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String fileItemUuid;
        protected String uploadedFileUuid;
        protected String fileName;
        protected String mimeType;
        protected long sizeInBytes;
        protected int incompleteUploadsCount;

        @Deprecated
        public UploadSuccessfulEvent() {
        }

        public UploadSuccessfulEvent(String componentId, String fileItemUuid, String uploadedFileUuid, String fileName, String mimeType, long sizeInBytes, int incompleteUploadsCount) {
            this.componentId = componentId;
            this.fileItemUuid = fileItemUuid;
            this.uploadedFileUuid = uploadedFileUuid;
            this.fileName = fileName;
            this.mimeType = mimeType;
            this.sizeInBytes = sizeInBytes;
            this.incompleteUploadsCount = incompleteUploadsCount;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_CHAT_INPUT_UPLOAD_SUCCESSFUL;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileName=" + this.fileName) + ", " + ("fileItemUuid=" + this.fileItemUuid) + ", " + ("uploadedFileUuid=" + this.uploadedFileUuid) + ", " + ("mimeType=" + this.mimeType) + ", " + ("sizeInBytes=" + this.sizeInBytes) + ", " + ("incompleteUploadsCount=" + this.incompleteUploadsCount);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileItemUuid")
        public String getFileItemUuid() {
            return this.fileItemUuid;
        }

        @JsonGetter(value="uploadedFileUuid")
        public String getUploadedFileUuid() {
            return this.uploadedFileUuid;
        }

        @JsonGetter(value="fileName")
        public String getFileName() {
            return this.fileName;
        }

        @JsonGetter(value="mimeType")
        public String getMimeType() {
            return this.mimeType;
        }

        @JsonGetter(value="sizeInBytes")
        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        @JsonGetter(value="incompleteUploadsCount")
        public int getIncompleteUploadsCount() {
            return this.incompleteUploadsCount;
        }
    }

    public static class UploadFailedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String fileItemUuid;
        protected String fileName;
        protected String mimeType;
        protected long sizeInBytes;
        protected int incompleteUploadsCount;

        @Deprecated
        public UploadFailedEvent() {
        }

        public UploadFailedEvent(String componentId, String fileItemUuid, String fileName, String mimeType, long sizeInBytes, int incompleteUploadsCount) {
            this.componentId = componentId;
            this.fileItemUuid = fileItemUuid;
            this.fileName = fileName;
            this.mimeType = mimeType;
            this.sizeInBytes = sizeInBytes;
            this.incompleteUploadsCount = incompleteUploadsCount;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_CHAT_INPUT_UPLOAD_FAILED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileName=" + this.fileName) + ", " + ("fileItemUuid=" + this.fileItemUuid) + ", " + ("mimeType=" + this.mimeType) + ", " + ("sizeInBytes=" + this.sizeInBytes) + ", " + ("incompleteUploadsCount=" + this.incompleteUploadsCount);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileItemUuid")
        public String getFileItemUuid() {
            return this.fileItemUuid;
        }

        @JsonGetter(value="fileName")
        public String getFileName() {
            return this.fileName;
        }

        @JsonGetter(value="mimeType")
        public String getMimeType() {
            return this.mimeType;
        }

        @JsonGetter(value="sizeInBytes")
        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        @JsonGetter(value="incompleteUploadsCount")
        public int getIncompleteUploadsCount() {
            return this.incompleteUploadsCount;
        }
    }

    public static class UploadCanceledEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String fileItemUuid;
        protected String fileName;
        protected String mimeType;
        protected long sizeInBytes;
        protected int incompleteUploadsCount;

        @Deprecated
        public UploadCanceledEvent() {
        }

        public UploadCanceledEvent(String componentId, String fileItemUuid, String fileName, String mimeType, long sizeInBytes, int incompleteUploadsCount) {
            this.componentId = componentId;
            this.fileItemUuid = fileItemUuid;
            this.fileName = fileName;
            this.mimeType = mimeType;
            this.sizeInBytes = sizeInBytes;
            this.incompleteUploadsCount = incompleteUploadsCount;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_CHAT_INPUT_UPLOAD_CANCELED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileName=" + this.fileName) + ", " + ("fileItemUuid=" + this.fileItemUuid) + ", " + ("mimeType=" + this.mimeType) + ", " + ("sizeInBytes=" + this.sizeInBytes) + ", " + ("incompleteUploadsCount=" + this.incompleteUploadsCount);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileItemUuid")
        public String getFileItemUuid() {
            return this.fileItemUuid;
        }

        @JsonGetter(value="fileName")
        public String getFileName() {
            return this.fileName;
        }

        @JsonGetter(value="mimeType")
        public String getMimeType() {
            return this.mimeType;
        }

        @JsonGetter(value="sizeInBytes")
        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        @JsonGetter(value="incompleteUploadsCount")
        public int getIncompleteUploadsCount() {
            return this.incompleteUploadsCount;
        }
    }

    public static class UploadStartedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String fileItemUuid;
        protected String fileName;
        protected String mimeType;
        protected long sizeInBytes;
        protected int incompleteUploadsCount;

        @Deprecated
        public UploadStartedEvent() {
        }

        public UploadStartedEvent(String componentId, String fileItemUuid, String fileName, String mimeType, long sizeInBytes, int incompleteUploadsCount) {
            this.componentId = componentId;
            this.fileItemUuid = fileItemUuid;
            this.fileName = fileName;
            this.mimeType = mimeType;
            this.sizeInBytes = sizeInBytes;
            this.incompleteUploadsCount = incompleteUploadsCount;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_CHAT_INPUT_UPLOAD_STARTED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileName=" + this.fileName) + ", " + ("fileItemUuid=" + this.fileItemUuid) + ", " + ("mimeType=" + this.mimeType) + ", " + ("sizeInBytes=" + this.sizeInBytes) + ", " + ("incompleteUploadsCount=" + this.incompleteUploadsCount);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileItemUuid")
        public String getFileItemUuid() {
            return this.fileItemUuid;
        }

        @JsonGetter(value="fileName")
        public String getFileName() {
            return this.fileName;
        }

        @JsonGetter(value="mimeType")
        public String getMimeType() {
            return this.mimeType;
        }

        @JsonGetter(value="sizeInBytes")
        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        @JsonGetter(value="incompleteUploadsCount")
        public int getIncompleteUploadsCount() {
            return this.incompleteUploadsCount;
        }
    }

    public static class UploadTooLargeEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String fileItemUuid;
        protected String fileName;
        protected String mimeType;
        protected long sizeInBytes;

        @Deprecated
        public UploadTooLargeEvent() {
        }

        public UploadTooLargeEvent(String componentId, String fileItemUuid, String fileName, String mimeType, long sizeInBytes) {
            this.componentId = componentId;
            this.fileItemUuid = fileItemUuid;
            this.fileName = fileName;
            this.mimeType = mimeType;
            this.sizeInBytes = sizeInBytes;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_CHAT_INPUT_UPLOAD_TOO_LARGE;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("fileName=" + this.fileName) + ", " + ("fileItemUuid=" + this.fileItemUuid) + ", " + ("mimeType=" + this.mimeType) + ", " + ("sizeInBytes=" + this.sizeInBytes);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="fileItemUuid")
        public String getFileItemUuid() {
            return this.fileItemUuid;
        }

        @JsonGetter(value="fileName")
        public String getFileName() {
            return this.fileName;
        }

        @JsonGetter(value="mimeType")
        public String getMimeType() {
            return this.mimeType;
        }

        @JsonGetter(value="sizeInBytes")
        public long getSizeInBytes() {
            return this.sizeInBytes;
        }
    }

    public static class MessageSentEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected UiNewChatMessage message;

        @Deprecated
        public MessageSentEvent() {
        }

        public MessageSentEvent(String componentId, UiNewChatMessage message) {
            this.componentId = componentId;
            this.message = message;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_CHAT_INPUT_MESSAGE_SENT;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.message != null ? "message={" + this.message.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="message")
        public UiNewChatMessage getMessage() {
            return this.message;
        }
    }
}

