/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Map;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiPopup.class)
public class UiPopup
extends UiComponent
implements UiObject {
    protected UiClientObjectReference contentComponent;
    protected int width;
    protected int height;
    protected int x;
    protected int y;
    protected String backgroundColor;
    protected boolean modal = false;
    protected String dimmingColor = "rgba(0, 0, 0, .2)";
    protected boolean closeOnEscape;
    protected boolean closeOnClickOutside;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_POPUP;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("classNamesBySelector=" + String.valueOf(this.classNamesBySelector)) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + String.valueOf(this.stylesBySelector)) + ", " + ("attributesBySelector=" + String.valueOf(this.attributesBySelector)) + ", " + ("width=" + this.width) + ", " + ("height=" + this.height) + ", " + ("x=" + this.x) + ", " + ("y=" + this.y) + ", " + ("backgroundColor=" + this.backgroundColor) + ", " + ("modal=" + this.modal) + ", " + ("dimmingColor=" + this.dimmingColor) + ", " + ("closeOnEscape=" + this.closeOnEscape) + ", " + ("closeOnClickOutside=" + this.closeOnClickOutside) + ", " + (String)(this.contentComponent != null ? "contentComponent={" + this.contentComponent.toString() + "}" : "");
    }

    @JsonGetter(value="contentComponent")
    public UiClientObjectReference getContentComponent() {
        return this.contentComponent;
    }

    @JsonGetter(value="width")
    public int getWidth() {
        return this.width;
    }

    @JsonGetter(value="height")
    public int getHeight() {
        return this.height;
    }

    @JsonGetter(value="x")
    public int getX() {
        return this.x;
    }

    @JsonGetter(value="y")
    public int getY() {
        return this.y;
    }

    @JsonGetter(value="backgroundColor")
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @JsonGetter(value="modal")
    public boolean getModal() {
        return this.modal;
    }

    @JsonGetter(value="dimmingColor")
    public String getDimmingColor() {
        return this.dimmingColor;
    }

    @JsonGetter(value="closeOnEscape")
    public boolean getCloseOnEscape() {
        return this.closeOnEscape;
    }

    @JsonGetter(value="closeOnClickOutside")
    public boolean getCloseOnClickOutside() {
        return this.closeOnClickOutside;
    }

    @Override
    @JsonSetter(value="id")
    public UiPopup setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiPopup setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiPopup setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiPopup setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="classNamesBySelector")
    public UiPopup setClassNamesBySelector(Map<String, Map<String, Boolean>> classNamesBySelector) {
        this.classNamesBySelector = classNamesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="attributesBySelector")
    public UiPopup setAttributesBySelector(Map<String, Map<String, String>> attributesBySelector) {
        this.attributesBySelector = attributesBySelector;
        return this;
    }

    @JsonSetter(value="contentComponent")
    public UiPopup setContentComponent(UiClientObjectReference contentComponent) {
        this.contentComponent = contentComponent;
        return this;
    }

    @JsonSetter(value="width")
    public UiPopup setWidth(int width) {
        this.width = width;
        return this;
    }

    @JsonSetter(value="height")
    public UiPopup setHeight(int height) {
        this.height = height;
        return this;
    }

    @JsonSetter(value="x")
    public UiPopup setX(int x) {
        this.x = x;
        return this;
    }

    @JsonSetter(value="y")
    public UiPopup setY(int y) {
        this.y = y;
        return this;
    }

    @JsonSetter(value="backgroundColor")
    public UiPopup setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @JsonSetter(value="modal")
    public UiPopup setModal(boolean modal) {
        this.modal = modal;
        return this;
    }

    @JsonSetter(value="dimmingColor")
    public UiPopup setDimmingColor(String dimmingColor) {
        this.dimmingColor = dimmingColor;
        return this;
    }

    @JsonSetter(value="closeOnEscape")
    public UiPopup setCloseOnEscape(boolean closeOnEscape) {
        this.closeOnEscape = closeOnEscape;
        return this;
    }

    @JsonSetter(value="closeOnClickOutside")
    public UiPopup setCloseOnClickOutside(boolean closeOnClickOutside) {
        this.closeOnClickOutside = closeOnClickOutside;
        return this;
    }

    public static class CloseCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public CloseCommand() {
        }

        public CloseCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class SetDimensionsCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int width;
        protected int height;

        @Deprecated
        public SetDimensionsCommand() {
        }

        public SetDimensionsCommand(String componentId, int width, int height) {
            this.componentId = componentId;
            this.width = width;
            this.height = height;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("width=" + this.width) + ", " + ("height=" + this.height);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="width")
        public int getWidth() {
            return this.width;
        }

        @JsonGetter(value="height")
        public int getHeight() {
            return this.height;
        }
    }

    public static class SetPositionCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int x;
        protected int y;

        @Deprecated
        public SetPositionCommand() {
        }

        public SetPositionCommand(String componentId, int x, int y) {
            this.componentId = componentId;
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("x=" + this.x) + ", " + ("y=" + this.y);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="x")
        public int getX() {
            return this.x;
        }

        @JsonGetter(value="y")
        public int getY() {
            return this.y;
        }
    }

    public static class SetDimmingColorCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String backgroundColor;

        @Deprecated
        public SetDimmingColorCommand() {
        }

        public SetDimmingColorCommand(String componentId, String backgroundColor) {
            this.componentId = componentId;
            this.backgroundColor = backgroundColor;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("backgroundColor=" + this.backgroundColor);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="backgroundColor")
        public String getBackgroundColor() {
            return this.backgroundColor;
        }
    }

    public static class SetBackgroundColorCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String backgroundColor;

        @Deprecated
        public SetBackgroundColorCommand() {
        }

        public SetBackgroundColorCommand(String componentId, String backgroundColor) {
            this.componentId = componentId;
            this.backgroundColor = backgroundColor;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("backgroundColor=" + this.backgroundColor);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="backgroundColor")
        public String getBackgroundColor() {
            return this.backgroundColor;
        }
    }
}

