/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.teamapps.dto.UiLineType;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type", defaultImpl=UiLine.class)
public class UiLine
implements UiObject {
    protected float thickness;
    protected String color;
    protected UiLineType type = UiLineType.SOLID;

    @Deprecated
    public UiLine() {
    }

    public UiLine(float thickness, String color) {
        this.thickness = thickness;
        this.color = color;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_LINE;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("thickness=" + this.thickness) + ", " + ("color=" + this.color) + ", " + ("type=" + String.valueOf((Object)this.type));
    }

    @JsonGetter(value="thickness")
    public float getThickness() {
        return this.thickness;
    }

    @JsonGetter(value="color")
    public String getColor() {
        return this.color;
    }

    @JsonGetter(value="type")
    public UiLineType getType() {
        return this.type;
    }

    @JsonSetter(value="type")
    public UiLine setType(UiLineType type) {
        this.type = type;
        return this;
    }
}

