package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiResponsiveGridLayout extends UiComponent implements UiObject {


	protected List<UiResponsiveGridLayoutPolicy> layoutPolicies;
	protected boolean fillHeight = false;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiResponsiveGridLayout() {
		// default constructor for Jackson
	}

	public UiResponsiveGridLayout(List<UiResponsiveGridLayoutPolicy> layoutPolicies) {
		super();
		this.layoutPolicies = layoutPolicies;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_RESPONSIVE_GRID_LAYOUT;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("fillHeight=" + fillHeight).append(", ")
				.append(layoutPolicies != null ? "layoutPolicies={" + layoutPolicies.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("layoutPolicies")
	public List<UiResponsiveGridLayoutPolicy> getLayoutPolicies() {
		return layoutPolicies;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("fillHeight")
	public boolean getFillHeight() {
		return fillHeight;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiResponsiveGridLayout setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiResponsiveGridLayout setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiResponsiveGridLayout setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("fillHeight")
	public UiResponsiveGridLayout setFillHeight(boolean fillHeight) {
		this.fillHeight = fillHeight;
		return this;
	}


	public static class UpdateLayoutPoliciesCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<UiResponsiveGridLayoutPolicy> layoutPolicies;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UpdateLayoutPoliciesCommand() {
			// default constructor for Jackson
		}

		public UpdateLayoutPoliciesCommand(String componentId, List<UiResponsiveGridLayoutPolicy> layoutPolicies) {
			this.componentId = componentId;
			this.layoutPolicies = layoutPolicies;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(layoutPolicies != null ? "layoutPolicies={" + layoutPolicies.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("layoutPolicies")
		public List<UiResponsiveGridLayoutPolicy> getLayoutPolicies() {
			return layoutPolicies;
		}

	}

	public static class SetFillHeightCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected boolean fillHeight;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetFillHeightCommand() {
			// default constructor for Jackson
		}

		public SetFillHeightCommand(String componentId, boolean fillHeight) {
			this.componentId = componentId;
			this.fillHeight = fillHeight;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("fillHeight=" + fillHeight)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fillHeight")
		public boolean getFillHeight() {
			return fillHeight;
		}

	}




}