package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiTab implements UiObject {


	protected String tabId;
	protected String icon;
	protected String caption;
	protected boolean closeable;
	protected boolean lazyLoading;
	protected boolean rightSide;
	protected boolean visible;
	protected UiComponentReference toolbar;
	protected UiComponentReference content;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiTab() {
		// default constructor for Jackson
	}

	public UiTab(String tabId, String icon, String caption) {
		this.tabId = tabId;
		this.icon = icon;
		this.caption = caption;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_TAB;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("tabId=" + tabId).append(", ")
				.append("icon=" + icon).append(", ")
				.append("caption=" + caption).append(", ")
				.append("closeable=" + closeable).append(", ")
				.append("lazyLoading=" + lazyLoading).append(", ")
				.append("rightSide=" + rightSide).append(", ")
				.append("visible=" + visible).append(", ")
				.append(toolbar != null ? "toolbar={" + toolbar.toString() + "}" : "").append(", ")
				.append(content != null ? "content={" + content.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("tabId")
	public String getTabId() {
		return tabId;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("icon")
	public String getIcon() {
		return icon;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("caption")
	public String getCaption() {
		return caption;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("closeable")
	public boolean getCloseable() {
		return closeable;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("lazyLoading")
	public boolean getLazyLoading() {
		return lazyLoading;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("rightSide")
	public boolean getRightSide() {
		return rightSide;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("visible")
	public boolean getVisible() {
		return visible;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("toolbar")
	public UiComponentReference getToolbar() {
		return toolbar;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("content")
	public UiComponentReference getContent() {
		return content;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("closeable")
	public UiTab setCloseable(boolean closeable) {
		this.closeable = closeable;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("lazyLoading")
	public UiTab setLazyLoading(boolean lazyLoading) {
		this.lazyLoading = lazyLoading;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("rightSide")
	public UiTab setRightSide(boolean rightSide) {
		this.rightSide = rightSide;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiTab setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("toolbar")
	public UiTab setToolbar(UiComponentReference toolbar) {
		this.toolbar = toolbar;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("content")
	public UiTab setContent(UiComponentReference content) {
		this.content = content;
		return this;
	}






}