package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiMediaSoupWebRtcClient extends UiComponent implements UiObject {


	@JsonSerialize(using = ObjectSerializer.class)
	@JsonDeserialize(using = ObjectDeserializer.class)
	protected Object initialPlaybackOrPublishParams;
	protected Float displayAreaAspectRatio = 4/3f;
	protected boolean activityLineVisible;
	protected UiColor activityInactiveColor;
	protected UiColor activityActiveColor;
	protected boolean active;
	protected String icon;
	protected String caption;
	protected String noVideoImageUrl;

	public UiMediaSoupWebRtcClient() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_MEDIA_SOUP_WEB_RTC_CLIENT;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("initialPlaybackOrPublishParams=" + initialPlaybackOrPublishParams).append(", ")
				.append("displayAreaAspectRatio=" + displayAreaAspectRatio).append(", ")
				.append("activityLineVisible=" + activityLineVisible).append(", ")
				.append("active=" + active).append(", ")
				.append("icon=" + icon).append(", ")
				.append("caption=" + caption).append(", ")
				.append("noVideoImageUrl=" + noVideoImageUrl).append(", ")
				.append(activityInactiveColor != null ? "activityInactiveColor={" + activityInactiveColor.toString() + "}" : "").append(", ")
				.append(activityActiveColor != null ? "activityActiveColor={" + activityActiveColor.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("initialPlaybackOrPublishParams")
	public Object getInitialPlaybackOrPublishParams() {
		return initialPlaybackOrPublishParams;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("displayAreaAspectRatio")
	public Float getDisplayAreaAspectRatio() {
		return displayAreaAspectRatio;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("activityLineVisible")
	public boolean getActivityLineVisible() {
		return activityLineVisible;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("activityInactiveColor")
	public UiColor getActivityInactiveColor() {
		return activityInactiveColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("activityActiveColor")
	public UiColor getActivityActiveColor() {
		return activityActiveColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("active")
	public boolean getActive() {
		return active;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("icon")
	public String getIcon() {
		return icon;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("caption")
	public String getCaption() {
		return caption;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("noVideoImageUrl")
	public String getNoVideoImageUrl() {
		return noVideoImageUrl;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiMediaSoupWebRtcClient setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiMediaSoupWebRtcClient setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiMediaSoupWebRtcClient setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("initialPlaybackOrPublishParams")
	public UiMediaSoupWebRtcClient setInitialPlaybackOrPublishParams(Object initialPlaybackOrPublishParams) {
		this.initialPlaybackOrPublishParams = initialPlaybackOrPublishParams;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("displayAreaAspectRatio")
	public UiMediaSoupWebRtcClient setDisplayAreaAspectRatio(Float displayAreaAspectRatio) {
		this.displayAreaAspectRatio = displayAreaAspectRatio;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("activityLineVisible")
	public UiMediaSoupWebRtcClient setActivityLineVisible(boolean activityLineVisible) {
		this.activityLineVisible = activityLineVisible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("activityInactiveColor")
	public UiMediaSoupWebRtcClient setActivityInactiveColor(UiColor activityInactiveColor) {
		this.activityInactiveColor = activityInactiveColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("activityActiveColor")
	public UiMediaSoupWebRtcClient setActivityActiveColor(UiColor activityActiveColor) {
		this.activityActiveColor = activityActiveColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("active")
	public UiMediaSoupWebRtcClient setActive(boolean active) {
		this.active = active;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("icon")
	public UiMediaSoupWebRtcClient setIcon(String icon) {
		this.icon = icon;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("caption")
	public UiMediaSoupWebRtcClient setCaption(String caption) {
		this.caption = caption;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("noVideoImageUrl")
	public UiMediaSoupWebRtcClient setNoVideoImageUrl(String noVideoImageUrl) {
		this.noVideoImageUrl = noVideoImageUrl;
		return this;
	}

	public static class PlaybackProfileChangedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected UiMulticastPlaybackProfile profile;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public PlaybackProfileChangedEvent() {
			// default constructor for Jackson
		}

		public PlaybackProfileChangedEvent(String componentId, UiMulticastPlaybackProfile profile) {
			this.componentId = componentId;
			this.profile = profile;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_WEB_RTC_CLIENT_PLAYBACK_PROFILE_CHANGED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("profile=" + profile)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("profile")
		public UiMulticastPlaybackProfile getProfile() {
			return profile;
		}

	}

	public static class ActivityChangedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected boolean active;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ActivityChangedEvent() {
			// default constructor for Jackson
		}

		public ActivityChangedEvent(String componentId, boolean active) {
			this.componentId = componentId;
			this.active = active;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_WEB_RTC_CLIENT_ACTIVITY_CHANGED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("active=" + active)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("active")
		public boolean getActive() {
			return active;
		}

	}

	public static class UpdateCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiMediaSoupWebRtcClient config;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UpdateCommand() {
			// default constructor for Jackson
		}

		public UpdateCommand(String componentId, UiMediaSoupWebRtcClient config) {
			this.componentId = componentId;
			this.config = config;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(config != null ? "config={" + config.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("config")
		public UiMediaSoupWebRtcClient getConfig() {
			return config;
		}

	}

	public static class SetActiveCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected boolean active;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetActiveCommand() {
			// default constructor for Jackson
		}

		public SetActiveCommand(String componentId, boolean active) {
			this.componentId = componentId;
			this.active = active;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("active=" + active)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("active")
		public boolean getActive() {
			return active;
		}

	}

	public static class PublishCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiMediaSoupPublishingParameters parameters;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public PublishCommand() {
			// default constructor for Jackson
		}

		public PublishCommand(String componentId, UiMediaSoupPublishingParameters parameters) {
			this.componentId = componentId;
			this.parameters = parameters;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(parameters != null ? "parameters={" + parameters.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("parameters")
		public UiMediaSoupPublishingParameters getParameters() {
			return parameters;
		}

	}

	public static class PlaybackCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiMediaSoupPlaybackParamaters parameters;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public PlaybackCommand() {
			// default constructor for Jackson
		}

		public PlaybackCommand(String componentId, UiMediaSoupPlaybackParamaters parameters) {
			this.componentId = componentId;
			this.parameters = parameters;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(parameters != null ? "parameters={" + parameters.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("parameters")
		public UiMediaSoupPlaybackParamaters getParameters() {
			return parameters;
		}

	}

	public static class StopCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public StopCommand() {
			// default constructor for Jackson
		}

		public StopCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}




}