/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.Map;
import org.teamapps.dto.ObjectDeserializer;
import org.teamapps.dto.ObjectSerializer;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiColor;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiMediaSoupPlaybackParamaters;
import org.teamapps.dto.UiMediaSoupPublishingParameters;
import org.teamapps.dto.UiMulticastPlaybackProfile;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiMediaSoupWebRtcClient
extends UiComponent
implements UiObject {
    @JsonSerialize(using=ObjectSerializer.class)
    @JsonDeserialize(using=ObjectDeserializer.class)
    protected Object initialPlaybackOrPublishParams;
    protected Float displayAreaAspectRatio = Float.valueOf(1.3333334f);
    protected boolean activityLineVisible;
    protected UiColor activityInactiveColor;
    protected UiColor activityActiveColor;
    protected boolean active;
    protected String icon;
    protected String caption;
    protected String noVideoImageUrl;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_MEDIA_SOUP_WEB_RTC_CLIENT;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("initialPlaybackOrPublishParams=" + this.initialPlaybackOrPublishParams) + ", " + ("displayAreaAspectRatio=" + this.displayAreaAspectRatio) + ", " + ("activityLineVisible=" + this.activityLineVisible) + ", " + ("active=" + this.active) + ", " + ("icon=" + this.icon) + ", " + ("caption=" + this.caption) + ", " + ("noVideoImageUrl=" + this.noVideoImageUrl) + ", " + (String)(this.activityInactiveColor != null ? "activityInactiveColor={" + this.activityInactiveColor.toString() + "}" : "") + ", " + (String)(this.activityActiveColor != null ? "activityActiveColor={" + this.activityActiveColor.toString() + "}" : "");
    }

    @JsonGetter(value="initialPlaybackOrPublishParams")
    public Object getInitialPlaybackOrPublishParams() {
        return this.initialPlaybackOrPublishParams;
    }

    @JsonGetter(value="displayAreaAspectRatio")
    public Float getDisplayAreaAspectRatio() {
        return this.displayAreaAspectRatio;
    }

    @JsonGetter(value="activityLineVisible")
    public boolean getActivityLineVisible() {
        return this.activityLineVisible;
    }

    @JsonGetter(value="activityInactiveColor")
    public UiColor getActivityInactiveColor() {
        return this.activityInactiveColor;
    }

    @JsonGetter(value="activityActiveColor")
    public UiColor getActivityActiveColor() {
        return this.activityActiveColor;
    }

    @JsonGetter(value="active")
    public boolean getActive() {
        return this.active;
    }

    @JsonGetter(value="icon")
    public String getIcon() {
        return this.icon;
    }

    @JsonGetter(value="caption")
    public String getCaption() {
        return this.caption;
    }

    @JsonGetter(value="noVideoImageUrl")
    public String getNoVideoImageUrl() {
        return this.noVideoImageUrl;
    }

    @Override
    @JsonSetter(value="id")
    public UiMediaSoupWebRtcClient setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiMediaSoupWebRtcClient setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiMediaSoupWebRtcClient setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="initialPlaybackOrPublishParams")
    public UiMediaSoupWebRtcClient setInitialPlaybackOrPublishParams(Object initialPlaybackOrPublishParams) {
        this.initialPlaybackOrPublishParams = initialPlaybackOrPublishParams;
        return this;
    }

    @JsonSetter(value="displayAreaAspectRatio")
    public UiMediaSoupWebRtcClient setDisplayAreaAspectRatio(Float displayAreaAspectRatio) {
        this.displayAreaAspectRatio = displayAreaAspectRatio;
        return this;
    }

    @JsonSetter(value="activityLineVisible")
    public UiMediaSoupWebRtcClient setActivityLineVisible(boolean activityLineVisible) {
        this.activityLineVisible = activityLineVisible;
        return this;
    }

    @JsonSetter(value="activityInactiveColor")
    public UiMediaSoupWebRtcClient setActivityInactiveColor(UiColor activityInactiveColor) {
        this.activityInactiveColor = activityInactiveColor;
        return this;
    }

    @JsonSetter(value="activityActiveColor")
    public UiMediaSoupWebRtcClient setActivityActiveColor(UiColor activityActiveColor) {
        this.activityActiveColor = activityActiveColor;
        return this;
    }

    @JsonSetter(value="active")
    public UiMediaSoupWebRtcClient setActive(boolean active) {
        this.active = active;
        return this;
    }

    @JsonSetter(value="icon")
    public UiMediaSoupWebRtcClient setIcon(String icon) {
        this.icon = icon;
        return this;
    }

    @JsonSetter(value="caption")
    public UiMediaSoupWebRtcClient setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    @JsonSetter(value="noVideoImageUrl")
    public UiMediaSoupWebRtcClient setNoVideoImageUrl(String noVideoImageUrl) {
        this.noVideoImageUrl = noVideoImageUrl;
        return this;
    }

    public static class StopCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public StopCommand() {
        }

        public StopCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class PlaybackCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiMediaSoupPlaybackParamaters parameters;

        @Deprecated
        public PlaybackCommand() {
        }

        public PlaybackCommand(String componentId, UiMediaSoupPlaybackParamaters parameters) {
            this.componentId = componentId;
            this.parameters = parameters;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.parameters != null ? "parameters={" + this.parameters.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="parameters")
        public UiMediaSoupPlaybackParamaters getParameters() {
            return this.parameters;
        }
    }

    public static class PublishCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiMediaSoupPublishingParameters parameters;

        @Deprecated
        public PublishCommand() {
        }

        public PublishCommand(String componentId, UiMediaSoupPublishingParameters parameters) {
            this.componentId = componentId;
            this.parameters = parameters;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.parameters != null ? "parameters={" + this.parameters.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="parameters")
        public UiMediaSoupPublishingParameters getParameters() {
            return this.parameters;
        }
    }

    public static class SetActiveCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected boolean active;

        @Deprecated
        public SetActiveCommand() {
        }

        public SetActiveCommand(String componentId, boolean active) {
            this.componentId = componentId;
            this.active = active;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("active=" + this.active);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="active")
        public boolean getActive() {
            return this.active;
        }
    }

    public static class UpdateCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiMediaSoupWebRtcClient config;

        @Deprecated
        public UpdateCommand() {
        }

        public UpdateCommand(String componentId, UiMediaSoupWebRtcClient config) {
            this.componentId = componentId;
            this.config = config;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.config != null ? "config={" + this.config.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="config")
        public UiMediaSoupWebRtcClient getConfig() {
            return this.config;
        }
    }

    public static class ActivityChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected boolean active;

        @Deprecated
        public ActivityChangedEvent() {
        }

        public ActivityChangedEvent(String componentId, boolean active) {
            this.componentId = componentId;
            this.active = active;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_WEB_RTC_CLIENT_ACTIVITY_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("active=" + this.active);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="active")
        public boolean getActive() {
            return this.active;
        }
    }

    public static class PlaybackProfileChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected UiMulticastPlaybackProfile profile;

        @Deprecated
        public PlaybackProfileChangedEvent() {
        }

        public PlaybackProfileChangedEvent(String componentId, UiMulticastPlaybackProfile profile) {
            this.componentId = componentId;
            this.profile = profile;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_WEB_RTC_CLIENT_PLAYBACK_PROFILE_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("profile=" + this.profile);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="profile")
        public UiMulticastPlaybackProfile getProfile() {
            return this.profile;
        }
    }
}

