package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiTimeGraph extends UiComponent implements UiObject {


	protected UiLineChartYScaleZoomMode yScaleZoomMode = UiLineChartYScaleZoomMode.DYNAMIC_INCLUDING_ZERO;
	protected UiLongInterval intervalX;
	protected List<UiTimeChartZoomLevel> zoomLevels;
	protected int maxPixelsBetweenDataPoints;
	protected List<AbstractUiLineChartDataDisplay> lines;
	protected UiScaleType yScaleType = UiScaleType.LINEAR;
	protected UiLineChartMouseScrollZoomPanMode mouseScrollZoomPanMode = UiLineChartMouseScrollZoomPanMode.ENABLED;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiTimeGraph() {
		// default constructor for Jackson
	}

	public UiTimeGraph(UiLongInterval intervalX, List<UiTimeChartZoomLevel> zoomLevels, int maxPixelsBetweenDataPoints, List<AbstractUiLineChartDataDisplay> lines) {
		super();
		this.intervalX = intervalX;
		this.zoomLevels = zoomLevels;
		this.maxPixelsBetweenDataPoints = maxPixelsBetweenDataPoints;
		this.lines = lines;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_TIME_GRAPH;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("yScaleZoomMode=" + yScaleZoomMode).append(", ")
				.append("maxPixelsBetweenDataPoints=" + maxPixelsBetweenDataPoints).append(", ")
				.append("yScaleType=" + yScaleType).append(", ")
				.append("mouseScrollZoomPanMode=" + mouseScrollZoomPanMode).append(", ")
				.append(intervalX != null ? "intervalX={" + intervalX.toString() + "}" : "").append(", ")
				.append(zoomLevels != null ? "zoomLevels={" + zoomLevels.toString() + "}" : "").append(", ")
				.append(lines != null ? "lines={" + lines.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("yScaleZoomMode")
	public UiLineChartYScaleZoomMode getYScaleZoomMode() {
		return yScaleZoomMode;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("intervalX")
	public UiLongInterval getIntervalX() {
		return intervalX;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("zoomLevels")
	public List<UiTimeChartZoomLevel> getZoomLevels() {
		return zoomLevels;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("maxPixelsBetweenDataPoints")
	public int getMaxPixelsBetweenDataPoints() {
		return maxPixelsBetweenDataPoints;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("lines")
	public List<AbstractUiLineChartDataDisplay> getLines() {
		return lines;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("yScaleType")
	public UiScaleType getYScaleType() {
		return yScaleType;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("mouseScrollZoomPanMode")
	public UiLineChartMouseScrollZoomPanMode getMouseScrollZoomPanMode() {
		return mouseScrollZoomPanMode;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiTimeGraph setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiTimeGraph setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiTimeGraph setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("yScaleZoomMode")
	public UiTimeGraph setYScaleZoomMode(UiLineChartYScaleZoomMode yScaleZoomMode) {
		this.yScaleZoomMode = yScaleZoomMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("yScaleType")
	public UiTimeGraph setYScaleType(UiScaleType yScaleType) {
		this.yScaleType = yScaleType;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("mouseScrollZoomPanMode")
	public UiTimeGraph setMouseScrollZoomPanMode(UiLineChartMouseScrollZoomPanMode mouseScrollZoomPanMode) {
		this.mouseScrollZoomPanMode = mouseScrollZoomPanMode;
		return this;
	}

	public static class DataNeededEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected int zoomLevelIndex;
		protected UiLongInterval neededIntervalX;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public DataNeededEvent() {
			// default constructor for Jackson
		}

		public DataNeededEvent(String componentId, int zoomLevelIndex, UiLongInterval neededIntervalX) {
			this.componentId = componentId;
			this.zoomLevelIndex = zoomLevelIndex;
			this.neededIntervalX = neededIntervalX;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TIME_GRAPH_DATA_NEEDED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("zoomLevelIndex=" + zoomLevelIndex).append(", ")
					.append(neededIntervalX != null ? "neededIntervalX={" + neededIntervalX.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("zoomLevelIndex")
		public int getZoomLevelIndex() {
			return zoomLevelIndex;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("neededIntervalX")
		public UiLongInterval getNeededIntervalX() {
			return neededIntervalX;
		}

	}

	public static class ZoomedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected UiLongInterval intervalX;
		protected int zoomLevelIndex;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ZoomedEvent() {
			// default constructor for Jackson
		}

		public ZoomedEvent(String componentId, UiLongInterval intervalX, int zoomLevelIndex) {
			this.componentId = componentId;
			this.intervalX = intervalX;
			this.zoomLevelIndex = zoomLevelIndex;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TIME_GRAPH_ZOOMED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("zoomLevelIndex=" + zoomLevelIndex).append(", ")
					.append(intervalX != null ? "intervalX={" + intervalX.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("intervalX")
		public UiLongInterval getIntervalX() {
			return intervalX;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("zoomLevelIndex")
		public int getZoomLevelIndex() {
			return zoomLevelIndex;
		}

	}

	public static class IntervalSelectedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected UiLongInterval intervalX;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public IntervalSelectedEvent() {
			// default constructor for Jackson
		}

		public IntervalSelectedEvent(String componentId, UiLongInterval intervalX) {
			this.componentId = componentId;
			this.intervalX = intervalX;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_TIME_GRAPH_INTERVAL_SELECTED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(intervalX != null ? "intervalX={" + intervalX.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("intervalX")
		public UiLongInterval getIntervalX() {
			return intervalX;
		}

	}

	public static class SetIntervalXCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiLongInterval intervalX;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetIntervalXCommand() {
			// default constructor for Jackson
		}

		public SetIntervalXCommand(String componentId, UiLongInterval intervalX) {
			this.componentId = componentId;
			this.intervalX = intervalX;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(intervalX != null ? "intervalX={" + intervalX.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("intervalX")
		public UiLongInterval getIntervalX() {
			return intervalX;
		}

	}

	public static class SetMaxPixelsBetweenDataPointsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int maxPixelsBetweenDataPoints;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetMaxPixelsBetweenDataPointsCommand() {
			// default constructor for Jackson
		}

		public SetMaxPixelsBetweenDataPointsCommand(String componentId, int maxPixelsBetweenDataPoints) {
			this.componentId = componentId;
			this.maxPixelsBetweenDataPoints = maxPixelsBetweenDataPoints;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("maxPixelsBetweenDataPoints=" + maxPixelsBetweenDataPoints)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("maxPixelsBetweenDataPoints")
		public int getMaxPixelsBetweenDataPoints() {
			return maxPixelsBetweenDataPoints;
		}

	}

	public static class AddDataCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int zoomLevel;
		protected UiLongInterval intervalX;
		protected Map<String, List<UiTimeGraphDataPoint>> data;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddDataCommand() {
			// default constructor for Jackson
		}

		public AddDataCommand(String componentId, int zoomLevel, UiLongInterval intervalX, Map<String, List<UiTimeGraphDataPoint>> data) {
			this.componentId = componentId;
			this.zoomLevel = zoomLevel;
			this.intervalX = intervalX;
			this.data = data;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("zoomLevel=" + zoomLevel).append(", ")
					.append(intervalX != null ? "intervalX={" + intervalX.toString() + "}" : "").append(", ")
					.append(data != null ? "data={" + data.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("zoomLevel")
		public int getZoomLevel() {
			return zoomLevel;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("intervalX")
		public UiLongInterval getIntervalX() {
			return intervalX;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("data")
		public Map<String, List<UiTimeGraphDataPoint>> getData() {
			return data;
		}

	}

	public static class ResetAllDataCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<UiTimeChartZoomLevel> newZoomLevels;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ResetAllDataCommand() {
			// default constructor for Jackson
		}

		public ResetAllDataCommand(String componentId, List<UiTimeChartZoomLevel> newZoomLevels) {
			this.componentId = componentId;
			this.newZoomLevels = newZoomLevels;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(newZoomLevels != null ? "newZoomLevels={" + newZoomLevels.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("newZoomLevels")
		public List<UiTimeChartZoomLevel> getNewZoomLevels() {
			return newZoomLevels;
		}

	}

	public static class ReplaceAllDataCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<UiTimeChartZoomLevel> newZoomLevels;
		protected int zoomLevel;
		protected UiLongInterval intervalX;
		protected Map<String, List<UiTimeGraphDataPoint>> data;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ReplaceAllDataCommand() {
			// default constructor for Jackson
		}

		public ReplaceAllDataCommand(String componentId, List<UiTimeChartZoomLevel> newZoomLevels, int zoomLevel, UiLongInterval intervalX, Map<String, List<UiTimeGraphDataPoint>> data) {
			this.componentId = componentId;
			this.newZoomLevels = newZoomLevels;
			this.zoomLevel = zoomLevel;
			this.intervalX = intervalX;
			this.data = data;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("zoomLevel=" + zoomLevel).append(", ")
					.append(newZoomLevels != null ? "newZoomLevels={" + newZoomLevels.toString() + "}" : "").append(", ")
					.append(intervalX != null ? "intervalX={" + intervalX.toString() + "}" : "").append(", ")
					.append(data != null ? "data={" + data.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("newZoomLevels")
		public List<UiTimeChartZoomLevel> getNewZoomLevels() {
			return newZoomLevels;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("zoomLevel")
		public int getZoomLevel() {
			return zoomLevel;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("intervalX")
		public UiLongInterval getIntervalX() {
			return intervalX;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("data")
		public Map<String, List<UiTimeGraphDataPoint>> getData() {
			return data;
		}

	}

	public static class SetMouseScrollZoomPanModeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiLineChartMouseScrollZoomPanMode mouseScrollZoomPanMode;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetMouseScrollZoomPanModeCommand() {
			// default constructor for Jackson
		}

		public SetMouseScrollZoomPanModeCommand(String componentId, UiLineChartMouseScrollZoomPanMode mouseScrollZoomPanMode) {
			this.componentId = componentId;
			this.mouseScrollZoomPanMode = mouseScrollZoomPanMode;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("mouseScrollZoomPanMode=" + mouseScrollZoomPanMode)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mouseScrollZoomPanMode")
		public UiLineChartMouseScrollZoomPanMode getMouseScrollZoomPanMode() {
			return mouseScrollZoomPanMode;
		}

	}

	public static class SetSelectedIntervalCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiLongInterval intervalX;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetSelectedIntervalCommand() {
			// default constructor for Jackson
		}

		public SetSelectedIntervalCommand(String componentId, UiLongInterval intervalX) {
			this.componentId = componentId;
			this.intervalX = intervalX;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(intervalX != null ? "intervalX={" + intervalX.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("intervalX")
		public UiLongInterval getIntervalX() {
			return intervalX;
		}

	}

	public static class SetLinesCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<AbstractUiLineChartDataDisplay> lines;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetLinesCommand() {
			// default constructor for Jackson
		}

		public SetLinesCommand(String componentId, List<AbstractUiLineChartDataDisplay> lines) {
			this.componentId = componentId;
			this.lines = lines;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(lines != null ? "lines={" + lines.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("lines")
		public List<AbstractUiLineChartDataDisplay> getLines() {
			return lines;
		}

	}

	public static class SetLineCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String lineId;
		protected AbstractUiLineChartDataDisplay line;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetLineCommand() {
			// default constructor for Jackson
		}

		public SetLineCommand(String componentId, String lineId, AbstractUiLineChartDataDisplay line) {
			this.componentId = componentId;
			this.lineId = lineId;
			this.line = line;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("lineId=" + lineId).append(", ")
					.append(line != null ? "line={" + line.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("lineId")
		public String getLineId() {
			return lineId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("line")
		public AbstractUiLineChartDataDisplay getLine() {
			return line;
		}

	}

	public static class ZoomToCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiLongInterval intervalX;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ZoomToCommand() {
			// default constructor for Jackson
		}

		public ZoomToCommand(String componentId, UiLongInterval intervalX) {
			this.componentId = componentId;
			this.intervalX = intervalX;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(intervalX != null ? "intervalX={" + intervalX.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("intervalX")
		public UiLongInterval getIntervalX() {
			return intervalX;
		}

	}




}