package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiNavigationBar extends UiComponent implements UiObject {


	protected UiTemplate buttonTemplate;
	protected List<UiNavigationBarButton> buttons;
	protected UiColor backgroundColor = new UiColor(255, 255, 255).setAlpha(0.84f);
	protected UiColor borderColor;
	protected List<UiComponentReference> fanOutComponents;
	protected UiComponentReference multiProgressDisplay;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiNavigationBar() {
		// default constructor for Jackson
	}

	public UiNavigationBar(UiTemplate buttonTemplate) {
		super();
		this.buttonTemplate = buttonTemplate;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_NAVIGATION_BAR;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append(buttonTemplate != null ? "buttonTemplate={" + buttonTemplate.toString() + "}" : "").append(", ")
				.append(buttons != null ? "buttons={" + buttons.toString() + "}" : "").append(", ")
				.append(backgroundColor != null ? "backgroundColor={" + backgroundColor.toString() + "}" : "").append(", ")
				.append(borderColor != null ? "borderColor={" + borderColor.toString() + "}" : "").append(", ")
				.append(fanOutComponents != null ? "fanOutComponents={" + fanOutComponents.toString() + "}" : "").append(", ")
				.append(multiProgressDisplay != null ? "multiProgressDisplay={" + multiProgressDisplay.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("buttonTemplate")
	public UiTemplate getButtonTemplate() {
		return buttonTemplate;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("buttons")
	public List<UiNavigationBarButton> getButtons() {
		return buttons;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
	public UiColor getBackgroundColor() {
		return backgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("borderColor")
	public UiColor getBorderColor() {
		return borderColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("fanOutComponents")
	public List<UiComponentReference> getFanOutComponents() {
		return fanOutComponents;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("multiProgressDisplay")
	public UiComponentReference getMultiProgressDisplay() {
		return multiProgressDisplay;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiNavigationBar setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiNavigationBar setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiNavigationBar setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiNavigationBar setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("buttons")
	public UiNavigationBar setButtons(List<UiNavigationBarButton> buttons) {
		this.buttons = buttons;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundColor")
	public UiNavigationBar setBackgroundColor(UiColor backgroundColor) {
		this.backgroundColor = backgroundColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("borderColor")
	public UiNavigationBar setBorderColor(UiColor borderColor) {
		this.borderColor = borderColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("fanOutComponents")
	public UiNavigationBar setFanOutComponents(List<UiComponentReference> fanOutComponents) {
		this.fanOutComponents = fanOutComponents;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("multiProgressDisplay")
	public UiNavigationBar setMultiProgressDisplay(UiComponentReference multiProgressDisplay) {
		this.multiProgressDisplay = multiProgressDisplay;
		return this;
	}

	public static class ButtonClickedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String buttonId;
		protected String visibleFanOutComponentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ButtonClickedEvent() {
			// default constructor for Jackson
		}

		public ButtonClickedEvent(String componentId, String buttonId, String visibleFanOutComponentId) {
			this.componentId = componentId;
			this.buttonId = buttonId;
			this.visibleFanOutComponentId = visibleFanOutComponentId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_NAVIGATION_BAR_BUTTON_CLICKED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("buttonId=" + buttonId).append(", ")
					.append("visibleFanOutComponentId=" + visibleFanOutComponentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("buttonId")
		public String getButtonId() {
			return buttonId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("visibleFanOutComponentId")
		public String getVisibleFanOutComponentId() {
			return visibleFanOutComponentId;
		}

	}

	public static class FanoutClosedDueToClickOutsideFanoutEvent implements UiEvent {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public FanoutClosedDueToClickOutsideFanoutEvent() {
			// default constructor for Jackson
		}

		public FanoutClosedDueToClickOutsideFanoutEvent(String componentId) {
			this.componentId = componentId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_NAVIGATION_BAR_FANOUT_CLOSED_DUE_TO_CLICK_OUTSIDE_FANOUT;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class SetButtonsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<UiNavigationBarButton> buttons;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetButtonsCommand() {
			// default constructor for Jackson
		}

		public SetButtonsCommand(String componentId, List<UiNavigationBarButton> buttons) {
			this.componentId = componentId;
			this.buttons = buttons;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(buttons != null ? "buttons={" + buttons.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("buttons")
		public List<UiNavigationBarButton> getButtons() {
			return buttons;
		}

	}

	public static class SetButtonVisibleCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String buttonId;
		protected boolean visible;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetButtonVisibleCommand() {
			// default constructor for Jackson
		}

		public SetButtonVisibleCommand(String componentId, String buttonId, boolean visible) {
			this.componentId = componentId;
			this.buttonId = buttonId;
			this.visible = visible;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("buttonId=" + buttonId).append(", ")
					.append("visible=" + visible)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("buttonId")
		public String getButtonId() {
			return buttonId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("visible")
		public boolean getVisible() {
			return visible;
		}

	}

	public static class SetBackgroundColorCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiColor backgroundColor;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetBackgroundColorCommand() {
			// default constructor for Jackson
		}

		public SetBackgroundColorCommand(String componentId, UiColor backgroundColor) {
			this.componentId = componentId;
			this.backgroundColor = backgroundColor;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(backgroundColor != null ? "backgroundColor={" + backgroundColor.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
		public UiColor getBackgroundColor() {
			return backgroundColor;
		}

	}

	public static class SetBorderColorCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiColor borderColor;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetBorderColorCommand() {
			// default constructor for Jackson
		}

		public SetBorderColorCommand(String componentId, UiColor borderColor) {
			this.componentId = componentId;
			this.borderColor = borderColor;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(borderColor != null ? "borderColor={" + borderColor.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("borderColor")
		public UiColor getBorderColor() {
			return borderColor;
		}

	}

	public static class AddFanOutComponentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiComponentReference fanOutComponent;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddFanOutComponentCommand() {
			// default constructor for Jackson
		}

		public AddFanOutComponentCommand(String componentId, UiComponentReference fanOutComponent) {
			this.componentId = componentId;
			this.fanOutComponent = fanOutComponent;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(fanOutComponent != null ? "fanOutComponent={" + fanOutComponent.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fanOutComponent")
		public UiComponentReference getFanOutComponent() {
			return fanOutComponent;
		}

	}

	public static class RemoveFanOutComponentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiComponentReference fanOutComponent;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveFanOutComponentCommand() {
			// default constructor for Jackson
		}

		public RemoveFanOutComponentCommand(String componentId, UiComponentReference fanOutComponent) {
			this.componentId = componentId;
			this.fanOutComponent = fanOutComponent;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(fanOutComponent != null ? "fanOutComponent={" + fanOutComponent.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fanOutComponent")
		public UiComponentReference getFanOutComponent() {
			return fanOutComponent;
		}

	}

	public static class ShowFanOutComponentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiComponentReference fanOutComponent;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ShowFanOutComponentCommand() {
			// default constructor for Jackson
		}

		public ShowFanOutComponentCommand(String componentId, UiComponentReference fanOutComponent) {
			this.componentId = componentId;
			this.fanOutComponent = fanOutComponent;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(fanOutComponent != null ? "fanOutComponent={" + fanOutComponent.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("fanOutComponent")
		public UiComponentReference getFanOutComponent() {
			return fanOutComponent;
		}

	}

	public static class HideFanOutComponentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public HideFanOutComponentCommand() {
			// default constructor for Jackson
		}

		public HideFanOutComponentCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class SetMultiProgressDisplayCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiComponentReference multiProgressDisplay;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetMultiProgressDisplayCommand() {
			// default constructor for Jackson
		}

		public SetMultiProgressDisplayCommand(String componentId, UiComponentReference multiProgressDisplay) {
			this.componentId = componentId;
			this.multiProgressDisplay = multiProgressDisplay;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(multiProgressDisplay != null ? "multiProgressDisplay={" + multiProgressDisplay.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("multiProgressDisplay")
		public UiComponentReference getMultiProgressDisplay() {
			return multiProgressDisplay;
		}

	}




}