package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiPanel extends UiComponent implements UiObject {

	public enum HeaderComponentMinimizationPolicy {
		LEFT_COMPONENT_FIRST, RIGHT_COMPONENT_FIRST;

		@com.fasterxml.jackson.annotation.JsonValue
		public int jsonValue() {
			return ordinal();
		}
	}

	protected String icon;
	protected String title;
	protected UiPanelHeaderField leftHeaderField;
	protected UiPanelHeaderField rightHeaderField;
	protected HeaderComponentMinimizationPolicy headerComponentMinimizationPolicy = HeaderComponentMinimizationPolicy.LEFT_COMPONENT_FIRST;
	protected boolean alwaysShowHeaderFieldIcons = true;
	protected boolean hideTitleBar;
	protected UiComponentReference toolbar;
	protected UiComponentReference content;
	protected boolean stretchContent = true;
	protected int padding = 0;
	protected List<UiWindowButtonType> windowButtons;
	protected List<UiComponentReference> toolButtons;

	public UiPanel() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_PANEL;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("icon=" + icon).append(", ")
				.append("title=" + title).append(", ")
				.append("headerComponentMinimizationPolicy=" + headerComponentMinimizationPolicy).append(", ")
				.append("alwaysShowHeaderFieldIcons=" + alwaysShowHeaderFieldIcons).append(", ")
				.append("hideTitleBar=" + hideTitleBar).append(", ")
				.append("stretchContent=" + stretchContent).append(", ")
				.append("padding=" + padding).append(", ")
				.append("windowButtons=" + windowButtons).append(", ")
				.append(leftHeaderField != null ? "leftHeaderField={" + leftHeaderField.toString() + "}" : "").append(", ")
				.append(rightHeaderField != null ? "rightHeaderField={" + rightHeaderField.toString() + "}" : "").append(", ")
				.append(toolbar != null ? "toolbar={" + toolbar.toString() + "}" : "").append(", ")
				.append(content != null ? "content={" + content.toString() + "}" : "").append(", ")
				.append(toolButtons != null ? "toolButtons={" + toolButtons.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("icon")
	public String getIcon() {
		return icon;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("title")
	public String getTitle() {
		return title;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("leftHeaderField")
	public UiPanelHeaderField getLeftHeaderField() {
		return leftHeaderField;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("rightHeaderField")
	public UiPanelHeaderField getRightHeaderField() {
		return rightHeaderField;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("headerComponentMinimizationPolicy")
	public HeaderComponentMinimizationPolicy getHeaderComponentMinimizationPolicy() {
		return headerComponentMinimizationPolicy;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("alwaysShowHeaderFieldIcons")
	public boolean getAlwaysShowHeaderFieldIcons() {
		return alwaysShowHeaderFieldIcons;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("hideTitleBar")
	public boolean getHideTitleBar() {
		return hideTitleBar;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("toolbar")
	public UiComponentReference getToolbar() {
		return toolbar;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("content")
	public UiComponentReference getContent() {
		return content;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("stretchContent")
	public boolean getStretchContent() {
		return stretchContent;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("padding")
	public int getPadding() {
		return padding;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("windowButtons")
	public List<UiWindowButtonType> getWindowButtons() {
		return windowButtons;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("toolButtons")
	public List<UiComponentReference> getToolButtons() {
		return toolButtons;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiPanel setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiPanel setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiPanel setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiPanel setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("icon")
	public UiPanel setIcon(String icon) {
		this.icon = icon;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("title")
	public UiPanel setTitle(String title) {
		this.title = title;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("leftHeaderField")
	public UiPanel setLeftHeaderField(UiPanelHeaderField leftHeaderField) {
		this.leftHeaderField = leftHeaderField;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("rightHeaderField")
	public UiPanel setRightHeaderField(UiPanelHeaderField rightHeaderField) {
		this.rightHeaderField = rightHeaderField;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("headerComponentMinimizationPolicy")
	public UiPanel setHeaderComponentMinimizationPolicy(HeaderComponentMinimizationPolicy headerComponentMinimizationPolicy) {
		this.headerComponentMinimizationPolicy = headerComponentMinimizationPolicy;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("alwaysShowHeaderFieldIcons")
	public UiPanel setAlwaysShowHeaderFieldIcons(boolean alwaysShowHeaderFieldIcons) {
		this.alwaysShowHeaderFieldIcons = alwaysShowHeaderFieldIcons;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("hideTitleBar")
	public UiPanel setHideTitleBar(boolean hideTitleBar) {
		this.hideTitleBar = hideTitleBar;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("toolbar")
	public UiPanel setToolbar(UiComponentReference toolbar) {
		this.toolbar = toolbar;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("content")
	public UiPanel setContent(UiComponentReference content) {
		this.content = content;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stretchContent")
	public UiPanel setStretchContent(boolean stretchContent) {
		this.stretchContent = stretchContent;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("padding")
	public UiPanel setPadding(int padding) {
		this.padding = padding;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("windowButtons")
	public UiPanel setWindowButtons(List<UiWindowButtonType> windowButtons) {
		this.windowButtons = windowButtons;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("toolButtons")
	public UiPanel setToolButtons(List<UiComponentReference> toolButtons) {
		this.toolButtons = toolButtons;
		return this;
	}

	public static class WindowButtonClickedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected UiWindowButtonType windowButton;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public WindowButtonClickedEvent() {
			// default constructor for Jackson
		}

		public WindowButtonClickedEvent(String componentId, UiWindowButtonType windowButton) {
			this.componentId = componentId;
			this.windowButton = windowButton;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_PANEL_WINDOW_BUTTON_CLICKED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("windowButton=" + windowButton)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("windowButton")
		public UiWindowButtonType getWindowButton() {
			return windowButton;
		}

	}

	public static class SetContentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiComponentReference content;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetContentCommand() {
			// default constructor for Jackson
		}

		public SetContentCommand(String componentId, UiComponentReference content) {
			this.componentId = componentId;
			this.content = content;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(content != null ? "content={" + content.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("content")
		public UiComponentReference getContent() {
			return content;
		}

	}

	public static class SetLeftHeaderFieldCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiPanelHeaderField field;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetLeftHeaderFieldCommand() {
			// default constructor for Jackson
		}

		public SetLeftHeaderFieldCommand(String componentId, UiPanelHeaderField field) {
			this.componentId = componentId;
			this.field = field;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(field != null ? "field={" + field.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("field")
		public UiPanelHeaderField getField() {
			return field;
		}

	}

	public static class SetRightHeaderFieldCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiPanelHeaderField field;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetRightHeaderFieldCommand() {
			// default constructor for Jackson
		}

		public SetRightHeaderFieldCommand(String componentId, UiPanelHeaderField field) {
			this.componentId = componentId;
			this.field = field;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(field != null ? "field={" + field.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("field")
		public UiPanelHeaderField getField() {
			return field;
		}

	}

	public static class SetTitleCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String title;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetTitleCommand() {
			// default constructor for Jackson
		}

		public SetTitleCommand(String componentId, String title) {
			this.componentId = componentId;
			this.title = title;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("title=" + title)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("title")
		public String getTitle() {
			return title;
		}

	}

	public static class SetIconCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String icon;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetIconCommand() {
			// default constructor for Jackson
		}

		public SetIconCommand(String componentId, String icon) {
			this.componentId = componentId;
			this.icon = icon;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("icon=" + icon)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("icon")
		public String getIcon() {
			return icon;
		}

	}

	public static class SetToolbarCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiComponentReference toolbar;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetToolbarCommand() {
			// default constructor for Jackson
		}

		public SetToolbarCommand(String componentId, UiComponentReference toolbar) {
			this.componentId = componentId;
			this.toolbar = toolbar;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(toolbar != null ? "toolbar={" + toolbar.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("toolbar")
		public UiComponentReference getToolbar() {
			return toolbar;
		}

	}

	public static class SetMaximizedCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected boolean maximized;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetMaximizedCommand() {
			// default constructor for Jackson
		}

		public SetMaximizedCommand(String componentId, boolean maximized) {
			this.componentId = componentId;
			this.maximized = maximized;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("maximized=" + maximized)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("maximized")
		public boolean getMaximized() {
			return maximized;
		}

	}

	public static class SetWindowButtonsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<UiWindowButtonType> windowButtons;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetWindowButtonsCommand() {
			// default constructor for Jackson
		}

		public SetWindowButtonsCommand(String componentId, List<UiWindowButtonType> windowButtons) {
			this.componentId = componentId;
			this.windowButtons = windowButtons;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("windowButtons=" + windowButtons)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("windowButtons")
		public List<UiWindowButtonType> getWindowButtons() {
			return windowButtons;
		}

	}

	public static class SetToolButtonsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<UiComponentReference> toolButtons;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetToolButtonsCommand() {
			// default constructor for Jackson
		}

		public SetToolButtonsCommand(String componentId, List<UiComponentReference> toolButtons) {
			this.componentId = componentId;
			this.toolButtons = toolButtons;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(toolButtons != null ? "toolButtons={" + toolButtons.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("toolButtons")
		public List<UiComponentReference> getToolButtons() {
			return toolButtons;
		}

	}

	public static class SetStretchContentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected boolean stretch;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetStretchContentCommand() {
			// default constructor for Jackson
		}

		public SetStretchContentCommand(String componentId, boolean stretch) {
			this.componentId = componentId;
			this.stretch = stretch;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("stretch=" + stretch)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("stretch")
		public boolean getStretch() {
			return stretch;
		}

	}




}