/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiColor;
import org.teamapps.dto.UiLineType;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiLine
implements UiObject {
    protected float thickness;
    protected UiColor color;
    protected UiLineType type = UiLineType.SOLID;

    @Deprecated
    public UiLine() {
    }

    public UiLine(float thickness, UiColor color) {
        this.thickness = thickness;
        this.color = color;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_LINE;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("thickness=" + this.thickness) + ", " + ("type=" + this.type) + ", " + (String)(this.color != null ? "color={" + this.color.toString() + "}" : "");
    }

    @JsonGetter(value="thickness")
    public float getThickness() {
        return this.thickness;
    }

    @JsonGetter(value="color")
    public UiColor getColor() {
        return this.color;
    }

    @JsonGetter(value="type")
    public UiLineType getType() {
        return this.type;
    }

    @JsonSetter(value="type")
    public UiLine setType(UiLineType type) {
        this.type = type;
        return this;
    }
}

