package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public abstract class AbstractUiToolContainer extends UiComponent implements UiObject {


	protected List<UiToolbarButtonGroup> buttonGroups;
	protected UiColor backgroundColor = new UiColor(255, 255, 255).setAlpha(0.84f);

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public AbstractUiToolContainer() {
		// default constructor for Jackson
	}

	public AbstractUiToolContainer(List<UiToolbarButtonGroup> buttonGroups) {
		super();
		this.buttonGroups = buttonGroups;
	}


	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append(buttonGroups != null ? "buttonGroups={" + buttonGroups.toString() + "}" : "").append(", ")
				.append(backgroundColor != null ? "backgroundColor={" + backgroundColor.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("buttonGroups")
	public List<UiToolbarButtonGroup> getButtonGroups() {
		return buttonGroups;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
	public UiColor getBackgroundColor() {
		return backgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public AbstractUiToolContainer setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public AbstractUiToolContainer setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public AbstractUiToolContainer setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public AbstractUiToolContainer setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundColor")
	public AbstractUiToolContainer setBackgroundColor(UiColor backgroundColor) {
		this.backgroundColor = backgroundColor;
		return this;
	}

	public static class ToolbarButtonClickEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String groupId;
		protected String buttonId;
		protected UiDropDownButtonClickInfo dropDownClickInfo;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ToolbarButtonClickEvent() {
			// default constructor for Jackson
		}

		public ToolbarButtonClickEvent(String componentId, String groupId, String buttonId, UiDropDownButtonClickInfo dropDownClickInfo) {
			this.componentId = componentId;
			this.groupId = groupId;
			this.buttonId = buttonId;
			this.dropDownClickInfo = dropDownClickInfo;
		}

		public UiEventType getUiEventType() {
			return UiEventType.ABSTRACT_UI_TOOL_CONTAINER_TOOLBAR_BUTTON_CLICK;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("groupId=" + groupId).append(", ")
					.append("buttonId=" + buttonId).append(", ")
					.append(dropDownClickInfo != null ? "dropDownClickInfo={" + dropDownClickInfo.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("groupId")
		public String getGroupId() {
			return groupId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("buttonId")
		public String getButtonId() {
			return buttonId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("dropDownClickInfo")
		public UiDropDownButtonClickInfo getDropDownClickInfo() {
			return dropDownClickInfo;
		}

	}

	public static class ToolbarDropDownItemClickEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String groupId;
		protected String buttonId;
		protected String dropDownGroupId;

		@JsonSerialize(using = ObjectSerializer.class)
		@JsonDeserialize(using = ObjectDeserializer.class)
		protected Object dropDownItemId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ToolbarDropDownItemClickEvent() {
			// default constructor for Jackson
		}

		public ToolbarDropDownItemClickEvent(String componentId, String groupId, String buttonId, String dropDownGroupId, Object dropDownItemId) {
			this.componentId = componentId;
			this.groupId = groupId;
			this.buttonId = buttonId;
			this.dropDownGroupId = dropDownGroupId;
			this.dropDownItemId = dropDownItemId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.ABSTRACT_UI_TOOL_CONTAINER_TOOLBAR_DROP_DOWN_ITEM_CLICK;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("groupId=" + groupId).append(", ")
					.append("buttonId=" + buttonId).append(", ")
					.append("dropDownGroupId=" + dropDownGroupId).append(", ")
					.append("dropDownItemId=" + dropDownItemId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("groupId")
		public String getGroupId() {
			return groupId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("buttonId")
		public String getButtonId() {
			return buttonId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("dropDownGroupId")
		public String getDropDownGroupId() {
			return dropDownGroupId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("dropDownItemId")
		public Object getDropDownItemId() {
			return dropDownItemId;
		}

	}

	public static class SetButtonVisibleCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String groupId;
		protected String buttonId;
		protected boolean visible;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetButtonVisibleCommand() {
			// default constructor for Jackson
		}

		public SetButtonVisibleCommand(String componentId, String groupId, String buttonId, boolean visible) {
			this.componentId = componentId;
			this.groupId = groupId;
			this.buttonId = buttonId;
			this.visible = visible;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("groupId=" + groupId).append(", ")
					.append("buttonId=" + buttonId).append(", ")
					.append("visible=" + visible)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("groupId")
		public String getGroupId() {
			return groupId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("buttonId")
		public String getButtonId() {
			return buttonId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("visible")
		public boolean getVisible() {
			return visible;
		}

	}

	public static class SetButtonColorsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String groupId;
		protected String buttonId;
		protected UiColor backgroundColor;
		protected UiColor hoverBackgroundColor;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetButtonColorsCommand() {
			// default constructor for Jackson
		}

		public SetButtonColorsCommand(String componentId, String groupId, String buttonId, UiColor backgroundColor, UiColor hoverBackgroundColor) {
			this.componentId = componentId;
			this.groupId = groupId;
			this.buttonId = buttonId;
			this.backgroundColor = backgroundColor;
			this.hoverBackgroundColor = hoverBackgroundColor;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("groupId=" + groupId).append(", ")
					.append("buttonId=" + buttonId).append(", ")
					.append(backgroundColor != null ? "backgroundColor={" + backgroundColor.toString() + "}" : "").append(", ")
					.append(hoverBackgroundColor != null ? "hoverBackgroundColor={" + hoverBackgroundColor.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("groupId")
		public String getGroupId() {
			return groupId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("buttonId")
		public String getButtonId() {
			return buttonId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
		public UiColor getBackgroundColor() {
			return backgroundColor;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("hoverBackgroundColor")
		public UiColor getHoverBackgroundColor() {
			return hoverBackgroundColor;
		}

	}

	public static class SetButtonGroupVisibleCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String groupId;
		protected boolean visible;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetButtonGroupVisibleCommand() {
			// default constructor for Jackson
		}

		public SetButtonGroupVisibleCommand(String componentId, String groupId, boolean visible) {
			this.componentId = componentId;
			this.groupId = groupId;
			this.visible = visible;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("groupId=" + groupId).append(", ")
					.append("visible=" + visible)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("groupId")
		public String getGroupId() {
			return groupId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("visible")
		public boolean getVisible() {
			return visible;
		}

	}

	public static class AddButtonCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String groupId;
		protected UiToolbarButton button;
		protected String neighborButtonId;
		protected boolean beforeNeighbor;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddButtonCommand() {
			// default constructor for Jackson
		}

		public AddButtonCommand(String componentId, String groupId, UiToolbarButton button, String neighborButtonId, boolean beforeNeighbor) {
			this.componentId = componentId;
			this.groupId = groupId;
			this.button = button;
			this.neighborButtonId = neighborButtonId;
			this.beforeNeighbor = beforeNeighbor;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("groupId=" + groupId).append(", ")
					.append("neighborButtonId=" + neighborButtonId).append(", ")
					.append("beforeNeighbor=" + beforeNeighbor).append(", ")
					.append(button != null ? "button={" + button.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("groupId")
		public String getGroupId() {
			return groupId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("button")
		public UiToolbarButton getButton() {
			return button;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("neighborButtonId")
		public String getNeighborButtonId() {
			return neighborButtonId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("beforeNeighbor")
		public boolean getBeforeNeighbor() {
			return beforeNeighbor;
		}

	}

	public static class RemoveButtonCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String groupId;
		protected String buttonId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveButtonCommand() {
			// default constructor for Jackson
		}

		public RemoveButtonCommand(String componentId, String groupId, String buttonId) {
			this.componentId = componentId;
			this.groupId = groupId;
			this.buttonId = buttonId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("groupId=" + groupId).append(", ")
					.append("buttonId=" + buttonId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("groupId")
		public String getGroupId() {
			return groupId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("buttonId")
		public String getButtonId() {
			return buttonId;
		}

	}

	public static class AddButtonGroupCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiToolbarButtonGroup group;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddButtonGroupCommand() {
			// default constructor for Jackson
		}

		public AddButtonGroupCommand(String componentId, UiToolbarButtonGroup group) {
			this.componentId = componentId;
			this.group = group;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(group != null ? "group={" + group.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("group")
		public UiToolbarButtonGroup getGroup() {
			return group;
		}

	}

	public static class RemoveButtonGroupCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String groupId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveButtonGroupCommand() {
			// default constructor for Jackson
		}

		public RemoveButtonGroupCommand(String componentId, String groupId) {
			this.componentId = componentId;
			this.groupId = groupId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("groupId=" + groupId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("groupId")
		public String getGroupId() {
			return groupId;
		}

	}

	public static class SetButtonHasDropDownCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String groupId;
		protected String buttonId;
		protected boolean hasDropDown;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetButtonHasDropDownCommand() {
			// default constructor for Jackson
		}

		public SetButtonHasDropDownCommand(String componentId, String groupId, String buttonId, boolean hasDropDown) {
			this.componentId = componentId;
			this.groupId = groupId;
			this.buttonId = buttonId;
			this.hasDropDown = hasDropDown;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("groupId=" + groupId).append(", ")
					.append("buttonId=" + buttonId).append(", ")
					.append("hasDropDown=" + hasDropDown)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("groupId")
		public String getGroupId() {
			return groupId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("buttonId")
		public String getButtonId() {
			return buttonId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("hasDropDown")
		public boolean getHasDropDown() {
			return hasDropDown;
		}

	}

	public static class SetDropDownComponentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String groupId;
		protected String buttonId;
		protected UiComponentReference component;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetDropDownComponentCommand() {
			// default constructor for Jackson
		}

		public SetDropDownComponentCommand(String componentId, String groupId, String buttonId, UiComponentReference component) {
			this.componentId = componentId;
			this.groupId = groupId;
			this.buttonId = buttonId;
			this.component = component;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("groupId=" + groupId).append(", ")
					.append("buttonId=" + buttonId).append(", ")
					.append(component != null ? "component={" + component.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("groupId")
		public String getGroupId() {
			return groupId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("buttonId")
		public String getButtonId() {
			return buttonId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("component")
		public UiComponentReference getComponent() {
			return component;
		}

	}

	public static class UpdateButtonGroupsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<UiToolbarButtonGroup> buttonGroups;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UpdateButtonGroupsCommand() {
			// default constructor for Jackson
		}

		public UpdateButtonGroupsCommand(String componentId, List<UiToolbarButtonGroup> buttonGroups) {
			this.componentId = componentId;
			this.buttonGroups = buttonGroups;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(buttonGroups != null ? "buttonGroups={" + buttonGroups.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("buttonGroups")
		public List<UiToolbarButtonGroup> getButtonGroups() {
			return buttonGroups;
		}

	}




}