package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiMobileLayout extends UiComponent implements UiObject {


	protected UiComponentReference toolbar;
	protected UiComponentReference initialView;
	protected UiComponentReference navigationBar;

	public UiMobileLayout() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_MOBILE_LAYOUT;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append(toolbar != null ? "toolbar={" + toolbar.toString() + "}" : "").append(", ")
				.append(initialView != null ? "initialView={" + initialView.toString() + "}" : "").append(", ")
				.append(navigationBar != null ? "navigationBar={" + navigationBar.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("toolbar")
	public UiComponentReference getToolbar() {
		return toolbar;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("initialView")
	public UiComponentReference getInitialView() {
		return initialView;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("navigationBar")
	public UiComponentReference getNavigationBar() {
		return navigationBar;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiMobileLayout setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiMobileLayout setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiMobileLayout setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiMobileLayout setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("toolbar")
	public UiMobileLayout setToolbar(UiComponentReference toolbar) {
		this.toolbar = toolbar;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("initialView")
	public UiMobileLayout setInitialView(UiComponentReference initialView) {
		this.initialView = initialView;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("navigationBar")
	public UiMobileLayout setNavigationBar(UiComponentReference navigationBar) {
		this.navigationBar = navigationBar;
		return this;
	}


	public static class SetToolbarCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiComponentReference toolbar;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetToolbarCommand() {
			// default constructor for Jackson
		}

		public SetToolbarCommand(String componentId, UiComponentReference toolbar) {
			this.componentId = componentId;
			this.toolbar = toolbar;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(toolbar != null ? "toolbar={" + toolbar.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("toolbar")
		public UiComponentReference getToolbar() {
			return toolbar;
		}

	}

	public static class SetNavigationBarCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiComponentReference navBar;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetNavigationBarCommand() {
			// default constructor for Jackson
		}

		public SetNavigationBarCommand(String componentId, UiComponentReference navBar) {
			this.componentId = componentId;
			this.navBar = navBar;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(navBar != null ? "navBar={" + navBar.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("navBar")
		public UiComponentReference getNavBar() {
			return navBar;
		}

	}

	public static class ShowViewCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiComponentReference component;
		protected UiPageTransition animation;
		protected int animationDuration;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ShowViewCommand() {
			// default constructor for Jackson
		}

		public ShowViewCommand(String componentId, UiComponentReference component, UiPageTransition animation, int animationDuration) {
			this.componentId = componentId;
			this.component = component;
			this.animation = animation;
			this.animationDuration = animationDuration;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("animation=" + animation).append(", ")
					.append("animationDuration=" + animationDuration).append(", ")
					.append(component != null ? "component={" + component.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("component")
		public UiComponentReference getComponent() {
			return component;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("animation")
		public UiPageTransition getAnimation() {
			return animation;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("animationDuration")
		public int getAnimationDuration() {
			return animationDuration;
		}

	}




}