/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.ObjectDeserializer;
import org.teamapps.dto.ObjectSerializer;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiColor;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiMediaDeviceInfo;
import org.teamapps.dto.UiMediaSoupPlaybackParamaters;
import org.teamapps.dto.UiMediaSoupPublishingParameters;
import org.teamapps.dto.UiMulticastPlaybackProfile;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.WebRtcClientSpinnerPolicy;
import org.teamapps.dto.WebRtcPublishingFailureReason;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiMediaSoupV2WebRtcClient
extends UiComponent
implements UiObject {
    @JsonSerialize(using=ObjectSerializer.class)
    @JsonDeserialize(using=ObjectDeserializer.class)
    protected Object initialPlaybackOrPublishParams;
    protected Float displayAreaAspectRatio = Float.valueOf(1.3333334f);
    protected boolean activityLineVisible;
    protected UiColor activityInactiveColor;
    protected UiColor activityActiveColor;
    protected boolean active;
    protected List<String> icons;
    protected String caption;
    protected String noVideoImageUrl;
    protected WebRtcClientSpinnerPolicy spinnerPolicy;
    protected float playbackVolume = 1.0f;
    protected boolean contextMenuEnabled = false;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("initialPlaybackOrPublishParams=" + this.initialPlaybackOrPublishParams) + ", " + ("displayAreaAspectRatio=" + this.displayAreaAspectRatio) + ", " + ("activityLineVisible=" + this.activityLineVisible) + ", " + ("active=" + this.active) + ", " + ("icons=" + this.icons) + ", " + ("caption=" + this.caption) + ", " + ("noVideoImageUrl=" + this.noVideoImageUrl) + ", " + ("spinnerPolicy=" + this.spinnerPolicy) + ", " + ("playbackVolume=" + this.playbackVolume) + ", " + ("contextMenuEnabled=" + this.contextMenuEnabled) + ", " + (String)(this.activityInactiveColor != null ? "activityInactiveColor={" + this.activityInactiveColor.toString() + "}" : "") + ", " + (String)(this.activityActiveColor != null ? "activityActiveColor={" + this.activityActiveColor.toString() + "}" : "");
    }

    @JsonGetter(value="initialPlaybackOrPublishParams")
    public Object getInitialPlaybackOrPublishParams() {
        return this.initialPlaybackOrPublishParams;
    }

    @JsonGetter(value="displayAreaAspectRatio")
    public Float getDisplayAreaAspectRatio() {
        return this.displayAreaAspectRatio;
    }

    @JsonGetter(value="activityLineVisible")
    public boolean getActivityLineVisible() {
        return this.activityLineVisible;
    }

    @JsonGetter(value="activityInactiveColor")
    public UiColor getActivityInactiveColor() {
        return this.activityInactiveColor;
    }

    @JsonGetter(value="activityActiveColor")
    public UiColor getActivityActiveColor() {
        return this.activityActiveColor;
    }

    @JsonGetter(value="active")
    public boolean getActive() {
        return this.active;
    }

    @JsonGetter(value="icons")
    public List<String> getIcons() {
        return this.icons;
    }

    @JsonGetter(value="caption")
    public String getCaption() {
        return this.caption;
    }

    @JsonGetter(value="noVideoImageUrl")
    public String getNoVideoImageUrl() {
        return this.noVideoImageUrl;
    }

    @JsonGetter(value="spinnerPolicy")
    public WebRtcClientSpinnerPolicy getSpinnerPolicy() {
        return this.spinnerPolicy;
    }

    @JsonGetter(value="playbackVolume")
    public float getPlaybackVolume() {
        return this.playbackVolume;
    }

    @JsonGetter(value="contextMenuEnabled")
    public boolean getContextMenuEnabled() {
        return this.contextMenuEnabled;
    }

    @Override
    @JsonSetter(value="id")
    public UiMediaSoupV2WebRtcClient setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiMediaSoupV2WebRtcClient setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiMediaSoupV2WebRtcClient setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiMediaSoupV2WebRtcClient setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="initialPlaybackOrPublishParams")
    public UiMediaSoupV2WebRtcClient setInitialPlaybackOrPublishParams(Object initialPlaybackOrPublishParams) {
        this.initialPlaybackOrPublishParams = initialPlaybackOrPublishParams;
        return this;
    }

    @JsonSetter(value="displayAreaAspectRatio")
    public UiMediaSoupV2WebRtcClient setDisplayAreaAspectRatio(Float displayAreaAspectRatio) {
        this.displayAreaAspectRatio = displayAreaAspectRatio;
        return this;
    }

    @JsonSetter(value="activityLineVisible")
    public UiMediaSoupV2WebRtcClient setActivityLineVisible(boolean activityLineVisible) {
        this.activityLineVisible = activityLineVisible;
        return this;
    }

    @JsonSetter(value="activityInactiveColor")
    public UiMediaSoupV2WebRtcClient setActivityInactiveColor(UiColor activityInactiveColor) {
        this.activityInactiveColor = activityInactiveColor;
        return this;
    }

    @JsonSetter(value="activityActiveColor")
    public UiMediaSoupV2WebRtcClient setActivityActiveColor(UiColor activityActiveColor) {
        this.activityActiveColor = activityActiveColor;
        return this;
    }

    @JsonSetter(value="active")
    public UiMediaSoupV2WebRtcClient setActive(boolean active) {
        this.active = active;
        return this;
    }

    @JsonSetter(value="icons")
    public UiMediaSoupV2WebRtcClient setIcons(List<String> icons) {
        this.icons = icons;
        return this;
    }

    @JsonSetter(value="caption")
    public UiMediaSoupV2WebRtcClient setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    @JsonSetter(value="noVideoImageUrl")
    public UiMediaSoupV2WebRtcClient setNoVideoImageUrl(String noVideoImageUrl) {
        this.noVideoImageUrl = noVideoImageUrl;
        return this;
    }

    @JsonSetter(value="spinnerPolicy")
    public UiMediaSoupV2WebRtcClient setSpinnerPolicy(WebRtcClientSpinnerPolicy spinnerPolicy) {
        this.spinnerPolicy = spinnerPolicy;
        return this;
    }

    @JsonSetter(value="playbackVolume")
    public UiMediaSoupV2WebRtcClient setPlaybackVolume(float playbackVolume) {
        this.playbackVolume = playbackVolume;
        return this;
    }

    @JsonSetter(value="contextMenuEnabled")
    public UiMediaSoupV2WebRtcClient setContextMenuEnabled(boolean contextMenuEnabled) {
        this.contextMenuEnabled = contextMenuEnabled;
        return this;
    }

    public static class EnumerateDevicesCommand
    implements UiCommand<List<UiMediaDeviceInfo>> {
        public String toString() {
            return this.getClass().getSimpleName() + ": ";
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class CloseContextMenuCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int requestId;

        @Deprecated
        public CloseContextMenuCommand() {
        }

        public CloseContextMenuCommand(String componentId, int requestId) {
            this.componentId = componentId;
            this.requestId = requestId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("requestId=" + this.requestId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="requestId")
        public int getRequestId() {
            return this.requestId;
        }
    }

    public static class SetContextMenuContentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int requestId;
        protected UiClientObjectReference component;

        @Deprecated
        public SetContextMenuContentCommand() {
        }

        public SetContextMenuContentCommand(String componentId, int requestId, UiClientObjectReference component) {
            this.componentId = componentId;
            this.requestId = requestId;
            this.component = component;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("requestId=" + this.requestId) + ", " + (String)(this.component != null ? "component={" + this.component.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="requestId")
        public int getRequestId() {
            return this.requestId;
        }

        @JsonGetter(value="component")
        public UiClientObjectReference getComponent() {
            return this.component;
        }
    }

    public static class StopCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public StopCommand() {
        }

        public StopCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class PlaybackCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiMediaSoupPlaybackParamaters parameters;

        @Deprecated
        public PlaybackCommand() {
        }

        public PlaybackCommand(String componentId, UiMediaSoupPlaybackParamaters parameters) {
            this.componentId = componentId;
            this.parameters = parameters;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.parameters != null ? "parameters={" + this.parameters.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="parameters")
        public UiMediaSoupPlaybackParamaters getParameters() {
            return this.parameters;
        }
    }

    public static class PublishCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiMediaSoupPublishingParameters parameters;

        @Deprecated
        public PublishCommand() {
        }

        public PublishCommand(String componentId, UiMediaSoupPublishingParameters parameters) {
            this.componentId = componentId;
            this.parameters = parameters;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.parameters != null ? "parameters={" + this.parameters.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="parameters")
        public UiMediaSoupPublishingParameters getParameters() {
            return this.parameters;
        }
    }

    public static class SetActiveCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected boolean active;

        @Deprecated
        public SetActiveCommand() {
        }

        public SetActiveCommand(String componentId, boolean active) {
            this.componentId = componentId;
            this.active = active;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("active=" + this.active);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="active")
        public boolean getActive() {
            return this.active;
        }
    }

    public static class UpdateCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiMediaSoupV2WebRtcClient config;

        @Deprecated
        public UpdateCommand() {
        }

        public UpdateCommand(String componentId, UiMediaSoupV2WebRtcClient config) {
            this.componentId = componentId;
            this.config = config;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.config != null ? "config={" + this.config.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="config")
        public UiMediaSoupV2WebRtcClient getConfig() {
            return this.config;
        }
    }

    public static class ContextMenuRequestedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int requestId;

        @Deprecated
        public ContextMenuRequestedEvent() {
        }

        public ContextMenuRequestedEvent(String componentId, int requestId) {
            this.componentId = componentId;
            this.requestId = requestId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_CONTEXT_MENU_REQUESTED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("requestId=" + this.requestId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="requestId")
        public int getRequestId() {
            return this.requestId;
        }
    }

    public static class ClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public ClickedEvent() {
        }

        public ClickedEvent(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class VoiceActivityChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected boolean active;

        @Deprecated
        public VoiceActivityChangedEvent() {
        }

        public VoiceActivityChangedEvent(String componentId, boolean active) {
            this.componentId = componentId;
            this.active = active;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_VOICE_ACTIVITY_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("active=" + this.active);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="active")
        public boolean getActive() {
            return this.active;
        }
    }

    public static class PlaybackProfileChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected UiMulticastPlaybackProfile profile;

        @Deprecated
        public PlaybackProfileChangedEvent() {
        }

        public PlaybackProfileChangedEvent(String componentId, UiMulticastPlaybackProfile profile) {
            this.componentId = componentId;
            this.profile = profile;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_PLAYBACK_PROFILE_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("profile=" + this.profile);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="profile")
        public UiMulticastPlaybackProfile getProfile() {
            return this.profile;
        }
    }

    public static class PlaybackFailedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public PlaybackFailedEvent() {
        }

        public PlaybackFailedEvent(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_PLAYBACK_FAILED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class PlaybackSucceededEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public PlaybackSucceededEvent() {
        }

        public PlaybackSucceededEvent(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_PLAYBACK_SUCCEEDED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class ConnectionStateChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected boolean connected;

        @Deprecated
        public ConnectionStateChangedEvent() {
        }

        public ConnectionStateChangedEvent(String componentId, boolean connected) {
            this.componentId = componentId;
            this.connected = connected;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_CONNECTION_STATE_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("connected=" + this.connected);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="connected")
        public boolean getConnected() {
            return this.connected;
        }
    }

    public static class PublishedStreamsStatusChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected boolean audio;
        protected boolean video;

        @Deprecated
        public PublishedStreamsStatusChangedEvent() {
        }

        public PublishedStreamsStatusChangedEvent(String componentId, boolean audio, boolean video) {
            this.componentId = componentId;
            this.audio = audio;
            this.video = video;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_PUBLISHED_STREAMS_STATUS_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("audio=" + this.audio) + ", " + ("video=" + this.video);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="audio")
        public boolean getAudio() {
            return this.audio;
        }

        @JsonGetter(value="video")
        public boolean getVideo() {
            return this.video;
        }
    }

    public static class PublishedStreamEndedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected boolean isDisplay;

        @Deprecated
        public PublishedStreamEndedEvent() {
        }

        public PublishedStreamEndedEvent(String componentId, boolean isDisplay) {
            this.componentId = componentId;
            this.isDisplay = isDisplay;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_PUBLISHED_STREAM_ENDED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("isDisplay=" + this.isDisplay);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="isDisplay")
        public boolean getIsDisplay() {
            return this.isDisplay;
        }
    }

    public static class PublishingFailedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected WebRtcPublishingFailureReason reason;
        protected String errorMessage;

        @Deprecated
        public PublishingFailedEvent() {
        }

        public PublishingFailedEvent(String componentId, WebRtcPublishingFailureReason reason, String errorMessage) {
            this.componentId = componentId;
            this.reason = reason;
            this.errorMessage = errorMessage;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_PUBLISHING_FAILED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("reason=" + this.reason) + ", " + ("errorMessage=" + this.errorMessage);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="reason")
        public WebRtcPublishingFailureReason getReason() {
            return this.reason;
        }

        @JsonGetter(value="errorMessage")
        public String getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static class PublishingSucceededEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public PublishingSucceededEvent() {
        }

        public PublishingSucceededEvent(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_PUBLISHING_SUCCEEDED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }
}

