/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.ObjectDeserializer;
import org.teamapps.dto.ObjectSerializer;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiColor;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiFieldMessage;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiSelectionFrame;
import org.teamapps.dto.UiSortDirection;
import org.teamapps.dto.UiTableClientRecord;
import org.teamapps.dto.UiTableColumn;
import org.teamapps.dto.UiTableDataRequest;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiTable
extends UiComponent
implements UiObject {
    protected List<UiTableColumn> columns;
    protected boolean displayAsList;
    protected boolean forceFitWidth;
    protected int rowHeight = 28;
    protected boolean stripedRows = true;
    protected UiColor stripedRowColorEven = new UiColor(255, 255, 255);
    protected UiColor stripedRowColorOdd = new UiColor(0, 0, 0).setAlpha(0.05f);
    protected boolean hideHeaders;
    protected boolean allowMultiRowSelection = true;
    protected UiColor selectionColor = new UiColor(222, 238, 255);
    protected int rowBorderWidth = 1;
    protected UiColor rowBorderColor = new UiColor(204, 204, 204);
    protected boolean showRowCheckBoxes;
    protected boolean showNumbering;
    protected List<UiTableClientRecord> tableData;
    protected int totalNumberOfRecords;
    protected String sortField;
    protected UiSortDirection sortDirection = UiSortDirection.ASC;
    protected boolean editable;
    protected boolean treeMode;
    protected String indentedColumnName;
    protected int indentation = 15;
    protected UiSelectionFrame selectionFrame;
    protected boolean contextMenuEnabled = false;
    protected boolean showHeaderRow = false;
    protected int headerRowBorderWidth = 1;
    protected UiColor headerRowBorderColor = new UiColor(204, 204, 204);
    protected int headerRowHeight = 28;
    protected UiColor headerRowBackgroundColor = new UiColor(0, 0, 0).setAlpha(0.05f);
    protected Map<String, UiClientObjectReference> headerRowFields;
    protected boolean showFooterRow = false;
    protected int footerRowBorderWidth = 1;
    protected UiColor footerRowBorderColor = new UiColor(204, 204, 204);
    protected int footerRowHeight = 28;
    protected UiColor footerRowBackgroundColor = new UiColor(0, 0, 0).setAlpha(0.05f);
    protected Map<String, UiClientObjectReference> footerRowFields;

    @Deprecated
    public UiTable() {
    }

    public UiTable(List<UiTableColumn> columns) {
        this.columns = columns;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_TABLE;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("indentedColumnName=" + this.indentedColumnName) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("displayAsList=" + this.displayAsList) + ", " + ("forceFitWidth=" + this.forceFitWidth) + ", " + ("rowHeight=" + this.rowHeight) + ", " + ("stripedRows=" + this.stripedRows) + ", " + ("hideHeaders=" + this.hideHeaders) + ", " + ("allowMultiRowSelection=" + this.allowMultiRowSelection) + ", " + ("rowBorderWidth=" + this.rowBorderWidth) + ", " + ("showRowCheckBoxes=" + this.showRowCheckBoxes) + ", " + ("showNumbering=" + this.showNumbering) + ", " + ("totalNumberOfRecords=" + this.totalNumberOfRecords) + ", " + ("sortField=" + this.sortField) + ", " + ("sortDirection=" + this.sortDirection) + ", " + ("editable=" + this.editable) + ", " + ("treeMode=" + this.treeMode) + ", " + ("indentation=" + this.indentation) + ", " + ("contextMenuEnabled=" + this.contextMenuEnabled) + ", " + ("showHeaderRow=" + this.showHeaderRow) + ", " + ("headerRowBorderWidth=" + this.headerRowBorderWidth) + ", " + ("headerRowHeight=" + this.headerRowHeight) + ", " + ("showFooterRow=" + this.showFooterRow) + ", " + ("footerRowBorderWidth=" + this.footerRowBorderWidth) + ", " + ("footerRowHeight=" + this.footerRowHeight) + ", " + (String)(this.columns != null ? "columns={" + this.columns.toString() + "}" : "") + ", " + (String)(this.stripedRowColorEven != null ? "stripedRowColorEven={" + this.stripedRowColorEven.toString() + "}" : "") + ", " + (String)(this.stripedRowColorOdd != null ? "stripedRowColorOdd={" + this.stripedRowColorOdd.toString() + "}" : "") + ", " + (String)(this.selectionColor != null ? "selectionColor={" + this.selectionColor.toString() + "}" : "") + ", " + (String)(this.rowBorderColor != null ? "rowBorderColor={" + this.rowBorderColor.toString() + "}" : "") + ", " + (String)(this.tableData != null ? "tableData={" + this.tableData.toString() + "}" : "") + ", " + (String)(this.selectionFrame != null ? "selectionFrame={" + this.selectionFrame.toString() + "}" : "") + ", " + (String)(this.headerRowBorderColor != null ? "headerRowBorderColor={" + this.headerRowBorderColor.toString() + "}" : "") + ", " + (String)(this.headerRowBackgroundColor != null ? "headerRowBackgroundColor={" + this.headerRowBackgroundColor.toString() + "}" : "") + ", " + (String)(this.headerRowFields != null ? "headerRowFields={" + this.headerRowFields.toString() + "}" : "") + ", " + (String)(this.footerRowBorderColor != null ? "footerRowBorderColor={" + this.footerRowBorderColor.toString() + "}" : "") + ", " + (String)(this.footerRowBackgroundColor != null ? "footerRowBackgroundColor={" + this.footerRowBackgroundColor.toString() + "}" : "") + ", " + (String)(this.footerRowFields != null ? "footerRowFields={" + this.footerRowFields.toString() + "}" : "");
    }

    @JsonGetter(value="columns")
    public List<UiTableColumn> getColumns() {
        return this.columns;
    }

    @JsonGetter(value="displayAsList")
    public boolean getDisplayAsList() {
        return this.displayAsList;
    }

    @JsonGetter(value="forceFitWidth")
    public boolean getForceFitWidth() {
        return this.forceFitWidth;
    }

    @JsonGetter(value="rowHeight")
    public int getRowHeight() {
        return this.rowHeight;
    }

    @JsonGetter(value="stripedRows")
    public boolean getStripedRows() {
        return this.stripedRows;
    }

    @JsonGetter(value="stripedRowColorEven")
    public UiColor getStripedRowColorEven() {
        return this.stripedRowColorEven;
    }

    @JsonGetter(value="stripedRowColorOdd")
    public UiColor getStripedRowColorOdd() {
        return this.stripedRowColorOdd;
    }

    @JsonGetter(value="hideHeaders")
    public boolean getHideHeaders() {
        return this.hideHeaders;
    }

    @JsonGetter(value="allowMultiRowSelection")
    public boolean getAllowMultiRowSelection() {
        return this.allowMultiRowSelection;
    }

    @JsonGetter(value="selectionColor")
    public UiColor getSelectionColor() {
        return this.selectionColor;
    }

    @JsonGetter(value="rowBorderWidth")
    public int getRowBorderWidth() {
        return this.rowBorderWidth;
    }

    @JsonGetter(value="rowBorderColor")
    public UiColor getRowBorderColor() {
        return this.rowBorderColor;
    }

    @JsonGetter(value="showRowCheckBoxes")
    public boolean getShowRowCheckBoxes() {
        return this.showRowCheckBoxes;
    }

    @JsonGetter(value="showNumbering")
    public boolean getShowNumbering() {
        return this.showNumbering;
    }

    @JsonGetter(value="tableData")
    public List<UiTableClientRecord> getTableData() {
        return this.tableData;
    }

    @JsonGetter(value="totalNumberOfRecords")
    public int getTotalNumberOfRecords() {
        return this.totalNumberOfRecords;
    }

    @JsonGetter(value="sortField")
    public String getSortField() {
        return this.sortField;
    }

    @JsonGetter(value="sortDirection")
    public UiSortDirection getSortDirection() {
        return this.sortDirection;
    }

    @JsonGetter(value="editable")
    public boolean getEditable() {
        return this.editable;
    }

    @JsonGetter(value="treeMode")
    public boolean getTreeMode() {
        return this.treeMode;
    }

    @JsonGetter(value="indentedColumnName")
    public String getIndentedColumnName() {
        return this.indentedColumnName;
    }

    @JsonGetter(value="indentation")
    public int getIndentation() {
        return this.indentation;
    }

    @JsonGetter(value="selectionFrame")
    public UiSelectionFrame getSelectionFrame() {
        return this.selectionFrame;
    }

    @JsonGetter(value="contextMenuEnabled")
    public boolean getContextMenuEnabled() {
        return this.contextMenuEnabled;
    }

    @JsonGetter(value="showHeaderRow")
    public boolean getShowHeaderRow() {
        return this.showHeaderRow;
    }

    @JsonGetter(value="headerRowBorderWidth")
    public int getHeaderRowBorderWidth() {
        return this.headerRowBorderWidth;
    }

    @JsonGetter(value="headerRowBorderColor")
    public UiColor getHeaderRowBorderColor() {
        return this.headerRowBorderColor;
    }

    @JsonGetter(value="headerRowHeight")
    public int getHeaderRowHeight() {
        return this.headerRowHeight;
    }

    @JsonGetter(value="headerRowBackgroundColor")
    public UiColor getHeaderRowBackgroundColor() {
        return this.headerRowBackgroundColor;
    }

    @JsonGetter(value="headerRowFields")
    public Map<String, UiClientObjectReference> getHeaderRowFields() {
        return this.headerRowFields;
    }

    @JsonGetter(value="showFooterRow")
    public boolean getShowFooterRow() {
        return this.showFooterRow;
    }

    @JsonGetter(value="footerRowBorderWidth")
    public int getFooterRowBorderWidth() {
        return this.footerRowBorderWidth;
    }

    @JsonGetter(value="footerRowBorderColor")
    public UiColor getFooterRowBorderColor() {
        return this.footerRowBorderColor;
    }

    @JsonGetter(value="footerRowHeight")
    public int getFooterRowHeight() {
        return this.footerRowHeight;
    }

    @JsonGetter(value="footerRowBackgroundColor")
    public UiColor getFooterRowBackgroundColor() {
        return this.footerRowBackgroundColor;
    }

    @JsonGetter(value="footerRowFields")
    public Map<String, UiClientObjectReference> getFooterRowFields() {
        return this.footerRowFields;
    }

    @Override
    @JsonSetter(value="id")
    public UiTable setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiTable setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiTable setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiTable setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="displayAsList")
    public UiTable setDisplayAsList(boolean displayAsList) {
        this.displayAsList = displayAsList;
        return this;
    }

    @JsonSetter(value="forceFitWidth")
    public UiTable setForceFitWidth(boolean forceFitWidth) {
        this.forceFitWidth = forceFitWidth;
        return this;
    }

    @JsonSetter(value="rowHeight")
    public UiTable setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
        return this;
    }

    @JsonSetter(value="stripedRows")
    public UiTable setStripedRows(boolean stripedRows) {
        this.stripedRows = stripedRows;
        return this;
    }

    @JsonSetter(value="stripedRowColorEven")
    public UiTable setStripedRowColorEven(UiColor stripedRowColorEven) {
        this.stripedRowColorEven = stripedRowColorEven;
        return this;
    }

    @JsonSetter(value="stripedRowColorOdd")
    public UiTable setStripedRowColorOdd(UiColor stripedRowColorOdd) {
        this.stripedRowColorOdd = stripedRowColorOdd;
        return this;
    }

    @JsonSetter(value="hideHeaders")
    public UiTable setHideHeaders(boolean hideHeaders) {
        this.hideHeaders = hideHeaders;
        return this;
    }

    @JsonSetter(value="allowMultiRowSelection")
    public UiTable setAllowMultiRowSelection(boolean allowMultiRowSelection) {
        this.allowMultiRowSelection = allowMultiRowSelection;
        return this;
    }

    @JsonSetter(value="selectionColor")
    public UiTable setSelectionColor(UiColor selectionColor) {
        this.selectionColor = selectionColor;
        return this;
    }

    @JsonSetter(value="rowBorderWidth")
    public UiTable setRowBorderWidth(int rowBorderWidth) {
        this.rowBorderWidth = rowBorderWidth;
        return this;
    }

    @JsonSetter(value="rowBorderColor")
    public UiTable setRowBorderColor(UiColor rowBorderColor) {
        this.rowBorderColor = rowBorderColor;
        return this;
    }

    @JsonSetter(value="showRowCheckBoxes")
    public UiTable setShowRowCheckBoxes(boolean showRowCheckBoxes) {
        this.showRowCheckBoxes = showRowCheckBoxes;
        return this;
    }

    @JsonSetter(value="showNumbering")
    public UiTable setShowNumbering(boolean showNumbering) {
        this.showNumbering = showNumbering;
        return this;
    }

    @JsonSetter(value="tableData")
    public UiTable setTableData(List<UiTableClientRecord> tableData) {
        this.tableData = tableData;
        return this;
    }

    @JsonSetter(value="totalNumberOfRecords")
    public UiTable setTotalNumberOfRecords(int totalNumberOfRecords) {
        this.totalNumberOfRecords = totalNumberOfRecords;
        return this;
    }

    @JsonSetter(value="sortField")
    public UiTable setSortField(String sortField) {
        this.sortField = sortField;
        return this;
    }

    @JsonSetter(value="sortDirection")
    public UiTable setSortDirection(UiSortDirection sortDirection) {
        this.sortDirection = sortDirection;
        return this;
    }

    @JsonSetter(value="editable")
    public UiTable setEditable(boolean editable) {
        this.editable = editable;
        return this;
    }

    @JsonSetter(value="treeMode")
    public UiTable setTreeMode(boolean treeMode) {
        this.treeMode = treeMode;
        return this;
    }

    @JsonSetter(value="indentedColumnName")
    public UiTable setIndentedColumnName(String indentedColumnName) {
        this.indentedColumnName = indentedColumnName;
        return this;
    }

    @JsonSetter(value="indentation")
    public UiTable setIndentation(int indentation) {
        this.indentation = indentation;
        return this;
    }

    @JsonSetter(value="selectionFrame")
    public UiTable setSelectionFrame(UiSelectionFrame selectionFrame) {
        this.selectionFrame = selectionFrame;
        return this;
    }

    @JsonSetter(value="contextMenuEnabled")
    public UiTable setContextMenuEnabled(boolean contextMenuEnabled) {
        this.contextMenuEnabled = contextMenuEnabled;
        return this;
    }

    @JsonSetter(value="showHeaderRow")
    public UiTable setShowHeaderRow(boolean showHeaderRow) {
        this.showHeaderRow = showHeaderRow;
        return this;
    }

    @JsonSetter(value="headerRowBorderWidth")
    public UiTable setHeaderRowBorderWidth(int headerRowBorderWidth) {
        this.headerRowBorderWidth = headerRowBorderWidth;
        return this;
    }

    @JsonSetter(value="headerRowBorderColor")
    public UiTable setHeaderRowBorderColor(UiColor headerRowBorderColor) {
        this.headerRowBorderColor = headerRowBorderColor;
        return this;
    }

    @JsonSetter(value="headerRowHeight")
    public UiTable setHeaderRowHeight(int headerRowHeight) {
        this.headerRowHeight = headerRowHeight;
        return this;
    }

    @JsonSetter(value="headerRowBackgroundColor")
    public UiTable setHeaderRowBackgroundColor(UiColor headerRowBackgroundColor) {
        this.headerRowBackgroundColor = headerRowBackgroundColor;
        return this;
    }

    @JsonSetter(value="headerRowFields")
    public UiTable setHeaderRowFields(Map<String, UiClientObjectReference> headerRowFields) {
        this.headerRowFields = headerRowFields;
        return this;
    }

    @JsonSetter(value="showFooterRow")
    public UiTable setShowFooterRow(boolean showFooterRow) {
        this.showFooterRow = showFooterRow;
        return this;
    }

    @JsonSetter(value="footerRowBorderWidth")
    public UiTable setFooterRowBorderWidth(int footerRowBorderWidth) {
        this.footerRowBorderWidth = footerRowBorderWidth;
        return this;
    }

    @JsonSetter(value="footerRowBorderColor")
    public UiTable setFooterRowBorderColor(UiColor footerRowBorderColor) {
        this.footerRowBorderColor = footerRowBorderColor;
        return this;
    }

    @JsonSetter(value="footerRowHeight")
    public UiTable setFooterRowHeight(int footerRowHeight) {
        this.footerRowHeight = footerRowHeight;
        return this;
    }

    @JsonSetter(value="footerRowBackgroundColor")
    public UiTable setFooterRowBackgroundColor(UiColor footerRowBackgroundColor) {
        this.footerRowBackgroundColor = footerRowBackgroundColor;
        return this;
    }

    @JsonSetter(value="footerRowFields")
    public UiTable setFooterRowFields(Map<String, UiClientObjectReference> footerRowFields) {
        this.footerRowFields = footerRowFields;
        return this;
    }

    public static class CloseContextMenuCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int requestId;

        @Deprecated
        public CloseContextMenuCommand() {
        }

        public CloseContextMenuCommand(String componentId, int requestId) {
            this.componentId = componentId;
            this.requestId = requestId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("requestId=" + this.requestId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="requestId")
        public int getRequestId() {
            return this.requestId;
        }
    }

    public static class SetContextMenuContentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int requestId;
        protected UiClientObjectReference component;

        @Deprecated
        public SetContextMenuContentCommand() {
        }

        public SetContextMenuContentCommand(String componentId, int requestId, UiClientObjectReference component) {
            this.componentId = componentId;
            this.requestId = requestId;
            this.component = component;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("requestId=" + this.requestId) + ", " + (String)(this.component != null ? "component={" + this.component.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="requestId")
        public int getRequestId() {
            return this.requestId;
        }

        @JsonGetter(value="component")
        public UiClientObjectReference getComponent() {
            return this.component;
        }
    }

    public static class SetColumnVisibilityCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String columnPropertyName;
        protected boolean visible;

        @Deprecated
        public SetColumnVisibilityCommand() {
        }

        public SetColumnVisibilityCommand(String componentId, String columnPropertyName, boolean visible) {
            this.componentId = componentId;
            this.columnPropertyName = columnPropertyName;
            this.visible = visible;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("columnPropertyName=" + this.columnPropertyName) + ", " + ("visible=" + this.visible);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="columnPropertyName")
        public String getColumnPropertyName() {
            return this.columnPropertyName;
        }

        @JsonGetter(value="visible")
        public boolean getVisible() {
            return this.visible;
        }
    }

    public static class RemoveColumnsCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<String> columnName;

        @Deprecated
        public RemoveColumnsCommand() {
        }

        public RemoveColumnsCommand(String componentId, List<String> columnName) {
            this.componentId = componentId;
            this.columnName = columnName;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("columnName=" + this.columnName);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="columnName")
        public List<String> getColumnName() {
            return this.columnName;
        }
    }

    public static class AddColumnsCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<UiTableColumn> column;
        protected int index;

        @Deprecated
        public AddColumnsCommand() {
        }

        public AddColumnsCommand(String componentId, List<UiTableColumn> column, int index) {
            this.componentId = componentId;
            this.column = column;
            this.index = index;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("index=" + this.index) + ", " + (String)(this.column != null ? "column={" + this.column.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="column")
        public List<UiTableColumn> getColumn() {
            return this.column;
        }

        @JsonGetter(value="index")
        public int getIndex() {
            return this.index;
        }
    }

    public static class SetColumnMessagesCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String columnPropertyName;
        protected List<UiFieldMessage> messages;

        @Deprecated
        public SetColumnMessagesCommand() {
        }

        public SetColumnMessagesCommand(String componentId, String columnPropertyName, List<UiFieldMessage> messages) {
            this.componentId = componentId;
            this.columnPropertyName = columnPropertyName;
            this.messages = messages;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("columnPropertyName=" + this.columnPropertyName) + ", " + (String)(this.messages != null ? "messages={" + this.messages.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="columnPropertyName")
        public String getColumnPropertyName() {
            return this.columnPropertyName;
        }

        @JsonGetter(value="messages")
        public List<UiFieldMessage> getMessages() {
            return this.messages;
        }
    }

    public static class ClearAllCellMessagesCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public ClearAllCellMessagesCommand() {
        }

        public ClearAllCellMessagesCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class SetSingleCellMessagesCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int recordId;
        protected String columnPropertyName;
        protected List<UiFieldMessage> messages;

        @Deprecated
        public SetSingleCellMessagesCommand() {
        }

        public SetSingleCellMessagesCommand(String componentId, int recordId, String columnPropertyName, List<UiFieldMessage> messages) {
            this.componentId = componentId;
            this.recordId = recordId;
            this.columnPropertyName = columnPropertyName;
            this.messages = messages;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("recordId=" + this.recordId) + ", " + ("columnPropertyName=" + this.columnPropertyName) + ", " + (String)(this.messages != null ? "messages={" + this.messages.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="recordId")
        public int getRecordId() {
            return this.recordId;
        }

        @JsonGetter(value="columnPropertyName")
        public String getColumnPropertyName() {
            return this.columnPropertyName;
        }

        @JsonGetter(value="messages")
        public List<UiFieldMessage> getMessages() {
            return this.messages;
        }
    }

    public static class FocusCellCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int recordId;
        protected String columnPropertyName;

        @Deprecated
        public FocusCellCommand() {
        }

        public FocusCellCommand(String componentId, int recordId, String columnPropertyName) {
            this.componentId = componentId;
            this.recordId = recordId;
            this.columnPropertyName = columnPropertyName;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("recordId=" + this.recordId) + ", " + ("columnPropertyName=" + this.columnPropertyName);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="recordId")
        public int getRecordId() {
            return this.recordId;
        }

        @JsonGetter(value="columnPropertyName")
        public String getColumnPropertyName() {
            return this.columnPropertyName;
        }
    }

    public static class CancelEditingCellCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int recordId;
        protected String propertyName;

        @Deprecated
        public CancelEditingCellCommand() {
        }

        public CancelEditingCellCommand(String componentId, int recordId, String propertyName) {
            this.componentId = componentId;
            this.recordId = recordId;
            this.propertyName = propertyName;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("recordId=" + this.recordId) + ", " + ("propertyName=" + this.propertyName);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="recordId")
        public int getRecordId() {
            return this.recordId;
        }

        @JsonGetter(value="propertyName")
        public String getPropertyName() {
            return this.propertyName;
        }
    }

    public static class EditCellIfAvailableCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int recordId;
        protected String propertyName;

        @Deprecated
        public EditCellIfAvailableCommand() {
        }

        public EditCellIfAvailableCommand(String componentId, int recordId, String propertyName) {
            this.componentId = componentId;
            this.recordId = recordId;
            this.propertyName = propertyName;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("recordId=" + this.recordId) + ", " + ("propertyName=" + this.propertyName);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="recordId")
        public int getRecordId() {
            return this.recordId;
        }

        @JsonGetter(value="propertyName")
        public String getPropertyName() {
            return this.propertyName;
        }
    }

    public static class SelectRowsCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<Integer> recordIds;
        protected boolean scrollToFirstRecord;

        @Deprecated
        public SelectRowsCommand() {
        }

        public SelectRowsCommand(String componentId, List<Integer> recordIds, boolean scrollToFirstRecord) {
            this.componentId = componentId;
            this.recordIds = recordIds;
            this.scrollToFirstRecord = scrollToFirstRecord;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("recordIds=" + this.recordIds) + ", " + ("scrollToFirstRecord=" + this.scrollToFirstRecord);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="recordIds")
        public List<Integer> getRecordIds() {
            return this.recordIds;
        }

        @JsonGetter(value="scrollToFirstRecord")
        public boolean getScrollToFirstRecord() {
            return this.scrollToFirstRecord;
        }
    }

    public static class SetRecordBoldCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int recordId;
        protected boolean bold;

        @Deprecated
        public SetRecordBoldCommand() {
        }

        public SetRecordBoldCommand(String componentId, int recordId, boolean bold) {
            this.componentId = componentId;
            this.recordId = recordId;
            this.bold = bold;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("recordId=" + this.recordId) + ", " + ("bold=" + this.bold);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="recordId")
        public int getRecordId() {
            return this.recordId;
        }

        @JsonGetter(value="bold")
        public boolean getBold() {
            return this.bold;
        }
    }

    public static class ClearAllFieldMarkingsCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public ClearAllFieldMarkingsCommand() {
        }

        public ClearAllFieldMarkingsCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class MarkTableFieldCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int recordId;
        protected String columnPropertyName;
        protected boolean mark;

        @Deprecated
        public MarkTableFieldCommand() {
        }

        public MarkTableFieldCommand(String componentId, int recordId, String columnPropertyName, boolean mark) {
            this.componentId = componentId;
            this.recordId = recordId;
            this.columnPropertyName = columnPropertyName;
            this.mark = mark;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("recordId=" + this.recordId) + ", " + ("columnPropertyName=" + this.columnPropertyName) + ", " + ("mark=" + this.mark);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="recordId")
        public int getRecordId() {
            return this.recordId;
        }

        @JsonGetter(value="columnPropertyName")
        public String getColumnPropertyName() {
            return this.columnPropertyName;
        }

        @JsonGetter(value="mark")
        public boolean getMark() {
            return this.mark;
        }
    }

    public static class SetChildrenDataCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int parentRecordId;
        protected List<UiTableClientRecord> data;

        @Deprecated
        public SetChildrenDataCommand() {
        }

        public SetChildrenDataCommand(String componentId, int parentRecordId, List<UiTableClientRecord> data) {
            this.componentId = componentId;
            this.parentRecordId = parentRecordId;
            this.data = data;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("parentRecordId=" + this.parentRecordId) + ", " + (String)(this.data != null ? "data={" + this.data.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="parentRecordId")
        public int getParentRecordId() {
            return this.parentRecordId;
        }

        @JsonGetter(value="data")
        public List<UiTableClientRecord> getData() {
            return this.data;
        }
    }

    public static class SetCellValueCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int recordId;
        protected String columnPropertyName;
        @JsonSerialize(using=ObjectSerializer.class)
        @JsonDeserialize(using=ObjectDeserializer.class)
        protected Object value;

        @Deprecated
        public SetCellValueCommand() {
        }

        public SetCellValueCommand(String componentId, int recordId, String columnPropertyName, Object value) {
            this.componentId = componentId;
            this.recordId = recordId;
            this.columnPropertyName = columnPropertyName;
            this.value = value;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("recordId=" + this.recordId) + ", " + ("columnPropertyName=" + this.columnPropertyName) + ", " + ("value=" + this.value);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="recordId")
        public int getRecordId() {
            return this.recordId;
        }

        @JsonGetter(value="columnPropertyName")
        public String getColumnPropertyName() {
            return this.columnPropertyName;
        }

        @JsonGetter(value="value")
        public Object getValue() {
            return this.value;
        }
    }

    public static class UpdateRecordCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiTableClientRecord record;

        @Deprecated
        public UpdateRecordCommand() {
        }

        public UpdateRecordCommand(String componentId, UiTableClientRecord record) {
            this.componentId = componentId;
            this.record = record;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.record != null ? "record={" + this.record.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="record")
        public UiTableClientRecord getRecord() {
            return this.record;
        }
    }

    public static class DeleteRowsCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<Integer> ids;

        @Deprecated
        public DeleteRowsCommand() {
        }

        public DeleteRowsCommand(String componentId, List<Integer> ids) {
            this.componentId = componentId;
            this.ids = ids;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("ids=" + this.ids);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="ids")
        public List<Integer> getIds() {
            return this.ids;
        }
    }

    public static class InsertRowsCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int index;
        protected List<UiTableClientRecord> data;

        @Deprecated
        public InsertRowsCommand() {
        }

        public InsertRowsCommand(String componentId, int index, List<UiTableClientRecord> data) {
            this.componentId = componentId;
            this.index = index;
            this.data = data;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("index=" + this.index) + ", " + (String)(this.data != null ? "data={" + this.data.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="index")
        public int getIndex() {
            return this.index;
        }

        @JsonGetter(value="data")
        public List<UiTableClientRecord> getData() {
            return this.data;
        }
    }

    public static class RemoveDataCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<Integer> ids;

        @Deprecated
        public RemoveDataCommand() {
        }

        public RemoveDataCommand(String componentId, List<Integer> ids) {
            this.componentId = componentId;
            this.ids = ids;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("ids=" + this.ids);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="ids")
        public List<Integer> getIds() {
            return this.ids;
        }
    }

    public static class AddDataCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int startRowIndex;
        protected List<UiTableClientRecord> data;
        protected int totalNumberOfRecords;
        protected String sortField;
        protected UiSortDirection sortDirection;
        protected boolean clearTableCache;

        @Deprecated
        public AddDataCommand() {
        }

        public AddDataCommand(String componentId, int startRowIndex, List<UiTableClientRecord> data, int totalNumberOfRecords, String sortField, UiSortDirection sortDirection, boolean clearTableCache) {
            this.componentId = componentId;
            this.startRowIndex = startRowIndex;
            this.data = data;
            this.totalNumberOfRecords = totalNumberOfRecords;
            this.sortField = sortField;
            this.sortDirection = sortDirection;
            this.clearTableCache = clearTableCache;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("startRowIndex=" + this.startRowIndex) + ", " + ("totalNumberOfRecords=" + this.totalNumberOfRecords) + ", " + ("sortField=" + this.sortField) + ", " + ("sortDirection=" + this.sortDirection) + ", " + ("clearTableCache=" + this.clearTableCache) + ", " + (String)(this.data != null ? "data={" + this.data.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="startRowIndex")
        public int getStartRowIndex() {
            return this.startRowIndex;
        }

        @JsonGetter(value="data")
        public List<UiTableClientRecord> getData() {
            return this.data;
        }

        @JsonGetter(value="totalNumberOfRecords")
        public int getTotalNumberOfRecords() {
            return this.totalNumberOfRecords;
        }

        @JsonGetter(value="sortField")
        public String getSortField() {
            return this.sortField;
        }

        @JsonGetter(value="sortDirection")
        public UiSortDirection getSortDirection() {
            return this.sortDirection;
        }

        @JsonGetter(value="clearTableCache")
        public boolean getClearTableCache() {
            return this.clearTableCache;
        }
    }

    public static class ClearTableCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public ClearTableCommand() {
        }

        public ClearTableCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class ColumnSizeChangeEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String columnPropertyName;
        protected int size;

        @Deprecated
        public ColumnSizeChangeEvent() {
        }

        public ColumnSizeChangeEvent(String componentId, String columnPropertyName, int size) {
            this.componentId = componentId;
            this.columnPropertyName = columnPropertyName;
            this.size = size;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TABLE_COLUMN_SIZE_CHANGE;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("columnPropertyName=" + this.columnPropertyName) + ", " + ("size=" + this.size);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="columnPropertyName")
        public String getColumnPropertyName() {
            return this.columnPropertyName;
        }

        @JsonGetter(value="size")
        public int getSize() {
            return this.size;
        }
    }

    public static class FieldOrderChangeEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String columnPropertyName;
        protected int position;

        @Deprecated
        public FieldOrderChangeEvent() {
        }

        public FieldOrderChangeEvent(String componentId, String columnPropertyName, int position) {
            this.componentId = componentId;
            this.columnPropertyName = columnPropertyName;
            this.position = position;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TABLE_FIELD_ORDER_CHANGE;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("columnPropertyName=" + this.columnPropertyName) + ", " + ("position=" + this.position);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="columnPropertyName")
        public String getColumnPropertyName() {
            return this.columnPropertyName;
        }

        @JsonGetter(value="position")
        public int getPosition() {
            return this.position;
        }
    }

    public static class ContextMenuRequestedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int requestId;
        protected int recordId;

        @Deprecated
        public ContextMenuRequestedEvent() {
        }

        public ContextMenuRequestedEvent(String componentId, int requestId, int recordId) {
            this.componentId = componentId;
            this.requestId = requestId;
            this.recordId = recordId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TABLE_CONTEXT_MENU_REQUESTED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("requestId=" + this.requestId) + ", " + ("recordId=" + this.recordId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="requestId")
        public int getRequestId() {
            return this.requestId;
        }

        @JsonGetter(value="recordId")
        public int getRecordId() {
            return this.recordId;
        }
    }

    public static class RequestNestedDataEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int recordId;

        @Deprecated
        public RequestNestedDataEvent() {
        }

        public RequestNestedDataEvent(String componentId, int recordId) {
            this.componentId = componentId;
            this.recordId = recordId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TABLE_REQUEST_NESTED_DATA;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("recordId=" + this.recordId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="recordId")
        public int getRecordId() {
            return this.recordId;
        }
    }

    public static class DisplayedRangeChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int startIndex;
        protected int length;
        protected List<Integer> displayedRecordIds;
        protected UiTableDataRequest dataRequest;

        @Deprecated
        public DisplayedRangeChangedEvent() {
        }

        public DisplayedRangeChangedEvent(String componentId, int startIndex, int length, List<Integer> displayedRecordIds, UiTableDataRequest dataRequest) {
            this.componentId = componentId;
            this.startIndex = startIndex;
            this.length = length;
            this.displayedRecordIds = displayedRecordIds;
            this.dataRequest = dataRequest;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TABLE_DISPLAYED_RANGE_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("displayedRecordIds=" + this.displayedRecordIds) + ", " + ("startIndex=" + this.startIndex) + ", " + ("length=" + this.length) + ", " + (String)(this.dataRequest != null ? "dataRequest={" + this.dataRequest.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="startIndex")
        public int getStartIndex() {
            return this.startIndex;
        }

        @JsonGetter(value="length")
        public int getLength() {
            return this.length;
        }

        @JsonGetter(value="displayedRecordIds")
        public List<Integer> getDisplayedRecordIds() {
            return this.displayedRecordIds;
        }

        @JsonGetter(value="dataRequest")
        public UiTableDataRequest getDataRequest() {
            return this.dataRequest;
        }
    }

    public static class SortingChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String sortField;
        protected UiSortDirection sortDirection;

        @Deprecated
        public SortingChangedEvent() {
        }

        public SortingChangedEvent(String componentId, String sortField, UiSortDirection sortDirection) {
            this.componentId = componentId;
            this.sortField = sortField;
            this.sortDirection = sortDirection;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TABLE_SORTING_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("sortField=" + this.sortField) + ", " + ("sortDirection=" + this.sortDirection);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="sortField")
        public String getSortField() {
            return this.sortField;
        }

        @JsonGetter(value="sortDirection")
        public UiSortDirection getSortDirection() {
            return this.sortDirection;
        }
    }

    public static class MultipleRowsSelectedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected List<Integer> recordIds;

        @Deprecated
        public MultipleRowsSelectedEvent() {
        }

        public MultipleRowsSelectedEvent(String componentId, List<Integer> recordIds) {
            this.componentId = componentId;
            this.recordIds = recordIds;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TABLE_MULTIPLE_ROWS_SELECTED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("recordIds=" + this.recordIds);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="recordIds")
        public List<Integer> getRecordIds() {
            return this.recordIds;
        }
    }

    public static class RowSelectedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int recordId;
        protected boolean isRightMouseButton;
        protected boolean isDoubleClick;

        @Deprecated
        public RowSelectedEvent() {
        }

        public RowSelectedEvent(String componentId, int recordId, boolean isRightMouseButton, boolean isDoubleClick) {
            this.componentId = componentId;
            this.recordId = recordId;
            this.isRightMouseButton = isRightMouseButton;
            this.isDoubleClick = isDoubleClick;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TABLE_ROW_SELECTED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("recordId=" + this.recordId) + ", " + ("isRightMouseButton=" + this.isRightMouseButton) + ", " + ("isDoubleClick=" + this.isDoubleClick);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="recordId")
        public int getRecordId() {
            return this.recordId;
        }

        @JsonGetter(value="isRightMouseButton")
        public boolean getIsRightMouseButton() {
            return this.isRightMouseButton;
        }

        @JsonGetter(value="isDoubleClick")
        public boolean getIsDoubleClick() {
            return this.isDoubleClick;
        }
    }

    public static class CellValueChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int recordId;
        protected String columnPropertyName;
        @JsonSerialize(using=ObjectSerializer.class)
        @JsonDeserialize(using=ObjectDeserializer.class)
        protected Object value;

        @Deprecated
        public CellValueChangedEvent() {
        }

        public CellValueChangedEvent(String componentId, int recordId, String columnPropertyName, Object value) {
            this.componentId = componentId;
            this.recordId = recordId;
            this.columnPropertyName = columnPropertyName;
            this.value = value;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TABLE_CELL_VALUE_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("recordId=" + this.recordId) + ", " + ("columnPropertyName=" + this.columnPropertyName) + ", " + ("value=" + this.value);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="recordId")
        public int getRecordId() {
            return this.recordId;
        }

        @JsonGetter(value="columnPropertyName")
        public String getColumnPropertyName() {
            return this.columnPropertyName;
        }

        @JsonGetter(value="value")
        public Object getValue() {
            return this.value;
        }
    }

    public static class CellEditingStoppedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int recordId;
        protected String columnPropertyName;

        @Deprecated
        public CellEditingStoppedEvent() {
        }

        public CellEditingStoppedEvent(String componentId, int recordId, String columnPropertyName) {
            this.componentId = componentId;
            this.recordId = recordId;
            this.columnPropertyName = columnPropertyName;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TABLE_CELL_EDITING_STOPPED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("recordId=" + this.recordId) + ", " + ("columnPropertyName=" + this.columnPropertyName);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="recordId")
        public int getRecordId() {
            return this.recordId;
        }

        @JsonGetter(value="columnPropertyName")
        public String getColumnPropertyName() {
            return this.columnPropertyName;
        }
    }

    public static class CellEditingStartedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int recordId;
        protected String columnPropertyName;
        @JsonSerialize(using=ObjectSerializer.class)
        @JsonDeserialize(using=ObjectDeserializer.class)
        protected Object currentValue;

        @Deprecated
        public CellEditingStartedEvent() {
        }

        public CellEditingStartedEvent(String componentId, int recordId, String columnPropertyName, Object currentValue) {
            this.componentId = componentId;
            this.recordId = recordId;
            this.columnPropertyName = columnPropertyName;
            this.currentValue = currentValue;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_TABLE_CELL_EDITING_STARTED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("recordId=" + this.recordId) + ", " + ("columnPropertyName=" + this.columnPropertyName) + ", " + ("currentValue=" + this.currentValue);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="recordId")
        public int getRecordId() {
            return this.recordId;
        }

        @JsonGetter(value="columnPropertyName")
        public String getColumnPropertyName() {
            return this.columnPropertyName;
        }

        @JsonGetter(value="currentValue")
        public Object getCurrentValue() {
            return this.currentValue;
        }
    }
}

