/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import org.teamapps.dto.ObjectDeserializer;
import org.teamapps.dto.ObjectSerializer;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiColor;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiTemplate;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiToolbarButton
implements UiObject {
    protected String buttonId;
    protected UiTemplate template;
    protected boolean visible = true;
    @JsonSerialize(using=ObjectSerializer.class)
    @JsonDeserialize(using=ObjectDeserializer.class)
    protected Object recordData;
    protected String togglesFullScreenOnComponent;
    protected String openNewTabWithUrl;
    protected boolean hasDropDown;
    protected UiClientObjectReference dropDownComponent;
    protected int dropDownPanelWidth = 450;
    protected UiColor backgroundColor;
    protected UiColor hoverBackgroundColor;

    @Deprecated
    public UiToolbarButton() {
    }

    public UiToolbarButton(String buttonId, UiTemplate template, Object recordData) {
        this.buttonId = buttonId;
        this.template = template;
        this.recordData = recordData;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_TOOLBAR_BUTTON;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("buttonId=" + this.buttonId) + ", " + (String)(this.template != null ? "template={" + this.template.toString() + "}" : "") + ", " + ("visible=" + this.visible) + ", " + ("recordData=" + this.recordData) + ", " + ("togglesFullScreenOnComponent=" + this.togglesFullScreenOnComponent) + ", " + ("openNewTabWithUrl=" + this.openNewTabWithUrl) + ", " + ("hasDropDown=" + this.hasDropDown) + ", " + ("dropDownPanelWidth=" + this.dropDownPanelWidth) + ", " + (String)(this.dropDownComponent != null ? "dropDownComponent={" + this.dropDownComponent.toString() + "}" : "") + ", " + (String)(this.backgroundColor != null ? "backgroundColor={" + this.backgroundColor.toString() + "}" : "") + ", " + (String)(this.hoverBackgroundColor != null ? "hoverBackgroundColor={" + this.hoverBackgroundColor.toString() + "}" : "");
    }

    @JsonGetter(value="buttonId")
    public String getButtonId() {
        return this.buttonId;
    }

    @JsonGetter(value="template")
    public UiTemplate getTemplate() {
        return this.template;
    }

    @JsonGetter(value="visible")
    public boolean getVisible() {
        return this.visible;
    }

    @JsonGetter(value="recordData")
    public Object getRecordData() {
        return this.recordData;
    }

    @JsonGetter(value="togglesFullScreenOnComponent")
    public String getTogglesFullScreenOnComponent() {
        return this.togglesFullScreenOnComponent;
    }

    @JsonGetter(value="openNewTabWithUrl")
    public String getOpenNewTabWithUrl() {
        return this.openNewTabWithUrl;
    }

    @JsonGetter(value="hasDropDown")
    public boolean getHasDropDown() {
        return this.hasDropDown;
    }

    @JsonGetter(value="dropDownComponent")
    public UiClientObjectReference getDropDownComponent() {
        return this.dropDownComponent;
    }

    @JsonGetter(value="dropDownPanelWidth")
    public int getDropDownPanelWidth() {
        return this.dropDownPanelWidth;
    }

    @JsonGetter(value="backgroundColor")
    public UiColor getBackgroundColor() {
        return this.backgroundColor;
    }

    @JsonGetter(value="hoverBackgroundColor")
    public UiColor getHoverBackgroundColor() {
        return this.hoverBackgroundColor;
    }

    @JsonSetter(value="visible")
    public UiToolbarButton setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @JsonSetter(value="togglesFullScreenOnComponent")
    public UiToolbarButton setTogglesFullScreenOnComponent(String togglesFullScreenOnComponent) {
        this.togglesFullScreenOnComponent = togglesFullScreenOnComponent;
        return this;
    }

    @JsonSetter(value="openNewTabWithUrl")
    public UiToolbarButton setOpenNewTabWithUrl(String openNewTabWithUrl) {
        this.openNewTabWithUrl = openNewTabWithUrl;
        return this;
    }

    @JsonSetter(value="hasDropDown")
    public UiToolbarButton setHasDropDown(boolean hasDropDown) {
        this.hasDropDown = hasDropDown;
        return this;
    }

    @JsonSetter(value="dropDownComponent")
    public UiToolbarButton setDropDownComponent(UiClientObjectReference dropDownComponent) {
        this.dropDownComponent = dropDownComponent;
        return this;
    }

    @JsonSetter(value="dropDownPanelWidth")
    public UiToolbarButton setDropDownPanelWidth(int dropDownPanelWidth) {
        this.dropDownPanelWidth = dropDownPanelWidth;
        return this;
    }

    @JsonSetter(value="backgroundColor")
    public UiToolbarButton setBackgroundColor(UiColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @JsonSetter(value="hoverBackgroundColor")
    public UiToolbarButton setHoverBackgroundColor(UiColor hoverBackgroundColor) {
        this.hoverBackgroundColor = hoverBackgroundColor;
        return this;
    }
}

