/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiHeatMapDataElement;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiHeatMapData
implements UiObject {
    protected List<UiHeatMapDataElement> elements;
    protected int maxCount = 10;
    protected int radius = 25;
    protected int blur = 15;

    @Deprecated
    public UiHeatMapData() {
    }

    public UiHeatMapData(List<UiHeatMapDataElement> elements) {
        this.elements = elements;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_HEAT_MAP_DATA;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("maxCount=" + this.maxCount) + ", " + ("radius=" + this.radius) + ", " + ("blur=" + this.blur) + ", " + (String)(this.elements != null ? "elements={" + this.elements.toString() + "}" : "");
    }

    @JsonGetter(value="elements")
    public List<UiHeatMapDataElement> getElements() {
        return this.elements;
    }

    @JsonGetter(value="maxCount")
    public int getMaxCount() {
        return this.maxCount;
    }

    @JsonGetter(value="radius")
    public int getRadius() {
        return this.radius;
    }

    @JsonGetter(value="blur")
    public int getBlur() {
        return this.blur;
    }

    @JsonSetter(value="maxCount")
    public UiHeatMapData setMaxCount(int maxCount) {
        this.maxCount = maxCount;
        return this;
    }

    @JsonSetter(value="radius")
    public UiHeatMapData setRadius(int radius) {
        this.radius = radius;
        return this;
    }

    @JsonSetter(value="blur")
    public UiHeatMapData setBlur(int blur) {
        this.blur = blur;
        return this;
    }
}

