/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiMatcherRule;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiValueMatcher;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiValidationRule
extends UiMatcherRule
implements UiObject {
    protected DisplayType displayType = DisplayType.INLINE;
    protected String errorMessage;
    protected boolean markFieldsThatRuleMatches = true;
    protected boolean checkOnFieldUpdate = true;

    @Deprecated
    public UiValidationRule() {
    }

    public UiValidationRule(List<UiValueMatcher> valueMatcher, String errorMessage) {
        super(valueMatcher);
        this.errorMessage = errorMessage;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_VALIDATION_RULE;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("executeRuleIfAnyMatcherMatches=" + this.executeRuleIfAnyMatcherMatches) + ", " + ("displayType=" + this.displayType) + ", " + ("errorMessage=" + this.errorMessage) + ", " + ("markFieldsThatRuleMatches=" + this.markFieldsThatRuleMatches) + ", " + ("checkOnFieldUpdate=" + this.checkOnFieldUpdate) + ", " + (String)(this.valueMatcher != null ? "valueMatcher={" + this.valueMatcher.toString() + "}" : "");
    }

    @JsonGetter(value="displayType")
    public DisplayType getDisplayType() {
        return this.displayType;
    }

    @JsonGetter(value="errorMessage")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @JsonGetter(value="markFieldsThatRuleMatches")
    public boolean getMarkFieldsThatRuleMatches() {
        return this.markFieldsThatRuleMatches;
    }

    @JsonGetter(value="checkOnFieldUpdate")
    public boolean getCheckOnFieldUpdate() {
        return this.checkOnFieldUpdate;
    }

    @Override
    @JsonSetter(value="executeRuleIfAnyMatcherMatches")
    public UiValidationRule setExecuteRuleIfAnyMatcherMatches(boolean executeRuleIfAnyMatcherMatches) {
        this.executeRuleIfAnyMatcherMatches = executeRuleIfAnyMatcherMatches;
        return this;
    }

    @JsonSetter(value="displayType")
    public UiValidationRule setDisplayType(DisplayType displayType) {
        this.displayType = displayType;
        return this;
    }

    @JsonSetter(value="markFieldsThatRuleMatches")
    public UiValidationRule setMarkFieldsThatRuleMatches(boolean markFieldsThatRuleMatches) {
        this.markFieldsThatRuleMatches = markFieldsThatRuleMatches;
        return this;
    }

    @JsonSetter(value="checkOnFieldUpdate")
    public UiValidationRule setCheckOnFieldUpdate(boolean checkOnFieldUpdate) {
        this.checkOnFieldUpdate = checkOnFieldUpdate;
        return this;
    }

    public static enum DisplayType {
        POPUP_WINDOW,
        NOTIFICATION,
        INLINE;


        @JsonValue
        public int jsonValue() {
            return this.ordinal();
        }
    }
}

