package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiComponentGridPlacement implements UiGridPlacement, UiObject {


	protected UiClientObjectReference component;
	protected int row;
	protected int column;
	protected int rowSpan = 1;
	protected int colSpan = 1;
	protected int minWidth;
	protected int maxWidth;
	protected int minHeight;
	protected int maxHeight;
	protected UiVerticalElementAlignment verticalAlignment = null;
	protected UiHorizontalElementAlignment horizontalAlignment = null;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiComponentGridPlacement() {
		// default constructor for Jackson
	}

	public UiComponentGridPlacement(UiClientObjectReference component) {
		this.component = component;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_COMPONENT_GRID_PLACEMENT;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("row=" + row).append(", ")
				.append("column=" + column).append(", ")
				.append("rowSpan=" + rowSpan).append(", ")
				.append("colSpan=" + colSpan).append(", ")
				.append("minWidth=" + minWidth).append(", ")
				.append("maxWidth=" + maxWidth).append(", ")
				.append("minHeight=" + minHeight).append(", ")
				.append("maxHeight=" + maxHeight).append(", ")
				.append("verticalAlignment=" + verticalAlignment).append(", ")
				.append("horizontalAlignment=" + horizontalAlignment).append(", ")
				.append(component != null ? "component={" + component.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("component")
	public UiClientObjectReference getComponent() {
		return component;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("row")
	public int getRow() {
		return row;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("column")
	public int getColumn() {
		return column;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("rowSpan")
	public int getRowSpan() {
		return rowSpan;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("colSpan")
	public int getColSpan() {
		return colSpan;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("minWidth")
	public int getMinWidth() {
		return minWidth;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("maxWidth")
	public int getMaxWidth() {
		return maxWidth;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("minHeight")
	public int getMinHeight() {
		return minHeight;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("maxHeight")
	public int getMaxHeight() {
		return maxHeight;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("verticalAlignment")
	public UiVerticalElementAlignment getVerticalAlignment() {
		return verticalAlignment;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("horizontalAlignment")
	public UiHorizontalElementAlignment getHorizontalAlignment() {
		return horizontalAlignment;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("row")
	public UiComponentGridPlacement setRow(int row) {
		this.row = row;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("column")
	public UiComponentGridPlacement setColumn(int column) {
		this.column = column;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("rowSpan")
	public UiComponentGridPlacement setRowSpan(int rowSpan) {
		this.rowSpan = rowSpan;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("colSpan")
	public UiComponentGridPlacement setColSpan(int colSpan) {
		this.colSpan = colSpan;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("minWidth")
	public UiComponentGridPlacement setMinWidth(int minWidth) {
		this.minWidth = minWidth;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("maxWidth")
	public UiComponentGridPlacement setMaxWidth(int maxWidth) {
		this.maxWidth = maxWidth;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("minHeight")
	public UiComponentGridPlacement setMinHeight(int minHeight) {
		this.minHeight = minHeight;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("maxHeight")
	public UiComponentGridPlacement setMaxHeight(int maxHeight) {
		this.maxHeight = maxHeight;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("verticalAlignment")
	public UiComponentGridPlacement setVerticalAlignment(UiVerticalElementAlignment verticalAlignment) {
		this.verticalAlignment = verticalAlignment;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("horizontalAlignment")
	public UiComponentGridPlacement setHorizontalAlignment(UiHorizontalElementAlignment horizontalAlignment) {
		this.horizontalAlignment = horizontalAlignment;
		return this;
	}






}