package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiMediaSoupV2WebRtcClient extends UiComponent implements UiObject {


	@JsonSerialize(using = ObjectSerializer.class)
	@JsonDeserialize(using = ObjectDeserializer.class)
	protected Object initialPlaybackOrPublishParams;
	protected Float displayAreaAspectRatio = 4/3f;
	protected boolean activityLineVisible;
	protected UiColor activityInactiveColor;
	protected UiColor activityActiveColor;
	protected boolean active;
	protected List<String> icons;
	protected String caption;
	protected String noVideoImageUrl;
	protected WebRtcClientSpinnerPolicy spinnerPolicy;
	protected double playbackVolume = 1;
	protected boolean contextMenuEnabled = false;

	public UiMediaSoupV2WebRtcClient() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("initialPlaybackOrPublishParams=" + initialPlaybackOrPublishParams).append(", ")
				.append("displayAreaAspectRatio=" + displayAreaAspectRatio).append(", ")
				.append("activityLineVisible=" + activityLineVisible).append(", ")
				.append("active=" + active).append(", ")
				.append("icons=" + icons).append(", ")
				.append("caption=" + caption).append(", ")
				.append("noVideoImageUrl=" + noVideoImageUrl).append(", ")
				.append("spinnerPolicy=" + spinnerPolicy).append(", ")
				.append("playbackVolume=" + playbackVolume).append(", ")
				.append("contextMenuEnabled=" + contextMenuEnabled).append(", ")
				.append(activityInactiveColor != null ? "activityInactiveColor={" + activityInactiveColor.toString() + "}" : "").append(", ")
				.append(activityActiveColor != null ? "activityActiveColor={" + activityActiveColor.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("initialPlaybackOrPublishParams")
	public Object getInitialPlaybackOrPublishParams() {
		return initialPlaybackOrPublishParams;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("displayAreaAspectRatio")
	public Float getDisplayAreaAspectRatio() {
		return displayAreaAspectRatio;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("activityLineVisible")
	public boolean getActivityLineVisible() {
		return activityLineVisible;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("activityInactiveColor")
	public UiColor getActivityInactiveColor() {
		return activityInactiveColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("activityActiveColor")
	public UiColor getActivityActiveColor() {
		return activityActiveColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("active")
	public boolean getActive() {
		return active;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("icons")
	public List<String> getIcons() {
		return icons;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("caption")
	public String getCaption() {
		return caption;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("noVideoImageUrl")
	public String getNoVideoImageUrl() {
		return noVideoImageUrl;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("spinnerPolicy")
	public WebRtcClientSpinnerPolicy getSpinnerPolicy() {
		return spinnerPolicy;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("playbackVolume")
	public double getPlaybackVolume() {
		return playbackVolume;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("contextMenuEnabled")
	public boolean getContextMenuEnabled() {
		return contextMenuEnabled;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiMediaSoupV2WebRtcClient setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiMediaSoupV2WebRtcClient setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiMediaSoupV2WebRtcClient setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiMediaSoupV2WebRtcClient setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("initialPlaybackOrPublishParams")
	public UiMediaSoupV2WebRtcClient setInitialPlaybackOrPublishParams(Object initialPlaybackOrPublishParams) {
		this.initialPlaybackOrPublishParams = initialPlaybackOrPublishParams;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("displayAreaAspectRatio")
	public UiMediaSoupV2WebRtcClient setDisplayAreaAspectRatio(Float displayAreaAspectRatio) {
		this.displayAreaAspectRatio = displayAreaAspectRatio;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("activityLineVisible")
	public UiMediaSoupV2WebRtcClient setActivityLineVisible(boolean activityLineVisible) {
		this.activityLineVisible = activityLineVisible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("activityInactiveColor")
	public UiMediaSoupV2WebRtcClient setActivityInactiveColor(UiColor activityInactiveColor) {
		this.activityInactiveColor = activityInactiveColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("activityActiveColor")
	public UiMediaSoupV2WebRtcClient setActivityActiveColor(UiColor activityActiveColor) {
		this.activityActiveColor = activityActiveColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("active")
	public UiMediaSoupV2WebRtcClient setActive(boolean active) {
		this.active = active;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("icons")
	public UiMediaSoupV2WebRtcClient setIcons(List<String> icons) {
		this.icons = icons;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("caption")
	public UiMediaSoupV2WebRtcClient setCaption(String caption) {
		this.caption = caption;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("noVideoImageUrl")
	public UiMediaSoupV2WebRtcClient setNoVideoImageUrl(String noVideoImageUrl) {
		this.noVideoImageUrl = noVideoImageUrl;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("spinnerPolicy")
	public UiMediaSoupV2WebRtcClient setSpinnerPolicy(WebRtcClientSpinnerPolicy spinnerPolicy) {
		this.spinnerPolicy = spinnerPolicy;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("playbackVolume")
	public UiMediaSoupV2WebRtcClient setPlaybackVolume(double playbackVolume) {
		this.playbackVolume = playbackVolume;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("contextMenuEnabled")
	public UiMediaSoupV2WebRtcClient setContextMenuEnabled(boolean contextMenuEnabled) {
		this.contextMenuEnabled = contextMenuEnabled;
		return this;
	}

	public static class PublishingSucceededEvent implements UiEvent {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public PublishingSucceededEvent() {
			// default constructor for Jackson
		}

		public PublishingSucceededEvent(String componentId) {
			this.componentId = componentId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_PUBLISHING_SUCCEEDED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class PublishingFailedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected WebRtcPublishingFailureReason reason;
		protected String errorMessage;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public PublishingFailedEvent() {
			// default constructor for Jackson
		}

		public PublishingFailedEvent(String componentId, WebRtcPublishingFailureReason reason, String errorMessage) {
			this.componentId = componentId;
			this.reason = reason;
			this.errorMessage = errorMessage;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_PUBLISHING_FAILED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("reason=" + reason).append(", ")
					.append("errorMessage=" + errorMessage)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("reason")
		public WebRtcPublishingFailureReason getReason() {
			return reason;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("errorMessage")
		public String getErrorMessage() {
			return errorMessage;
		}

	}

	public static class PublishedStreamEndedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected boolean isDisplay;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public PublishedStreamEndedEvent() {
			// default constructor for Jackson
		}

		public PublishedStreamEndedEvent(String componentId, boolean isDisplay) {
			this.componentId = componentId;
			this.isDisplay = isDisplay;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_PUBLISHED_STREAM_ENDED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("isDisplay=" + isDisplay)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("isDisplay")
		public boolean getIsDisplay() {
			return isDisplay;
		}

	}

	public static class PublishedStreamsStatusChangedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected boolean audio;
		protected boolean video;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public PublishedStreamsStatusChangedEvent() {
			// default constructor for Jackson
		}

		public PublishedStreamsStatusChangedEvent(String componentId, boolean audio, boolean video) {
			this.componentId = componentId;
			this.audio = audio;
			this.video = video;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_PUBLISHED_STREAMS_STATUS_CHANGED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("audio=" + audio).append(", ")
					.append("video=" + video)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("audio")
		public boolean getAudio() {
			return audio;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("video")
		public boolean getVideo() {
			return video;
		}

	}

	public static class ConnectionStateChangedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected boolean connected;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ConnectionStateChangedEvent() {
			// default constructor for Jackson
		}

		public ConnectionStateChangedEvent(String componentId, boolean connected) {
			this.componentId = componentId;
			this.connected = connected;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_CONNECTION_STATE_CHANGED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("connected=" + connected)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("connected")
		public boolean getConnected() {
			return connected;
		}

	}

	public static class PlaybackSucceededEvent implements UiEvent {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public PlaybackSucceededEvent() {
			// default constructor for Jackson
		}

		public PlaybackSucceededEvent(String componentId) {
			this.componentId = componentId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_PLAYBACK_SUCCEEDED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class PlaybackFailedEvent implements UiEvent {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public PlaybackFailedEvent() {
			// default constructor for Jackson
		}

		public PlaybackFailedEvent(String componentId) {
			this.componentId = componentId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_PLAYBACK_FAILED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class PlaybackProfileChangedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected UiMulticastPlaybackProfile profile;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public PlaybackProfileChangedEvent() {
			// default constructor for Jackson
		}

		public PlaybackProfileChangedEvent(String componentId, UiMulticastPlaybackProfile profile) {
			this.componentId = componentId;
			this.profile = profile;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_PLAYBACK_PROFILE_CHANGED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("profile=" + profile)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("profile")
		public UiMulticastPlaybackProfile getProfile() {
			return profile;
		}

	}

	public static class VoiceActivityChangedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected boolean active;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public VoiceActivityChangedEvent() {
			// default constructor for Jackson
		}

		public VoiceActivityChangedEvent(String componentId, boolean active) {
			this.componentId = componentId;
			this.active = active;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_VOICE_ACTIVITY_CHANGED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("active=" + active)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("active")
		public boolean getActive() {
			return active;
		}

	}

	public static class ClickedEvent implements UiEvent {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ClickedEvent() {
			// default constructor for Jackson
		}

		public ClickedEvent(String componentId) {
			this.componentId = componentId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_CLICKED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class ContextMenuRequestedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected int requestId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ContextMenuRequestedEvent() {
			// default constructor for Jackson
		}

		public ContextMenuRequestedEvent(String componentId, int requestId) {
			this.componentId = componentId;
			this.requestId = requestId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_MEDIA_SOUP_V2_WEB_RTC_CLIENT_CONTEXT_MENU_REQUESTED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("requestId=" + requestId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("requestId")
		public int getRequestId() {
			return requestId;
		}

	}

	public static class UpdateCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiMediaSoupV2WebRtcClient config;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UpdateCommand() {
			// default constructor for Jackson
		}

		public UpdateCommand(String componentId, UiMediaSoupV2WebRtcClient config) {
			this.componentId = componentId;
			this.config = config;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(config != null ? "config={" + config.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("config")
		public UiMediaSoupV2WebRtcClient getConfig() {
			return config;
		}

	}

	public static class SetActiveCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected boolean active;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetActiveCommand() {
			// default constructor for Jackson
		}

		public SetActiveCommand(String componentId, boolean active) {
			this.componentId = componentId;
			this.active = active;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("active=" + active)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("active")
		public boolean getActive() {
			return active;
		}

	}

	public static class PublishCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiMediaSoupPublishingParameters parameters;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public PublishCommand() {
			// default constructor for Jackson
		}

		public PublishCommand(String componentId, UiMediaSoupPublishingParameters parameters) {
			this.componentId = componentId;
			this.parameters = parameters;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(parameters != null ? "parameters={" + parameters.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("parameters")
		public UiMediaSoupPublishingParameters getParameters() {
			return parameters;
		}

	}

	public static class PlaybackCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiMediaSoupPlaybackParamaters parameters;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public PlaybackCommand() {
			// default constructor for Jackson
		}

		public PlaybackCommand(String componentId, UiMediaSoupPlaybackParamaters parameters) {
			this.componentId = componentId;
			this.parameters = parameters;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(parameters != null ? "parameters={" + parameters.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("parameters")
		public UiMediaSoupPlaybackParamaters getParameters() {
			return parameters;
		}

	}

	public static class StopCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public StopCommand() {
			// default constructor for Jackson
		}

		public StopCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class SetContextMenuContentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int requestId;
		protected UiClientObjectReference component;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetContextMenuContentCommand() {
			// default constructor for Jackson
		}

		public SetContextMenuContentCommand(String componentId, int requestId, UiClientObjectReference component) {
			this.componentId = componentId;
			this.requestId = requestId;
			this.component = component;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("requestId=" + requestId).append(", ")
					.append(component != null ? "component={" + component.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("requestId")
		public int getRequestId() {
			return requestId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("component")
		public UiClientObjectReference getComponent() {
			return component;
		}

	}

	public static class CloseContextMenuCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int requestId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public CloseContextMenuCommand() {
			// default constructor for Jackson
		}

		public CloseContextMenuCommand(String componentId, int requestId) {
			this.componentId = componentId;
			this.requestId = requestId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("requestId=" + requestId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("requestId")
		public int getRequestId() {
			return requestId;
		}

	}

	public static class EnumerateDevicesCommand implements UiCommand<List<UiMediaDeviceInfo>> {


		public EnumerateDevicesCommand() {
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.toString();
		}


		public String getComponentId() {
			return null;
		}

	}




}