package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiButton extends UiComponent implements UiObject {


	protected UiTemplate template;

	@JsonSerialize(using = ObjectSerializer.class)
	@JsonDeserialize(using = ObjectDeserializer.class)
	protected Object templateRecord;
	protected int minDropDownWidth = 450;
	protected int minDropDownHeight = 200;
	protected boolean openDropDownIfNotSet = false;
	protected UiClientObjectReference dropDownComponent;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiButton() {
		// default constructor for Jackson
	}

	public UiButton(UiTemplate template, Object templateRecord) {
		super();
		this.template = template;
		this.templateRecord = templateRecord;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_BUTTON;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append(template != null ? "template={" + template.toString() + "}" : "").append(", ")
				.append("templateRecord=" + templateRecord).append(", ")
				.append("minDropDownWidth=" + minDropDownWidth).append(", ")
				.append("minDropDownHeight=" + minDropDownHeight).append(", ")
				.append("openDropDownIfNotSet=" + openDropDownIfNotSet).append(", ")
				.append(dropDownComponent != null ? "dropDownComponent={" + dropDownComponent.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("template")
	public UiTemplate getTemplate() {
		return template;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("templateRecord")
	public Object getTemplateRecord() {
		return templateRecord;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("minDropDownWidth")
	public int getMinDropDownWidth() {
		return minDropDownWidth;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("minDropDownHeight")
	public int getMinDropDownHeight() {
		return minDropDownHeight;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("openDropDownIfNotSet")
	public boolean getOpenDropDownIfNotSet() {
		return openDropDownIfNotSet;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("dropDownComponent")
	public UiClientObjectReference getDropDownComponent() {
		return dropDownComponent;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiButton setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiButton setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiButton setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiButton setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("minDropDownWidth")
	public UiButton setMinDropDownWidth(int minDropDownWidth) {
		this.minDropDownWidth = minDropDownWidth;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("minDropDownHeight")
	public UiButton setMinDropDownHeight(int minDropDownHeight) {
		this.minDropDownHeight = minDropDownHeight;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("openDropDownIfNotSet")
	public UiButton setOpenDropDownIfNotSet(boolean openDropDownIfNotSet) {
		this.openDropDownIfNotSet = openDropDownIfNotSet;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("dropDownComponent")
	public UiButton setDropDownComponent(UiClientObjectReference dropDownComponent) {
		this.dropDownComponent = dropDownComponent;
		return this;
	}

	public static class ClickedEvent implements UiEvent {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ClickedEvent() {
			// default constructor for Jackson
		}

		public ClickedEvent(String componentId) {
			this.componentId = componentId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_BUTTON_CLICKED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class DropDownOpenedEvent implements UiEvent {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public DropDownOpenedEvent() {
			// default constructor for Jackson
		}

		public DropDownOpenedEvent(String componentId) {
			this.componentId = componentId;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_BUTTON_DROP_DOWN_OPENED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class SetTemplateCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiTemplate template;

		@JsonSerialize(using = ObjectSerializer.class)
		@JsonDeserialize(using = ObjectDeserializer.class)
		protected Object templateRecord;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetTemplateCommand() {
			// default constructor for Jackson
		}

		public SetTemplateCommand(String componentId, UiTemplate template, Object templateRecord) {
			this.componentId = componentId;
			this.template = template;
			this.templateRecord = templateRecord;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(template != null ? "template={" + template.toString() + "}" : "").append(", ")
					.append("templateRecord=" + templateRecord)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("template")
		public UiTemplate getTemplate() {
			return template;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("templateRecord")
		public Object getTemplateRecord() {
			return templateRecord;
		}

	}

	public static class SetTemplateRecordCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		@JsonSerialize(using = ObjectSerializer.class)
		@JsonDeserialize(using = ObjectDeserializer.class)
		protected Object templateRecord;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetTemplateRecordCommand() {
			// default constructor for Jackson
		}

		public SetTemplateRecordCommand(String componentId, Object templateRecord) {
			this.componentId = componentId;
			this.templateRecord = templateRecord;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("templateRecord=" + templateRecord)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("templateRecord")
		public Object getTemplateRecord() {
			return templateRecord;
		}

	}

	public static class SetDropDownSizeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int minDropDownWidth;
		protected int minDropDownHeight;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetDropDownSizeCommand() {
			// default constructor for Jackson
		}

		public SetDropDownSizeCommand(String componentId, int minDropDownWidth, int minDropDownHeight) {
			this.componentId = componentId;
			this.minDropDownWidth = minDropDownWidth;
			this.minDropDownHeight = minDropDownHeight;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("minDropDownWidth=" + minDropDownWidth).append(", ")
					.append("minDropDownHeight=" + minDropDownHeight)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("minDropDownWidth")
		public int getMinDropDownWidth() {
			return minDropDownWidth;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("minDropDownHeight")
		public int getMinDropDownHeight() {
			return minDropDownHeight;
		}

	}

	public static class SetOpenDropDownIfNotSetCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected boolean openDropDownIfNotSet;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetOpenDropDownIfNotSetCommand() {
			// default constructor for Jackson
		}

		public SetOpenDropDownIfNotSetCommand(String componentId, boolean openDropDownIfNotSet) {
			this.componentId = componentId;
			this.openDropDownIfNotSet = openDropDownIfNotSet;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("openDropDownIfNotSet=" + openDropDownIfNotSet)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("openDropDownIfNotSet")
		public boolean getOpenDropDownIfNotSet() {
			return openDropDownIfNotSet;
		}

	}

	public static class SetDropDownComponentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiClientObjectReference dropDownComponent;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetDropDownComponentCommand() {
			// default constructor for Jackson
		}

		public SetDropDownComponentCommand(String componentId, UiClientObjectReference dropDownComponent) {
			this.componentId = componentId;
			this.dropDownComponent = dropDownComponent;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(dropDownComponent != null ? "dropDownComponent={" + dropDownComponent.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("dropDownComponent")
		public UiClientObjectReference getDropDownComponent() {
			return dropDownComponent;
		}

	}




}