/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiNetworkImage;
import org.teamapps.dto.UiNetworkLink;
import org.teamapps.dto.UiNetworkNode;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiNetworkGraph
extends UiComponent
implements UiObject {
    protected List<UiNetworkNode> nodes;
    protected List<UiNetworkLink> links;
    protected List<UiNetworkImage> images;
    protected float gravity = 0.1f;
    protected float theta = 0.3f;
    protected float alpha = 0.1f;
    protected int charge = -300;
    protected int distance = 30;
    protected String highlightColor;
    protected int animationDuration = 1000;

    @Deprecated
    public UiNetworkGraph() {
    }

    public UiNetworkGraph(List<UiNetworkNode> nodes, List<UiNetworkLink> links, List<UiNetworkImage> images) {
        this.nodes = nodes;
        this.links = links;
        this.images = images;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_NETWORK_GRAPH;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("gravity=" + this.gravity) + ", " + ("theta=" + this.theta) + ", " + ("alpha=" + this.alpha) + ", " + ("charge=" + this.charge) + ", " + ("distance=" + this.distance) + ", " + ("highlightColor=" + this.highlightColor) + ", " + ("animationDuration=" + this.animationDuration) + ", " + (String)(this.nodes != null ? "nodes={" + this.nodes.toString() + "}" : "") + ", " + (String)(this.links != null ? "links={" + this.links.toString() + "}" : "") + ", " + (String)(this.images != null ? "images={" + this.images.toString() + "}" : "");
    }

    @JsonGetter(value="nodes")
    public List<UiNetworkNode> getNodes() {
        return this.nodes;
    }

    @JsonGetter(value="links")
    public List<UiNetworkLink> getLinks() {
        return this.links;
    }

    @JsonGetter(value="images")
    public List<UiNetworkImage> getImages() {
        return this.images;
    }

    @JsonGetter(value="gravity")
    public float getGravity() {
        return this.gravity;
    }

    @JsonGetter(value="theta")
    public float getTheta() {
        return this.theta;
    }

    @JsonGetter(value="alpha")
    public float getAlpha() {
        return this.alpha;
    }

    @JsonGetter(value="charge")
    public int getCharge() {
        return this.charge;
    }

    @JsonGetter(value="distance")
    public int getDistance() {
        return this.distance;
    }

    @JsonGetter(value="highlightColor")
    public String getHighlightColor() {
        return this.highlightColor;
    }

    @JsonGetter(value="animationDuration")
    public int getAnimationDuration() {
        return this.animationDuration;
    }

    @Override
    @JsonSetter(value="id")
    public UiNetworkGraph setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiNetworkGraph setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiNetworkGraph setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiNetworkGraph setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="gravity")
    public UiNetworkGraph setGravity(float gravity) {
        this.gravity = gravity;
        return this;
    }

    @JsonSetter(value="theta")
    public UiNetworkGraph setTheta(float theta) {
        this.theta = theta;
        return this;
    }

    @JsonSetter(value="alpha")
    public UiNetworkGraph setAlpha(float alpha) {
        this.alpha = alpha;
        return this;
    }

    @JsonSetter(value="charge")
    public UiNetworkGraph setCharge(int charge) {
        this.charge = charge;
        return this;
    }

    @JsonSetter(value="distance")
    public UiNetworkGraph setDistance(int distance) {
        this.distance = distance;
        return this;
    }

    @JsonSetter(value="highlightColor")
    public UiNetworkGraph setHighlightColor(String highlightColor) {
        this.highlightColor = highlightColor;
        return this;
    }

    @JsonSetter(value="animationDuration")
    public UiNetworkGraph setAnimationDuration(int animationDuration) {
        this.animationDuration = animationDuration;
        return this;
    }

    public static class RemoveNodesAndLinksCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<String> nodeIds;
        protected Map<String, List<String>> linksBySourceNodeId;

        @Deprecated
        public RemoveNodesAndLinksCommand() {
        }

        public RemoveNodesAndLinksCommand(String componentId, List<String> nodeIds, Map<String, List<String>> linksBySourceNodeId) {
            this.componentId = componentId;
            this.nodeIds = nodeIds;
            this.linksBySourceNodeId = linksBySourceNodeId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("nodeIds=" + this.nodeIds) + ", " + ("linksBySourceNodeId=" + this.linksBySourceNodeId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="nodeIds")
        public List<String> getNodeIds() {
            return this.nodeIds;
        }

        @JsonGetter(value="linksBySourceNodeId")
        public Map<String, List<String>> getLinksBySourceNodeId() {
            return this.linksBySourceNodeId;
        }
    }

    public static class AddNodesAndLinksCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<UiNetworkNode> nodes;
        protected List<UiNetworkLink> links;

        @Deprecated
        public AddNodesAndLinksCommand() {
        }

        public AddNodesAndLinksCommand(String componentId, List<UiNetworkNode> nodes, List<UiNetworkLink> links) {
            this.componentId = componentId;
            this.nodes = nodes;
            this.links = links;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.nodes != null ? "nodes={" + this.nodes.toString() + "}" : "") + ", " + (String)(this.links != null ? "links={" + this.links.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="nodes")
        public List<UiNetworkNode> getNodes() {
            return this.nodes;
        }

        @JsonGetter(value="links")
        public List<UiNetworkLink> getLinks() {
            return this.links;
        }
    }

    public static class ZoomAllNodesIntoViewCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int animationDuration;

        @Deprecated
        public ZoomAllNodesIntoViewCommand() {
        }

        public ZoomAllNodesIntoViewCommand(String componentId, int animationDuration) {
            this.componentId = componentId;
            this.animationDuration = animationDuration;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("animationDuration=" + this.animationDuration);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="animationDuration")
        public int getAnimationDuration() {
            return this.animationDuration;
        }
    }

    public static class SetDistanceCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int distance;
        protected boolean overrideLinkDistance;

        @Deprecated
        public SetDistanceCommand() {
        }

        public SetDistanceCommand(String componentId, int distance, boolean overrideLinkDistance) {
            this.componentId = componentId;
            this.distance = distance;
            this.overrideLinkDistance = overrideLinkDistance;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("distance=" + this.distance) + ", " + ("overrideLinkDistance=" + this.overrideLinkDistance);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="distance")
        public int getDistance() {
            return this.distance;
        }

        @JsonGetter(value="overrideLinkDistance")
        public boolean getOverrideLinkDistance() {
            return this.overrideLinkDistance;
        }
    }

    public static class SetChargeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int charge;
        protected boolean overrideNodeCharge;

        @Deprecated
        public SetChargeCommand() {
        }

        public SetChargeCommand(String componentId, int charge, boolean overrideNodeCharge) {
            this.componentId = componentId;
            this.charge = charge;
            this.overrideNodeCharge = overrideNodeCharge;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("charge=" + this.charge) + ", " + ("overrideNodeCharge=" + this.overrideNodeCharge);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="charge")
        public int getCharge() {
            return this.charge;
        }

        @JsonGetter(value="overrideNodeCharge")
        public boolean getOverrideNodeCharge() {
            return this.overrideNodeCharge;
        }
    }

    public static class SetGravityCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected float gravity;

        @Deprecated
        public SetGravityCommand() {
        }

        public SetGravityCommand(String componentId, float gravity) {
            this.componentId = componentId;
            this.gravity = gravity;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("gravity=" + this.gravity);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="gravity")
        public float getGravity() {
            return this.gravity;
        }
    }

    public static class SetZoomFactorCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected float zoomFactor;

        @Deprecated
        public SetZoomFactorCommand() {
        }

        public SetZoomFactorCommand(String componentId, float zoomFactor) {
            this.componentId = componentId;
            this.zoomFactor = zoomFactor;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("zoomFactor=" + this.zoomFactor);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="zoomFactor")
        public float getZoomFactor() {
            return this.zoomFactor;
        }
    }

    public static class NodeExpandedOrCollapsedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String nodeId;
        protected boolean expanded;

        @Deprecated
        public NodeExpandedOrCollapsedEvent() {
        }

        public NodeExpandedOrCollapsedEvent(String componentId, String nodeId, boolean expanded) {
            this.componentId = componentId;
            this.nodeId = nodeId;
            this.expanded = expanded;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_NETWORK_GRAPH_NODE_EXPANDED_OR_COLLAPSED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("nodeId=" + this.nodeId) + ", " + ("expanded=" + this.expanded);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="nodeId")
        public String getNodeId() {
            return this.nodeId;
        }

        @JsonGetter(value="expanded")
        public boolean getExpanded() {
            return this.expanded;
        }
    }

    public static class NodeClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String nodeId;

        @Deprecated
        public NodeClickedEvent() {
        }

        public NodeClickedEvent(String componentId, String nodeId) {
            this.componentId = componentId;
            this.nodeId = nodeId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_NETWORK_GRAPH_NODE_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("nodeId=" + this.nodeId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="nodeId")
        public String getNodeId() {
            return this.nodeId;
        }
    }
}

