/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiColor;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiFloatingComponentPosition;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiFloatingComponent
extends UiComponent
implements UiObject {
    protected UiClientObjectReference containerComponent;
    protected UiClientObjectReference contentComponent;
    protected int width;
    protected int height;
    protected int marginX;
    protected int marginY;
    protected UiFloatingComponentPosition position;
    protected UiColor backgroundColor;
    protected UiColor expanderHandleColor;
    protected boolean collapsible = true;
    protected boolean expanded = true;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_FLOATING_COMPONENT;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("width=" + this.width) + ", " + ("height=" + this.height) + ", " + ("marginX=" + this.marginX) + ", " + ("marginY=" + this.marginY) + ", " + ("position=" + this.position) + ", " + ("collapsible=" + this.collapsible) + ", " + ("expanded=" + this.expanded) + ", " + (String)(this.containerComponent != null ? "containerComponent={" + this.containerComponent.toString() + "}" : "") + ", " + (String)(this.contentComponent != null ? "contentComponent={" + this.contentComponent.toString() + "}" : "") + ", " + (String)(this.backgroundColor != null ? "backgroundColor={" + this.backgroundColor.toString() + "}" : "") + ", " + (String)(this.expanderHandleColor != null ? "expanderHandleColor={" + this.expanderHandleColor.toString() + "}" : "");
    }

    @JsonGetter(value="containerComponent")
    public UiClientObjectReference getContainerComponent() {
        return this.containerComponent;
    }

    @JsonGetter(value="contentComponent")
    public UiClientObjectReference getContentComponent() {
        return this.contentComponent;
    }

    @JsonGetter(value="width")
    public int getWidth() {
        return this.width;
    }

    @JsonGetter(value="height")
    public int getHeight() {
        return this.height;
    }

    @JsonGetter(value="marginX")
    public int getMarginX() {
        return this.marginX;
    }

    @JsonGetter(value="marginY")
    public int getMarginY() {
        return this.marginY;
    }

    @JsonGetter(value="position")
    public UiFloatingComponentPosition getPosition() {
        return this.position;
    }

    @JsonGetter(value="backgroundColor")
    public UiColor getBackgroundColor() {
        return this.backgroundColor;
    }

    @JsonGetter(value="expanderHandleColor")
    public UiColor getExpanderHandleColor() {
        return this.expanderHandleColor;
    }

    @JsonGetter(value="collapsible")
    public boolean getCollapsible() {
        return this.collapsible;
    }

    @JsonGetter(value="expanded")
    public boolean getExpanded() {
        return this.expanded;
    }

    @Override
    @JsonSetter(value="id")
    public UiFloatingComponent setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiFloatingComponent setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiFloatingComponent setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiFloatingComponent setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="containerComponent")
    public UiFloatingComponent setContainerComponent(UiClientObjectReference containerComponent) {
        this.containerComponent = containerComponent;
        return this;
    }

    @JsonSetter(value="contentComponent")
    public UiFloatingComponent setContentComponent(UiClientObjectReference contentComponent) {
        this.contentComponent = contentComponent;
        return this;
    }

    @JsonSetter(value="width")
    public UiFloatingComponent setWidth(int width) {
        this.width = width;
        return this;
    }

    @JsonSetter(value="height")
    public UiFloatingComponent setHeight(int height) {
        this.height = height;
        return this;
    }

    @JsonSetter(value="marginX")
    public UiFloatingComponent setMarginX(int marginX) {
        this.marginX = marginX;
        return this;
    }

    @JsonSetter(value="marginY")
    public UiFloatingComponent setMarginY(int marginY) {
        this.marginY = marginY;
        return this;
    }

    @JsonSetter(value="position")
    public UiFloatingComponent setPosition(UiFloatingComponentPosition position) {
        this.position = position;
        return this;
    }

    @JsonSetter(value="backgroundColor")
    public UiFloatingComponent setBackgroundColor(UiColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @JsonSetter(value="expanderHandleColor")
    public UiFloatingComponent setExpanderHandleColor(UiColor expanderHandleColor) {
        this.expanderHandleColor = expanderHandleColor;
        return this;
    }

    @JsonSetter(value="collapsible")
    public UiFloatingComponent setCollapsible(boolean collapsible) {
        this.collapsible = collapsible;
        return this;
    }

    @JsonSetter(value="expanded")
    public UiFloatingComponent setExpanded(boolean expanded) {
        this.expanded = expanded;
        return this;
    }

    public static class SetExpanderHandleColorCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiColor expanderHandleColor;

        @Deprecated
        public SetExpanderHandleColorCommand() {
        }

        public SetExpanderHandleColorCommand(String componentId, UiColor expanderHandleColor) {
            this.componentId = componentId;
            this.expanderHandleColor = expanderHandleColor;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.expanderHandleColor != null ? "expanderHandleColor={" + this.expanderHandleColor.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="expanderHandleColor")
        public UiColor getExpanderHandleColor() {
            return this.expanderHandleColor;
        }
    }

    public static class SetBackgroundColorCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiColor backgroundColor;

        @Deprecated
        public SetBackgroundColorCommand() {
        }

        public SetBackgroundColorCommand(String componentId, UiColor backgroundColor) {
            this.componentId = componentId;
            this.backgroundColor = backgroundColor;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.backgroundColor != null ? "backgroundColor={" + this.backgroundColor.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="backgroundColor")
        public UiColor getBackgroundColor() {
            return this.backgroundColor;
        }
    }

    public static class SetMarginsCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int marginX;
        protected int marginY;

        @Deprecated
        public SetMarginsCommand() {
        }

        public SetMarginsCommand(String componentId, int marginX, int marginY) {
            this.componentId = componentId;
            this.marginX = marginX;
            this.marginY = marginY;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("marginX=" + this.marginX) + ", " + ("marginY=" + this.marginY);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="marginX")
        public int getMarginX() {
            return this.marginX;
        }

        @JsonGetter(value="marginY")
        public int getMarginY() {
            return this.marginY;
        }
    }

    public static class SetDimensionsCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int width;
        protected int height;

        @Deprecated
        public SetDimensionsCommand() {
        }

        public SetDimensionsCommand(String componentId, int width, int height) {
            this.componentId = componentId;
            this.width = width;
            this.height = height;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("width=" + this.width) + ", " + ("height=" + this.height);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="width")
        public int getWidth() {
            return this.width;
        }

        @JsonGetter(value="height")
        public int getHeight() {
            return this.height;
        }
    }

    public static class SetPositionCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiFloatingComponentPosition position;

        @Deprecated
        public SetPositionCommand() {
        }

        public SetPositionCommand(String componentId, UiFloatingComponentPosition position) {
            this.componentId = componentId;
            this.position = position;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("position=" + this.position);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="position")
        public UiFloatingComponentPosition getPosition() {
            return this.position;
        }
    }

    public static class SetExpandedCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected boolean expanded;

        @Deprecated
        public SetExpandedCommand() {
        }

        public SetExpandedCommand(String componentId, boolean expanded) {
            this.componentId = componentId;
            this.expanded = expanded;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("expanded=" + this.expanded);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="expanded")
        public boolean getExpanded() {
            return this.expanded;
        }
    }

    public static class ExpandedOrCollapsedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected boolean expanded;

        @Deprecated
        public ExpandedOrCollapsedEvent() {
        }

        public ExpandedOrCollapsedEvent(String componentId, boolean expanded) {
            this.componentId = componentId;
            this.expanded = expanded;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_FLOATING_COMPONENT_EXPANDED_OR_COLLAPSED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("expanded=" + this.expanded);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="expanded")
        public boolean getExpanded() {
            return this.expanded;
        }
    }
}

