/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import org.teamapps.dto.AbstractUiTemplateElement;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiBorder;
import org.teamapps.dto.UiColor;
import org.teamapps.dto.UiGridColumn;
import org.teamapps.dto.UiGridRow;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiSpacing;
import org.teamapps.dto.UiTemplate;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiGridTemplate
implements UiTemplate,
UiObject {
    protected List<UiGridColumn> columns;
    protected List<UiGridRow> rows;
    protected List<AbstractUiTemplateElement> elements;
    protected int minWidth = 0;
    protected int maxWidth = 0;
    protected int minHeight = 0;
    protected int maxHeight = 0;
    protected UiSpacing padding;
    protected int gridGap = 0;
    protected UiColor backgroundColor;
    protected UiBorder border;

    @Deprecated
    public UiGridTemplate() {
    }

    public UiGridTemplate(List<UiGridColumn> columns, List<UiGridRow> rows, List<AbstractUiTemplateElement> elements) {
        this.columns = columns;
        this.rows = rows;
        this.elements = elements;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_GRID_TEMPLATE;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("minWidth=" + this.minWidth) + ", " + ("maxWidth=" + this.maxWidth) + ", " + ("minHeight=" + this.minHeight) + ", " + ("maxHeight=" + this.maxHeight) + ", " + ("gridGap=" + this.gridGap) + ", " + (String)(this.columns != null ? "columns={" + this.columns.toString() + "}" : "") + ", " + (String)(this.rows != null ? "rows={" + this.rows.toString() + "}" : "") + ", " + (String)(this.elements != null ? "elements={" + this.elements.toString() + "}" : "") + ", " + (String)(this.padding != null ? "padding={" + this.padding.toString() + "}" : "") + ", " + (String)(this.backgroundColor != null ? "backgroundColor={" + this.backgroundColor.toString() + "}" : "") + ", " + (String)(this.border != null ? "border={" + this.border.toString() + "}" : "");
    }

    @JsonGetter(value="columns")
    public List<UiGridColumn> getColumns() {
        return this.columns;
    }

    @JsonGetter(value="rows")
    public List<UiGridRow> getRows() {
        return this.rows;
    }

    @JsonGetter(value="elements")
    public List<AbstractUiTemplateElement> getElements() {
        return this.elements;
    }

    @JsonGetter(value="minWidth")
    public int getMinWidth() {
        return this.minWidth;
    }

    @JsonGetter(value="maxWidth")
    public int getMaxWidth() {
        return this.maxWidth;
    }

    @JsonGetter(value="minHeight")
    public int getMinHeight() {
        return this.minHeight;
    }

    @JsonGetter(value="maxHeight")
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @JsonGetter(value="padding")
    public UiSpacing getPadding() {
        return this.padding;
    }

    @JsonGetter(value="gridGap")
    public int getGridGap() {
        return this.gridGap;
    }

    @JsonGetter(value="backgroundColor")
    public UiColor getBackgroundColor() {
        return this.backgroundColor;
    }

    @JsonGetter(value="border")
    public UiBorder getBorder() {
        return this.border;
    }

    @JsonSetter(value="minWidth")
    public UiGridTemplate setMinWidth(int minWidth) {
        this.minWidth = minWidth;
        return this;
    }

    @JsonSetter(value="maxWidth")
    public UiGridTemplate setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    @JsonSetter(value="minHeight")
    public UiGridTemplate setMinHeight(int minHeight) {
        this.minHeight = minHeight;
        return this;
    }

    @JsonSetter(value="maxHeight")
    public UiGridTemplate setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    @JsonSetter(value="padding")
    public UiGridTemplate setPadding(UiSpacing padding) {
        this.padding = padding;
        return this;
    }

    @JsonSetter(value="gridGap")
    public UiGridTemplate setGridGap(int gridGap) {
        this.gridGap = gridGap;
        return this;
    }

    @JsonSetter(value="backgroundColor")
    public UiGridTemplate setBackgroundColor(UiColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @JsonSetter(value="border")
    public UiGridTemplate setBorder(UiBorder border) {
        this.border = border;
        return this;
    }
}

