package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiCalendar extends UiComponent implements UiObject {


	protected Map<String, UiTemplate> templates;
	protected List<UiCalendarEventClientRecord> initialData;
	protected UiCalendarViewMode activeViewMode = UiCalendarViewMode.MONTH;
	protected long displayedDate = System.currentTimeMillis();
	protected boolean showHeader = true;
	protected boolean tableBorder = true;
	protected boolean showWeekNumbers = true;
	protected int businessHoursStart = 8;
	protected int businessHoursEnd = 17;
	protected UiWeekDay firstDayOfWeek = null;
	protected List<UiWeekDay> workingDays = java.util.Arrays.asList(UiWeekDay.MONDAY, UiWeekDay.TUESDAY, UiWeekDay.WEDNESDAY, UiWeekDay.THURSDAY, UiWeekDay.FRIDAY);
	protected UiColor tableHeaderBackgroundColor = new UiColor(255, 255, 255);
	protected UiColor defaultBackgroundColor = new UiColor(154, 204, 228);
	protected UiColor defaultBorderColor = new UiColor(154, 204, 228);

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiCalendar() {
		// default constructor for Jackson
	}

	public UiCalendar(String id) {
		super(id);
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_CALENDAR;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append(templates != null ? "templates={" + templates.toString() + "}" : "").append(", ")
				.append("activeViewMode=" + activeViewMode).append(", ")
				.append("displayedDate=" + displayedDate).append(", ")
				.append("showHeader=" + showHeader).append(", ")
				.append("tableBorder=" + tableBorder).append(", ")
				.append("showWeekNumbers=" + showWeekNumbers).append(", ")
				.append("businessHoursStart=" + businessHoursStart).append(", ")
				.append("businessHoursEnd=" + businessHoursEnd).append(", ")
				.append("firstDayOfWeek=" + firstDayOfWeek).append(", ")
				.append("workingDays=" + workingDays).append(", ")
				.append(initialData != null ? "initialData={" + initialData.toString() + "}" : "").append(", ")
				.append(tableHeaderBackgroundColor != null ? "tableHeaderBackgroundColor={" + tableHeaderBackgroundColor.toString() + "}" : "").append(", ")
				.append(defaultBackgroundColor != null ? "defaultBackgroundColor={" + defaultBackgroundColor.toString() + "}" : "").append(", ")
				.append(defaultBorderColor != null ? "defaultBorderColor={" + defaultBorderColor.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("templates")
	public Map<String, UiTemplate> getTemplates() {
		return templates;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("initialData")
	public List<UiCalendarEventClientRecord> getInitialData() {
		return initialData;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("activeViewMode")
	public UiCalendarViewMode getActiveViewMode() {
		return activeViewMode;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("displayedDate")
	public long getDisplayedDate() {
		return displayedDate;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("showHeader")
	public boolean getShowHeader() {
		return showHeader;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("tableBorder")
	public boolean getTableBorder() {
		return tableBorder;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("showWeekNumbers")
	public boolean getShowWeekNumbers() {
		return showWeekNumbers;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("businessHoursStart")
	public int getBusinessHoursStart() {
		return businessHoursStart;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("businessHoursEnd")
	public int getBusinessHoursEnd() {
		return businessHoursEnd;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("firstDayOfWeek")
	public UiWeekDay getFirstDayOfWeek() {
		return firstDayOfWeek;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("workingDays")
	public List<UiWeekDay> getWorkingDays() {
		return workingDays;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("tableHeaderBackgroundColor")
	public UiColor getTableHeaderBackgroundColor() {
		return tableHeaderBackgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("defaultBackgroundColor")
	public UiColor getDefaultBackgroundColor() {
		return defaultBackgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("defaultBorderColor")
	public UiColor getDefaultBorderColor() {
		return defaultBorderColor;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiCalendar setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiCalendar setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("templates")
	public UiCalendar setTemplates(Map<String, UiTemplate> templates) {
		this.templates = templates;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("initialData")
	public UiCalendar setInitialData(List<UiCalendarEventClientRecord> initialData) {
		this.initialData = initialData;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("activeViewMode")
	public UiCalendar setActiveViewMode(UiCalendarViewMode activeViewMode) {
		this.activeViewMode = activeViewMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("displayedDate")
	public UiCalendar setDisplayedDate(long displayedDate) {
		this.displayedDate = displayedDate;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("showHeader")
	public UiCalendar setShowHeader(boolean showHeader) {
		this.showHeader = showHeader;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("tableBorder")
	public UiCalendar setTableBorder(boolean tableBorder) {
		this.tableBorder = tableBorder;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("showWeekNumbers")
	public UiCalendar setShowWeekNumbers(boolean showWeekNumbers) {
		this.showWeekNumbers = showWeekNumbers;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("businessHoursStart")
	public UiCalendar setBusinessHoursStart(int businessHoursStart) {
		this.businessHoursStart = businessHoursStart;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("businessHoursEnd")
	public UiCalendar setBusinessHoursEnd(int businessHoursEnd) {
		this.businessHoursEnd = businessHoursEnd;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("firstDayOfWeek")
	public UiCalendar setFirstDayOfWeek(UiWeekDay firstDayOfWeek) {
		this.firstDayOfWeek = firstDayOfWeek;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("workingDays")
	public UiCalendar setWorkingDays(List<UiWeekDay> workingDays) {
		this.workingDays = workingDays;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("tableHeaderBackgroundColor")
	public UiCalendar setTableHeaderBackgroundColor(UiColor tableHeaderBackgroundColor) {
		this.tableHeaderBackgroundColor = tableHeaderBackgroundColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("defaultBackgroundColor")
	public UiCalendar setDefaultBackgroundColor(UiColor defaultBackgroundColor) {
		this.defaultBackgroundColor = defaultBackgroundColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("defaultBorderColor")
	public UiCalendar setDefaultBorderColor(UiColor defaultBorderColor) {
		this.defaultBorderColor = defaultBorderColor;
		return this;
	}

	public static class EventClickedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected int eventId;
		protected boolean isDoubleClick;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public EventClickedEvent() {
			// default constructor for Jackson
		}

		public EventClickedEvent(String componentId, int eventId, boolean isDoubleClick) {
			this.componentId = componentId;
			this.eventId = eventId;
			this.isDoubleClick = isDoubleClick;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_CALENDAR_EVENT_CLICKED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("eventId=" + eventId).append(", ")
					.append("isDoubleClick=" + isDoubleClick)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("eventId")
		public int getEventId() {
			return eventId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("isDoubleClick")
		public boolean getIsDoubleClick() {
			return isDoubleClick;
		}

	}

	public static class EventMovedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected int eventId;
		protected long newStart;
		protected long newEnd;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public EventMovedEvent() {
			// default constructor for Jackson
		}

		public EventMovedEvent(String componentId, int eventId, long newStart, long newEnd) {
			this.componentId = componentId;
			this.eventId = eventId;
			this.newStart = newStart;
			this.newEnd = newEnd;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_CALENDAR_EVENT_MOVED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("eventId=" + eventId).append(", ")
					.append("newStart=" + newStart).append(", ")
					.append("newEnd=" + newEnd)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("eventId")
		public int getEventId() {
			return eventId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("newStart")
		public long getNewStart() {
			return newStart;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("newEnd")
		public long getNewEnd() {
			return newEnd;
		}

	}

	public static class DayClickedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected long date;
		protected boolean isDoubleClick;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public DayClickedEvent() {
			// default constructor for Jackson
		}

		public DayClickedEvent(String componentId, long date, boolean isDoubleClick) {
			this.componentId = componentId;
			this.date = date;
			this.isDoubleClick = isDoubleClick;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_CALENDAR_DAY_CLICKED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("date=" + date).append(", ")
					.append("isDoubleClick=" + isDoubleClick)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("date")
		public long getDate() {
			return date;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("isDoubleClick")
		public boolean getIsDoubleClick() {
			return isDoubleClick;
		}

	}

	public static class ViewChangedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected UiCalendarViewMode viewMode;
		protected long mainIntervalStart;
		protected long mainIntervalEnd;
		protected long displayedIntervalStart;
		protected long displayedIntervalEnd;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ViewChangedEvent() {
			// default constructor for Jackson
		}

		public ViewChangedEvent(String componentId, UiCalendarViewMode viewMode, long mainIntervalStart, long mainIntervalEnd, long displayedIntervalStart, long displayedIntervalEnd) {
			this.componentId = componentId;
			this.viewMode = viewMode;
			this.mainIntervalStart = mainIntervalStart;
			this.mainIntervalEnd = mainIntervalEnd;
			this.displayedIntervalStart = displayedIntervalStart;
			this.displayedIntervalEnd = displayedIntervalEnd;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_CALENDAR_VIEW_CHANGED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("viewMode=" + viewMode).append(", ")
					.append("mainIntervalStart=" + mainIntervalStart).append(", ")
					.append("mainIntervalEnd=" + mainIntervalEnd).append(", ")
					.append("displayedIntervalStart=" + displayedIntervalStart).append(", ")
					.append("displayedIntervalEnd=" + displayedIntervalEnd)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("viewMode")
		public UiCalendarViewMode getViewMode() {
			return viewMode;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mainIntervalStart")
		public long getMainIntervalStart() {
			return mainIntervalStart;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("mainIntervalEnd")
		public long getMainIntervalEnd() {
			return mainIntervalEnd;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("displayedIntervalStart")
		public long getDisplayedIntervalStart() {
			return displayedIntervalStart;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("displayedIntervalEnd")
		public long getDisplayedIntervalEnd() {
			return displayedIntervalEnd;
		}

	}

	public static class DataNeededEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected long requestIntervalStart;
		protected long requestIntervalEnd;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public DataNeededEvent() {
			// default constructor for Jackson
		}

		public DataNeededEvent(String componentId, long requestIntervalStart, long requestIntervalEnd) {
			this.componentId = componentId;
			this.requestIntervalStart = requestIntervalStart;
			this.requestIntervalEnd = requestIntervalEnd;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_CALENDAR_DATA_NEEDED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("requestIntervalStart=" + requestIntervalStart).append(", ")
					.append("requestIntervalEnd=" + requestIntervalEnd)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("requestIntervalStart")
		public long getRequestIntervalStart() {
			return requestIntervalStart;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("requestIntervalEnd")
		public long getRequestIntervalEnd() {
			return requestIntervalEnd;
		}

	}

	public static class SetViewModeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiCalendarViewMode viewMode;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetViewModeCommand() {
			// default constructor for Jackson
		}

		public SetViewModeCommand(String componentId, UiCalendarViewMode viewMode) {
			this.componentId = componentId;
			this.viewMode = viewMode;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("viewMode=" + viewMode)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("viewMode")
		public UiCalendarViewMode getViewMode() {
			return viewMode;
		}

	}

	public static class SetDisplayedDateCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected long date;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetDisplayedDateCommand() {
			// default constructor for Jackson
		}

		public SetDisplayedDateCommand(String componentId, long date) {
			this.componentId = componentId;
			this.date = date;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("date=" + date)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("date")
		public long getDate() {
			return date;
		}

	}

	public static class AddEventCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiCalendarEventClientRecord theEvent;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddEventCommand() {
			// default constructor for Jackson
		}

		public AddEventCommand(String componentId, UiCalendarEventClientRecord theEvent) {
			this.componentId = componentId;
			this.theEvent = theEvent;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(theEvent != null ? "theEvent={" + theEvent.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("theEvent")
		public UiCalendarEventClientRecord getTheEvent() {
			return theEvent;
		}

	}

	public static class RemoveEventCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int eventId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveEventCommand() {
			// default constructor for Jackson
		}

		public RemoveEventCommand(String componentId, int eventId) {
			this.componentId = componentId;
			this.eventId = eventId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("eventId=" + eventId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("eventId")
		public int getEventId() {
			return eventId;
		}

	}

	public static class SetCalendarDataCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<UiCalendarEventClientRecord> events;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetCalendarDataCommand() {
			// default constructor for Jackson
		}

		public SetCalendarDataCommand(String componentId, List<UiCalendarEventClientRecord> events) {
			this.componentId = componentId;
			this.events = events;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(events != null ? "events={" + events.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("events")
		public List<UiCalendarEventClientRecord> getEvents() {
			return events;
		}

	}

	public static class ClearCalendarCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ClearCalendarCommand() {
			// default constructor for Jackson
		}

		public ClearCalendarCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class RegisterTemplateCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String id;
		protected UiTemplate template;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RegisterTemplateCommand() {
			// default constructor for Jackson
		}

		public RegisterTemplateCommand(String componentId, String id, UiTemplate template) {
			this.componentId = componentId;
			this.id = id;
			this.template = template;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("id=" + id).append(", ")
					.append("componentId=" + componentId).append(", ")
					.append(template != null ? "template={" + template.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("id")
		public String getId() {
			return id;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("template")
		public UiTemplate getTemplate() {
			return template;
		}

	}




}