package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiGridForm extends UiComponent implements UiObject {


	protected String recordTypeId;
	protected List<UiComponentReference> fields;
	protected List<UiFormLayoutPolicy> layoutPolicies;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiGridForm() {
		// default constructor for Jackson
	}

	public UiGridForm(String id, String recordTypeId, List<UiComponentReference> fields, List<UiFormLayoutPolicy> layoutPolicies) {
		super(id);
		this.recordTypeId = recordTypeId;
		this.fields = fields;
		this.layoutPolicies = layoutPolicies;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_GRID_FORM;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("recordTypeId=" + recordTypeId).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append(fields != null ? "fields={" + fields.toString() + "}" : "").append(", ")
				.append(layoutPolicies != null ? "layoutPolicies={" + layoutPolicies.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("recordTypeId")
	public String getRecordTypeId() {
		return recordTypeId;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("fields")
	public List<UiComponentReference> getFields() {
		return fields;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("layoutPolicies")
	public List<UiFormLayoutPolicy> getLayoutPolicies() {
		return layoutPolicies;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiGridForm setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiGridForm setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	public static class SectionCollapsedStateChangedEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected String sectionId;
		protected boolean collapsed;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SectionCollapsedStateChangedEvent() {
			// default constructor for Jackson
		}

		public SectionCollapsedStateChangedEvent(String componentId, String sectionId, boolean collapsed) {
			this.componentId = componentId;
			this.sectionId = sectionId;
			this.collapsed = collapsed;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_GRID_FORM_SECTION_COLLAPSED_STATE_CHANGED;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("sectionId=" + sectionId).append(", ")
					.append("collapsed=" + collapsed)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sectionId")
		public String getSectionId() {
			return sectionId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("collapsed")
		public boolean getCollapsed() {
			return collapsed;
		}

	}

	public static class UpdateLayoutPoliciesCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<UiFormLayoutPolicy> layoutPolicies;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public UpdateLayoutPoliciesCommand() {
			// default constructor for Jackson
		}

		public UpdateLayoutPoliciesCommand(String componentId, List<UiFormLayoutPolicy> layoutPolicies) {
			this.componentId = componentId;
			this.layoutPolicies = layoutPolicies;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(layoutPolicies != null ? "layoutPolicies={" + layoutPolicies.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("layoutPolicies")
		public List<UiFormLayoutPolicy> getLayoutPolicies() {
			return layoutPolicies;
		}

	}

	public static class SetSectionCollapsedCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String sectionId;
		protected boolean collapsed;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetSectionCollapsedCommand() {
			// default constructor for Jackson
		}

		public SetSectionCollapsedCommand(String componentId, String sectionId, boolean collapsed) {
			this.componentId = componentId;
			this.sectionId = sectionId;
			this.collapsed = collapsed;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("sectionId=" + sectionId).append(", ")
					.append("collapsed=" + collapsed)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("sectionId")
		public String getSectionId() {
			return sectionId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("collapsed")
		public boolean getCollapsed() {
			return collapsed;
		}

	}

	public static class AddOrReplaceFieldCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiComponentReference field;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddOrReplaceFieldCommand() {
			// default constructor for Jackson
		}

		public AddOrReplaceFieldCommand(String componentId, UiComponentReference field) {
			this.componentId = componentId;
			this.field = field;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(field != null ? "field={" + field.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("field")
		public UiComponentReference getField() {
			return field;
		}

	}




}