package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiLiveStreamComponent extends UiComponent implements UiObject {


	protected String backgroundImage;
	protected UiPageDisplayMode backgroundImageDisplayMode = UiPageDisplayMode.COVER;
	protected float volume = 1;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiLiveStreamComponent() {
		// default constructor for Jackson
	}

	public UiLiveStreamComponent(String id) {
		super(id);
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_LIVE_STREAM_COMPONENT;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("backgroundImage=" + backgroundImage).append(", ")
				.append("backgroundImageDisplayMode=" + backgroundImageDisplayMode).append(", ")
				.append("volume=" + volume)
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundImage")
	public String getBackgroundImage() {
		return backgroundImage;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundImageDisplayMode")
	public UiPageDisplayMode getBackgroundImageDisplayMode() {
		return backgroundImageDisplayMode;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("volume")
	public float getVolume() {
		return volume;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiLiveStreamComponent setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiLiveStreamComponent setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundImage")
	public UiLiveStreamComponent setBackgroundImage(String backgroundImage) {
		this.backgroundImage = backgroundImage;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundImageDisplayMode")
	public UiLiveStreamComponent setBackgroundImageDisplayMode(UiPageDisplayMode backgroundImageDisplayMode) {
		this.backgroundImageDisplayMode = backgroundImageDisplayMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("volume")
	public UiLiveStreamComponent setVolume(float volume) {
		this.volume = volume;
		return this;
	}

	public static class ResultOfRequestInputDeviceAccessEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected boolean microphoneAccessGranted;
		protected boolean cameraAccessGranted;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ResultOfRequestInputDeviceAccessEvent() {
			// default constructor for Jackson
		}

		public ResultOfRequestInputDeviceAccessEvent(String componentId, boolean microphoneAccessGranted, boolean cameraAccessGranted) {
			this.componentId = componentId;
			this.microphoneAccessGranted = microphoneAccessGranted;
			this.cameraAccessGranted = cameraAccessGranted;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_LIVE_STREAM_COMPONENT_RESULT_OF_REQUEST_INPUT_DEVICE_ACCESS;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("microphoneAccessGranted=" + microphoneAccessGranted).append(", ")
					.append("cameraAccessGranted=" + cameraAccessGranted)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("microphoneAccessGranted")
		public boolean getMicrophoneAccessGranted() {
			return microphoneAccessGranted;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("cameraAccessGranted")
		public boolean getCameraAccessGranted() {
			return cameraAccessGranted;
		}

	}

	public static class ResultOfRequestInputDeviceInfoEvent implements UiEvent {

		@UiComponentId protected String componentId;
		protected UiAudioInputDeviceInfo audioInputDeviceInfo;
		protected UiVideoInputDeviceInfo videoInputDeviceInfo;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ResultOfRequestInputDeviceInfoEvent() {
			// default constructor for Jackson
		}

		public ResultOfRequestInputDeviceInfoEvent(String componentId, UiAudioInputDeviceInfo audioInputDeviceInfo, UiVideoInputDeviceInfo videoInputDeviceInfo) {
			this.componentId = componentId;
			this.audioInputDeviceInfo = audioInputDeviceInfo;
			this.videoInputDeviceInfo = videoInputDeviceInfo;
		}

		public UiEventType getUiEventType() {
			return UiEventType.UI_LIVE_STREAM_COMPONENT_RESULT_OF_REQUEST_INPUT_DEVICE_INFO;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(audioInputDeviceInfo != null ? "audioInputDeviceInfo={" + audioInputDeviceInfo.toString() + "}" : "").append(", ")
					.append(videoInputDeviceInfo != null ? "videoInputDeviceInfo={" + videoInputDeviceInfo.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("audioInputDeviceInfo")
		public UiAudioInputDeviceInfo getAudioInputDeviceInfo() {
			return audioInputDeviceInfo;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("videoInputDeviceInfo")
		public UiVideoInputDeviceInfo getVideoInputDeviceInfo() {
			return videoInputDeviceInfo;
		}

	}

	public static class ShowWaitingVideosCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<UiWaitingVideoInfo> videoInfos;
		protected long offsetSeconds;
		protected boolean stopLiveStream;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public ShowWaitingVideosCommand() {
			// default constructor for Jackson
		}

		public ShowWaitingVideosCommand(String componentId, List<UiWaitingVideoInfo> videoInfos, long offsetSeconds, boolean stopLiveStream) {
			this.componentId = componentId;
			this.videoInfos = videoInfos;
			this.offsetSeconds = offsetSeconds;
			this.stopLiveStream = stopLiveStream;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("offsetSeconds=" + offsetSeconds).append(", ")
					.append("stopLiveStream=" + stopLiveStream).append(", ")
					.append(videoInfos != null ? "videoInfos={" + videoInfos.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("videoInfos")
		public List<UiWaitingVideoInfo> getVideoInfos() {
			return videoInfos;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("offsetSeconds")
		public long getOffsetSeconds() {
			return offsetSeconds;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("stopLiveStream")
		public boolean getStopLiveStream() {
			return stopLiveStream;
		}

	}

	public static class StopWaitingVideosCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public StopWaitingVideosCommand() {
			// default constructor for Jackson
		}

		public StopWaitingVideosCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class StartHttpLiveStreamCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String url;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public StartHttpLiveStreamCommand() {
			// default constructor for Jackson
		}

		public StartHttpLiveStreamCommand(String componentId, String url) {
			this.componentId = componentId;
			this.url = url;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("url=" + url)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("url")
		public String getUrl() {
			return url;
		}

	}

	public static class StartLiveStreamComLiveStreamCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String url;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public StartLiveStreamComLiveStreamCommand() {
			// default constructor for Jackson
		}

		public StartLiveStreamComLiveStreamCommand(String componentId, String url) {
			this.componentId = componentId;
			this.url = url;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("url=" + url)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("url")
		public String getUrl() {
			return url;
		}

	}

	public static class StartYouTubeLiveStreamCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String url;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public StartYouTubeLiveStreamCommand() {
			// default constructor for Jackson
		}

		public StartYouTubeLiveStreamCommand(String componentId, String url) {
			this.componentId = componentId;
			this.url = url;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("url=" + url)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("url")
		public String getUrl() {
			return url;
		}

	}

	public static class StartCustomEmbeddedLiveStreamPlayerCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String playerEmbedHtml;
		protected String embedContainerId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public StartCustomEmbeddedLiveStreamPlayerCommand() {
			// default constructor for Jackson
		}

		public StartCustomEmbeddedLiveStreamPlayerCommand(String componentId, String playerEmbedHtml, String embedContainerId) {
			this.componentId = componentId;
			this.playerEmbedHtml = playerEmbedHtml;
			this.embedContainerId = embedContainerId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("embedContainerId=" + embedContainerId).append(", ")
					.append("playerEmbedHtml=" + playerEmbedHtml)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("playerEmbedHtml")
		public String getPlayerEmbedHtml() {
			return playerEmbedHtml;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("embedContainerId")
		public String getEmbedContainerId() {
			return embedContainerId;
		}

	}

	public static class StopLiveStreamCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public StopLiveStreamCommand() {
			// default constructor for Jackson
		}

		public StopLiveStreamCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class DisplayImageOverlayCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String imageUrl;
		protected UiPageDisplayMode displayMode;
		protected boolean useVideoAreaAsFrame;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public DisplayImageOverlayCommand() {
			// default constructor for Jackson
		}

		public DisplayImageOverlayCommand(String componentId, String imageUrl, UiPageDisplayMode displayMode, boolean useVideoAreaAsFrame) {
			this.componentId = componentId;
			this.imageUrl = imageUrl;
			this.displayMode = displayMode;
			this.useVideoAreaAsFrame = useVideoAreaAsFrame;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("imageUrl=" + imageUrl).append(", ")
					.append("displayMode=" + displayMode).append(", ")
					.append("useVideoAreaAsFrame=" + useVideoAreaAsFrame)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("imageUrl")
		public String getImageUrl() {
			return imageUrl;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("displayMode")
		public UiPageDisplayMode getDisplayMode() {
			return displayMode;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("useVideoAreaAsFrame")
		public boolean getUseVideoAreaAsFrame() {
			return useVideoAreaAsFrame;
		}

	}

	public static class RemoveImageOverlayCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveImageOverlayCommand() {
			// default constructor for Jackson
		}

		public RemoveImageOverlayCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class DisplayInfoTextOverlayCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String text;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public DisplayInfoTextOverlayCommand() {
			// default constructor for Jackson
		}

		public DisplayInfoTextOverlayCommand(String componentId, String text) {
			this.componentId = componentId;
			this.text = text;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("text=" + text)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("text")
		public String getText() {
			return text;
		}

	}

	public static class RemoveInfoTextOverlayCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveInfoTextOverlayCommand() {
			// default constructor for Jackson
		}

		public RemoveInfoTextOverlayCommand(String componentId) {
			this.componentId = componentId;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

	}

	public static class SetVolumeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected float volume;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetVolumeCommand() {
			// default constructor for Jackson
		}

		public SetVolumeCommand(String componentId, float volume) {
			this.componentId = componentId;
			this.volume = volume;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("volume=" + volume)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("volume")
		public float getVolume() {
			return volume;
		}

	}




}