/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiComponent
implements UiObject {
    protected String id;
    protected boolean visible = true;
    protected Map<String, Map<String, String>> stylesBySelector;

    @Deprecated
    public UiComponent() {
    }

    public UiComponent(String id) {
        this.id = id;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_COMPONENT;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector);
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonGetter(value="visible")
    public boolean getVisible() {
        return this.visible;
    }

    @JsonGetter(value="stylesBySelector")
    public Map<String, Map<String, String>> getStylesBySelector() {
        return this.stylesBySelector;
    }

    @JsonSetter(value="visible")
    public UiComponent setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @JsonSetter(value="stylesBySelector")
    public UiComponent setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    public static class SetStyleCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String selector;
        protected Map<String, String> styles;

        @Deprecated
        public SetStyleCommand() {
        }

        public SetStyleCommand(String componentId, String selector, Map<String, String> styles) {
            this.componentId = componentId;
            this.selector = selector;
            this.styles = styles;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("selector=" + this.selector) + ", " + ("styles=" + this.styles);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="selector")
        public String getSelector() {
            return this.selector;
        }

        @JsonGetter(value="styles")
        public Map<String, String> getStyles() {
            return this.styles;
        }
    }

    public static class SetVisibleCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected boolean visible;

        @Deprecated
        public SetVisibleCommand() {
        }

        public SetVisibleCommand(String componentId, boolean visible) {
            this.componentId = componentId;
            this.visible = visible;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("visible=" + this.visible);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="visible")
        public boolean getVisible() {
            return this.visible;
        }
    }
}

