/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiImageFormatting
implements UiObject {
    protected int width;
    protected int height;
    protected CornerShape cornerShape = CornerShape.ROUNDED;
    protected boolean shadow = false;
    protected float borderWidth = 0.0f;
    protected String borderColor;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_IMAGE_FORMATTING;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("width=" + this.width) + ", " + ("height=" + this.height) + ", " + ("cornerShape=" + this.cornerShape) + ", " + ("shadow=" + this.shadow) + ", " + ("borderWidth=" + this.borderWidth) + ", " + ("borderColor=" + this.borderColor);
    }

    @JsonGetter(value="width")
    public int getWidth() {
        return this.width;
    }

    @JsonGetter(value="height")
    public int getHeight() {
        return this.height;
    }

    @JsonGetter(value="cornerShape")
    public CornerShape getCornerShape() {
        return this.cornerShape;
    }

    @JsonGetter(value="shadow")
    public boolean getShadow() {
        return this.shadow;
    }

    @JsonGetter(value="borderWidth")
    public float getBorderWidth() {
        return this.borderWidth;
    }

    @JsonGetter(value="borderColor")
    public String getBorderColor() {
        return this.borderColor;
    }

    @JsonSetter(value="width")
    public UiImageFormatting setWidth(int width) {
        this.width = width;
        return this;
    }

    @JsonSetter(value="height")
    public UiImageFormatting setHeight(int height) {
        this.height = height;
        return this;
    }

    @JsonSetter(value="cornerShape")
    public UiImageFormatting setCornerShape(CornerShape cornerShape) {
        this.cornerShape = cornerShape;
        return this;
    }

    @JsonSetter(value="shadow")
    public UiImageFormatting setShadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    @JsonSetter(value="borderWidth")
    public UiImageFormatting setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    @JsonSetter(value="borderColor")
    public UiImageFormatting setBorderColor(String borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public static enum CornerShape {
        ORIGINAL,
        ROUNDED,
        CIRCLE;


        @JsonValue
        public int jsonValue() {
            return this.ordinal();
        }
    }
}

