/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiHeatMapData;
import org.teamapps.dto.UiMapArea;
import org.teamapps.dto.UiMapLocation;
import org.teamapps.dto.UiMapMarkerClientRecord;
import org.teamapps.dto.UiMapMarkerCluster;
import org.teamapps.dto.UiMapPolyline;
import org.teamapps.dto.UiMapType;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiTemplate;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiMap
extends UiComponent
implements UiObject {
    protected Map<String, UiTemplate> markerTemplates;
    protected UiMapType mapType = UiMapType.MAP_BOX_STREETS;
    protected int zoomLevel = 5;
    protected UiMapLocation mapPosition;
    protected Map<String, UiMapPolyline> polylines;
    protected List<UiMapMarkerClientRecord> markers;

    @Deprecated
    public UiMap() {
    }

    public UiMap(String id, Map<String, UiTemplate> markerTemplates) {
        super(id);
        this.markerTemplates = markerTemplates;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_MAP;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + (String)(this.markerTemplates != null ? "markerTemplates={" + this.markerTemplates.toString() + "}" : "") + ", " + ("mapType=" + this.mapType) + ", " + ("zoomLevel=" + this.zoomLevel) + ", " + (String)(this.mapPosition != null ? "mapPosition={" + this.mapPosition.toString() + "}" : "") + ", " + (String)(this.polylines != null ? "polylines={" + this.polylines.toString() + "}" : "") + ", " + (String)(this.markers != null ? "markers={" + this.markers.toString() + "}" : "");
    }

    @JsonGetter(value="markerTemplates")
    public Map<String, UiTemplate> getMarkerTemplates() {
        return this.markerTemplates;
    }

    @JsonGetter(value="mapType")
    public UiMapType getMapType() {
        return this.mapType;
    }

    @JsonGetter(value="zoomLevel")
    public int getZoomLevel() {
        return this.zoomLevel;
    }

    @JsonGetter(value="mapPosition")
    public UiMapLocation getMapPosition() {
        return this.mapPosition;
    }

    @JsonGetter(value="polylines")
    public Map<String, UiMapPolyline> getPolylines() {
        return this.polylines;
    }

    @JsonGetter(value="markers")
    public List<UiMapMarkerClientRecord> getMarkers() {
        return this.markers;
    }

    @Override
    @JsonSetter(value="visible")
    public UiMap setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiMap setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="mapType")
    public UiMap setMapType(UiMapType mapType) {
        this.mapType = mapType;
        return this;
    }

    @JsonSetter(value="zoomLevel")
    public UiMap setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
        return this;
    }

    @JsonSetter(value="mapPosition")
    public UiMap setMapPosition(UiMapLocation mapPosition) {
        this.mapPosition = mapPosition;
        return this;
    }

    @JsonSetter(value="polylines")
    public UiMap setPolylines(Map<String, UiMapPolyline> polylines) {
        this.polylines = polylines;
        return this;
    }

    @JsonSetter(value="markers")
    public UiMap setMarkers(List<UiMapMarkerClientRecord> markers) {
        this.markers = markers;
        return this;
    }

    public static class SetHeatMapCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiHeatMapData data;

        @Deprecated
        public SetHeatMapCommand() {
        }

        public SetHeatMapCommand(String componentId, UiHeatMapData data) {
            this.componentId = componentId;
            this.data = data;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.data != null ? "data={" + this.data.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="data")
        public UiHeatMapData getData() {
            return this.data;
        }
    }

    public static class SetMapTypeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiMapType mapType;

        @Deprecated
        public SetMapTypeCommand() {
        }

        public SetMapTypeCommand(String componentId, UiMapType mapType) {
            this.componentId = componentId;
            this.mapType = mapType;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("mapType=" + this.mapType);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="mapType")
        public UiMapType getMapType() {
            return this.mapType;
        }
    }

    public static class SetLocationCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiMapLocation location;

        @Deprecated
        public SetLocationCommand() {
        }

        public SetLocationCommand(String componentId, UiMapLocation location) {
            this.componentId = componentId;
            this.location = location;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.location != null ? "location={" + this.location.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="location")
        public UiMapLocation getLocation() {
            return this.location;
        }
    }

    public static class SetZoomLevelCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int zoom;

        @Deprecated
        public SetZoomLevelCommand() {
        }

        public SetZoomLevelCommand(String componentId, int zoom) {
            this.componentId = componentId;
            this.zoom = zoom;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("zoom=" + this.zoom);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="zoom")
        public int getZoom() {
            return this.zoom;
        }
    }

    public static class RemovePolylineCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String lineId;

        @Deprecated
        public RemovePolylineCommand() {
        }

        public RemovePolylineCommand(String componentId, String lineId) {
            this.componentId = componentId;
            this.lineId = lineId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("lineId=" + this.lineId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="lineId")
        public String getLineId() {
            return this.lineId;
        }
    }

    public static class AddPolylinePointsCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String lineId;
        protected List<UiMapLocation> points;

        @Deprecated
        public AddPolylinePointsCommand() {
        }

        public AddPolylinePointsCommand(String componentId, String lineId, List<UiMapLocation> points) {
            this.componentId = componentId;
            this.lineId = lineId;
            this.points = points;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("lineId=" + this.lineId) + ", " + (String)(this.points != null ? "points={" + this.points.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="lineId")
        public String getLineId() {
            return this.lineId;
        }

        @JsonGetter(value="points")
        public List<UiMapLocation> getPoints() {
            return this.points;
        }
    }

    public static class AddPolylineCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String lineId;
        protected UiMapPolyline polyline;

        @Deprecated
        public AddPolylineCommand() {
        }

        public AddPolylineCommand(String componentId, String lineId, UiMapPolyline polyline) {
            this.componentId = componentId;
            this.lineId = lineId;
            this.polyline = polyline;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("lineId=" + this.lineId) + ", " + (String)(this.polyline != null ? "polyline={" + this.polyline.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="lineId")
        public String getLineId() {
            return this.lineId;
        }

        @JsonGetter(value="polyline")
        public UiMapPolyline getPolyline() {
            return this.polyline;
        }
    }

    public static class SetMapMarkerClusterCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiMapMarkerCluster cluster;

        @Deprecated
        public SetMapMarkerClusterCommand() {
        }

        public SetMapMarkerClusterCommand(String componentId, UiMapMarkerCluster cluster) {
            this.componentId = componentId;
            this.cluster = cluster;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.cluster != null ? "cluster={" + this.cluster.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="cluster")
        public UiMapMarkerCluster getCluster() {
            return this.cluster;
        }
    }

    public static class RemoveMarkerCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int id;

        @Deprecated
        public RemoveMarkerCommand() {
        }

        public RemoveMarkerCommand(String componentId, int id) {
            this.componentId = componentId;
            this.id = id;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="id")
        public int getId() {
            return this.id;
        }
    }

    public static class AddMarkerCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiMapMarkerClientRecord marker;

        @Deprecated
        public AddMarkerCommand() {
        }

        public AddMarkerCommand(String componentId, UiMapMarkerClientRecord marker) {
            this.componentId = componentId;
            this.marker = marker;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.marker != null ? "marker={" + this.marker.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="marker")
        public UiMapMarkerClientRecord getMarker() {
            return this.marker;
        }
    }

    public static class RegisterTemplateCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String id;
        protected UiTemplate template;

        @Deprecated
        public RegisterTemplateCommand() {
        }

        public RegisterTemplateCommand(String componentId, String id, UiTemplate template) {
            this.componentId = componentId;
            this.id = id;
            this.template = template;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("componentId=" + this.componentId) + ", " + (String)(this.template != null ? "template={" + this.template.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="id")
        public String getId() {
            return this.id;
        }

        @JsonGetter(value="template")
        public UiTemplate getTemplate() {
            return this.template;
        }
    }

    public static class MarkerClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int markerId;

        @Deprecated
        public MarkerClickedEvent() {
        }

        public MarkerClickedEvent(String componentId, int markerId) {
            this.componentId = componentId;
            this.markerId = markerId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MAP_MARKER_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("markerId=" + this.markerId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="markerId")
        public int getMarkerId() {
            return this.markerId;
        }
    }

    public static class MapClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected UiMapLocation location;

        @Deprecated
        public MapClickedEvent() {
        }

        public MapClickedEvent(String componentId, UiMapLocation location) {
            this.componentId = componentId;
            this.location = location;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MAP_MAP_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.location != null ? "location={" + this.location.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="location")
        public UiMapLocation getLocation() {
            return this.location;
        }
    }

    public static class LocationChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected UiMapLocation center;
        protected UiMapArea displayedArea;

        @Deprecated
        public LocationChangedEvent() {
        }

        public LocationChangedEvent(String componentId, UiMapLocation center, UiMapArea displayedArea) {
            this.componentId = componentId;
            this.center = center;
            this.displayedArea = displayedArea;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MAP_LOCATION_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.center != null ? "center={" + this.center.toString() + "}" : "") + ", " + (String)(this.displayedArea != null ? "displayedArea={" + this.displayedArea.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="center")
        public UiMapLocation getCenter() {
            return this.center;
        }

        @JsonGetter(value="displayedArea")
        public UiMapArea getDisplayedArea() {
            return this.displayedArea;
        }
    }

    public static class ZoomLevelChangedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected int zoomLevel;

        @Deprecated
        public ZoomLevelChangedEvent() {
        }

        public ZoomLevelChangedEvent(String componentId, int zoomLevel) {
            this.componentId = componentId;
            this.zoomLevel = zoomLevel;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_MAP_ZOOM_LEVEL_CHANGED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("zoomLevel=" + this.zoomLevel);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="zoomLevel")
        public int getZoomLevel() {
            return this.zoomLevel;
        }
    }
}

