package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiComponentField extends UiField implements UiObject {


	protected UiClientObjectReference component;
	protected int width;
	protected int height;
	protected UiBorder border;
	protected UiColor backgroundColor = new UiColor(255, 255, 255);

	public UiComponentField() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_COMPONENT_FIELD;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("editingMode=" + editingMode).append(", ")
				.append("value=" + value).append(", ")
				.append("width=" + width).append(", ")
				.append("height=" + height).append(", ")
				.append(fieldMessages != null ? "fieldMessages={" + fieldMessages.toString() + "}" : "").append(", ")
				.append(component != null ? "component={" + component.toString() + "}" : "").append(", ")
				.append(border != null ? "border={" + border.toString() + "}" : "").append(", ")
				.append(backgroundColor != null ? "backgroundColor={" + backgroundColor.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("component")
	public UiClientObjectReference getComponent() {
		return component;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("width")
	public int getWidth() {
		return width;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("height")
	public int getHeight() {
		return height;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("border")
	public UiBorder getBorder() {
		return border;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
	public UiColor getBackgroundColor() {
		return backgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiComponentField setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiComponentField setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiComponentField setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiComponentField setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("editingMode")
	public UiComponentField setEditingMode(UiFieldEditingMode editingMode) {
		this.editingMode = editingMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("value")
	public UiComponentField setValue(Object value) {
		this.value = value;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("fieldMessages")
	public UiComponentField setFieldMessages(List<UiFieldMessage> fieldMessages) {
		this.fieldMessages = fieldMessages;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("component")
	public UiComponentField setComponent(UiClientObjectReference component) {
		this.component = component;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("width")
	public UiComponentField setWidth(int width) {
		this.width = width;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("height")
	public UiComponentField setHeight(int height) {
		this.height = height;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("border")
	public UiComponentField setBorder(UiBorder border) {
		this.border = border;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundColor")
	public UiComponentField setBackgroundColor(UiColor backgroundColor) {
		this.backgroundColor = backgroundColor;
		return this;
	}


	public static class SetComponentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiClientObjectReference component;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetComponentCommand() {
			// default constructor for Jackson
		}

		public SetComponentCommand(String componentId, UiClientObjectReference component) {
			this.componentId = componentId;
			this.component = component;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(component != null ? "component={" + component.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("component")
		public UiClientObjectReference getComponent() {
			return component;
		}

	}

	public static class SetSizeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int width;
		protected int height;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetSizeCommand() {
			// default constructor for Jackson
		}

		public SetSizeCommand(String componentId, int width, int height) {
			this.componentId = componentId;
			this.width = width;
			this.height = height;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("width=" + width).append(", ")
					.append("height=" + height)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("width")
		public int getWidth() {
			return width;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("height")
		public int getHeight() {
			return height;
		}

	}

	public static class SetBorderCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiBorder border;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetBorderCommand() {
			// default constructor for Jackson
		}

		public SetBorderCommand(String componentId, UiBorder border) {
			this.componentId = componentId;
			this.border = border;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(border != null ? "border={" + border.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("border")
		public UiBorder getBorder() {
			return border;
		}

	}

	public static class SetBackgroundColorCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiColor backgroundColor;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetBackgroundColorCommand() {
			// default constructor for Jackson
		}

		public SetBackgroundColorCommand(String componentId, UiColor backgroundColor) {
			this.componentId = componentId;
			this.backgroundColor = backgroundColor;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(backgroundColor != null ? "backgroundColor={" + backgroundColor.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
		public UiColor getBackgroundColor() {
			return backgroundColor;
		}

	}




}