package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiDocumentViewer extends UiComponent implements UiObject {


	protected List<String> pageUrls;
	protected UiPageDisplayMode displayMode = UiPageDisplayMode.FIT_WIDTH;
	protected float zoomFactor = 1f;
	protected UiBorder pageBorder;
	protected UiShadow pageShadow;
	protected int padding = 0;
	protected int pageSpacing = 5;

	public UiDocumentViewer() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_DOCUMENT_VIEWER;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("pageUrls=" + pageUrls).append(", ")
				.append("displayMode=" + displayMode).append(", ")
				.append("zoomFactor=" + zoomFactor).append(", ")
				.append("padding=" + padding).append(", ")
				.append("pageSpacing=" + pageSpacing).append(", ")
				.append(pageBorder != null ? "pageBorder={" + pageBorder.toString() + "}" : "").append(", ")
				.append(pageShadow != null ? "pageShadow={" + pageShadow.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("pageUrls")
	public List<String> getPageUrls() {
		return pageUrls;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("displayMode")
	public UiPageDisplayMode getDisplayMode() {
		return displayMode;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("zoomFactor")
	public float getZoomFactor() {
		return zoomFactor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("pageBorder")
	public UiBorder getPageBorder() {
		return pageBorder;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("pageShadow")
	public UiShadow getPageShadow() {
		return pageShadow;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("padding")
	public int getPadding() {
		return padding;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("pageSpacing")
	public int getPageSpacing() {
		return pageSpacing;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiDocumentViewer setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiDocumentViewer setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiDocumentViewer setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiDocumentViewer setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("pageUrls")
	public UiDocumentViewer setPageUrls(List<String> pageUrls) {
		this.pageUrls = pageUrls;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("displayMode")
	public UiDocumentViewer setDisplayMode(UiPageDisplayMode displayMode) {
		this.displayMode = displayMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("zoomFactor")
	public UiDocumentViewer setZoomFactor(float zoomFactor) {
		this.zoomFactor = zoomFactor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("pageBorder")
	public UiDocumentViewer setPageBorder(UiBorder pageBorder) {
		this.pageBorder = pageBorder;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("pageShadow")
	public UiDocumentViewer setPageShadow(UiShadow pageShadow) {
		this.pageShadow = pageShadow;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("padding")
	public UiDocumentViewer setPadding(int padding) {
		this.padding = padding;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("pageSpacing")
	public UiDocumentViewer setPageSpacing(int pageSpacing) {
		this.pageSpacing = pageSpacing;
		return this;
	}


	public static class SetPageUrlsCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected List<String> pageUrls;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetPageUrlsCommand() {
			// default constructor for Jackson
		}

		public SetPageUrlsCommand(String componentId, List<String> pageUrls) {
			this.componentId = componentId;
			this.pageUrls = pageUrls;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("pageUrls=" + pageUrls)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("pageUrls")
		public List<String> getPageUrls() {
			return pageUrls;
		}

	}

	public static class SetDisplayModeCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiPageDisplayMode displayMode;
		protected float zoomFactor;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetDisplayModeCommand() {
			// default constructor for Jackson
		}

		public SetDisplayModeCommand(String componentId, UiPageDisplayMode displayMode, float zoomFactor) {
			this.componentId = componentId;
			this.displayMode = displayMode;
			this.zoomFactor = zoomFactor;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("displayMode=" + displayMode).append(", ")
					.append("zoomFactor=" + zoomFactor)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("displayMode")
		public UiPageDisplayMode getDisplayMode() {
			return displayMode;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("zoomFactor")
		public float getZoomFactor() {
			return zoomFactor;
		}

	}

	public static class SetZoomFactorCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected float zoomFactor;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetZoomFactorCommand() {
			// default constructor for Jackson
		}

		public SetZoomFactorCommand(String componentId, float zoomFactor) {
			this.componentId = componentId;
			this.zoomFactor = zoomFactor;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("zoomFactor=" + zoomFactor)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("zoomFactor")
		public float getZoomFactor() {
			return zoomFactor;
		}

	}

	public static class SetPageBorderCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiBorder pageBorder;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetPageBorderCommand() {
			// default constructor for Jackson
		}

		public SetPageBorderCommand(String componentId, UiBorder pageBorder) {
			this.componentId = componentId;
			this.pageBorder = pageBorder;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(pageBorder != null ? "pageBorder={" + pageBorder.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("pageBorder")
		public UiBorder getPageBorder() {
			return pageBorder;
		}

	}

	public static class SetPageShadowCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiShadow pageShadow;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetPageShadowCommand() {
			// default constructor for Jackson
		}

		public SetPageShadowCommand(String componentId, UiShadow pageShadow) {
			this.componentId = componentId;
			this.pageShadow = pageShadow;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(pageShadow != null ? "pageShadow={" + pageShadow.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("pageShadow")
		public UiShadow getPageShadow() {
			return pageShadow;
		}

	}

	public static class SetPadddingCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int padding;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetPadddingCommand() {
			// default constructor for Jackson
		}

		public SetPadddingCommand(String componentId, int padding) {
			this.componentId = componentId;
			this.padding = padding;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("padding=" + padding)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("padding")
		public int getPadding() {
			return padding;
		}

	}

	public static class SetPageSpacingCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int pageSpacing;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetPageSpacingCommand() {
			// default constructor for Jackson
		}

		public SetPageSpacingCommand(String componentId, int pageSpacing) {
			this.componentId = componentId;
			this.pageSpacing = pageSpacing;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("pageSpacing=" + pageSpacing)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("pageSpacing")
		public int getPageSpacing() {
			return pageSpacing;
		}

	}




}