/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiColor;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiSpacing;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiNotification
extends UiComponent
implements UiObject {
    protected UiColor backgroundColor;
    protected UiSpacing padding;
    protected int displayTimeInMillis = 3000;
    protected boolean dismissible = true;
    protected boolean showProgressBar = false;
    protected UiClientObjectReference content;
    protected int contentHeight = 0;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_NOTIFICATION;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("displayTimeInMillis=" + this.displayTimeInMillis) + ", " + ("dismissible=" + this.dismissible) + ", " + ("showProgressBar=" + this.showProgressBar) + ", " + ("contentHeight=" + this.contentHeight) + ", " + (String)(this.backgroundColor != null ? "backgroundColor={" + this.backgroundColor.toString() + "}" : "") + ", " + (String)(this.padding != null ? "padding={" + this.padding.toString() + "}" : "") + ", " + (String)(this.content != null ? "content={" + this.content.toString() + "}" : "");
    }

    @JsonGetter(value="backgroundColor")
    public UiColor getBackgroundColor() {
        return this.backgroundColor;
    }

    @JsonGetter(value="padding")
    public UiSpacing getPadding() {
        return this.padding;
    }

    @JsonGetter(value="displayTimeInMillis")
    public int getDisplayTimeInMillis() {
        return this.displayTimeInMillis;
    }

    @JsonGetter(value="dismissible")
    public boolean getDismissible() {
        return this.dismissible;
    }

    @JsonGetter(value="showProgressBar")
    public boolean getShowProgressBar() {
        return this.showProgressBar;
    }

    @JsonGetter(value="content")
    public UiClientObjectReference getContent() {
        return this.content;
    }

    @JsonGetter(value="contentHeight")
    public int getContentHeight() {
        return this.contentHeight;
    }

    @Override
    @JsonSetter(value="id")
    public UiNotification setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiNotification setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiNotification setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiNotification setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="backgroundColor")
    public UiNotification setBackgroundColor(UiColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @JsonSetter(value="padding")
    public UiNotification setPadding(UiSpacing padding) {
        this.padding = padding;
        return this;
    }

    @JsonSetter(value="displayTimeInMillis")
    public UiNotification setDisplayTimeInMillis(int displayTimeInMillis) {
        this.displayTimeInMillis = displayTimeInMillis;
        return this;
    }

    @JsonSetter(value="dismissible")
    public UiNotification setDismissible(boolean dismissible) {
        this.dismissible = dismissible;
        return this;
    }

    @JsonSetter(value="showProgressBar")
    public UiNotification setShowProgressBar(boolean showProgressBar) {
        this.showProgressBar = showProgressBar;
        return this;
    }

    @JsonSetter(value="content")
    public UiNotification setContent(UiClientObjectReference content) {
        this.content = content;
        return this;
    }

    @JsonSetter(value="contentHeight")
    public UiNotification setContentHeight(int contentHeight) {
        this.contentHeight = contentHeight;
        return this;
    }

    public static class UpdateCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiNotification config;

        @Deprecated
        public UpdateCommand() {
        }

        public UpdateCommand(String componentId, UiNotification config) {
            this.componentId = componentId;
            this.config = config;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.config != null ? "config={" + this.config.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="config")
        public UiNotification getConfig() {
            return this.config;
        }
    }

    public static class CloseCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public CloseCommand() {
        }

        public CloseCommand(String componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }

    public static class ClosedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected boolean byUser;

        @Deprecated
        public ClosedEvent() {
        }

        public ClosedEvent(String componentId, boolean byUser) {
            this.componentId = componentId;
            this.byUser = byUser;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_NOTIFICATION_CLOSED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("byUser=" + this.byUser);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="byUser")
        public boolean getByUser() {
            return this.byUser;
        }
    }

    public static class OpenedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;

        @Deprecated
        public OpenedEvent() {
        }

        public OpenedEvent(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_NOTIFICATION_OPENED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }
    }
}

