package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiComponent implements UiObject {


	protected String id;
	protected boolean visible = true;
	protected Map<String, Map<String, String>> stylesBySelector;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiComponent() {
		// default constructor for Jackson
	}

	public UiComponent(String id) {
		this.id = id;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_COMPONENT;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector)
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("id")
	public String getId() {
		return id;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("visible")
	public boolean getVisible() {
		return visible;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("stylesBySelector")
	public Map<String, Map<String, String>> getStylesBySelector() {
		return stylesBySelector;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiComponent setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiComponent setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}


	public static class SetVisibleCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected boolean visible;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetVisibleCommand() {
			// default constructor for Jackson
		}

		public SetVisibleCommand(String componentId, boolean visible) {
			this.componentId = componentId;
			this.visible = visible;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("visible=" + visible)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("visible")
		public boolean getVisible() {
			return visible;
		}

	}

	public static class SetStyleCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String selector;
		protected Map<String, String> styles;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetStyleCommand() {
			// default constructor for Jackson
		}

		public SetStyleCommand(String componentId, String selector, Map<String, String> styles) {
			this.componentId = componentId;
			this.selector = selector;
			this.styles = styles;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("selector=" + selector).append(", ")
					.append("styles=" + styles)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("selector")
		public String getSelector() {
			return selector;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("styles")
		public Map<String, String> getStyles() {
			return styles;
		}

	}




}