package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiNotification implements UiObject {

	public enum Position {
		TOP_LEFT, TOP_CENTER, TOP_RIGHT, BOTTOM_LEFT, BOTTOM_CENTER, BOTTOM_RIGHT;

		@com.fasterxml.jackson.annotation.JsonValue
		public int jsonValue() {
			return ordinal();
		}
	}

	protected UiTemplate template;

	@JsonSerialize(using = ObjectSerializer.class)
	@JsonDeserialize(using = ObjectDeserializer.class)
	protected Object data;
	protected UiColor backgroundColor;
	protected Position position = Position.TOP_RIGHT;
	protected int displayTimeInMillis = 3000;
	protected boolean dismissable = true;
	protected boolean showProgressBar = false;
	protected UiEntranceAnimation entranceAnimation = UiEntranceAnimation.FADE_IN;
	protected UiExitAnimation exitAnimation = UiExitAnimation.FADE_OUT;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiNotification() {
		// default constructor for Jackson
	}

	public UiNotification(UiTemplate template, Object data) {
		this.template = template;
		this.data = data;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_NOTIFICATION;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append(template != null ? "template={" + template.toString() + "}" : "").append(", ")
				.append("data=" + data).append(", ")
				.append("position=" + position).append(", ")
				.append("displayTimeInMillis=" + displayTimeInMillis).append(", ")
				.append("dismissable=" + dismissable).append(", ")
				.append("showProgressBar=" + showProgressBar).append(", ")
				.append("entranceAnimation=" + entranceAnimation).append(", ")
				.append("exitAnimation=" + exitAnimation).append(", ")
				.append(backgroundColor != null ? "backgroundColor={" + backgroundColor.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("template")
	public UiTemplate getTemplate() {
		return template;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("data")
	public Object getData() {
		return data;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
	public UiColor getBackgroundColor() {
		return backgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("position")
	public Position getPosition() {
		return position;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("displayTimeInMillis")
	public int getDisplayTimeInMillis() {
		return displayTimeInMillis;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("dismissable")
	public boolean getDismissable() {
		return dismissable;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("showProgressBar")
	public boolean getShowProgressBar() {
		return showProgressBar;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("entranceAnimation")
	public UiEntranceAnimation getEntranceAnimation() {
		return entranceAnimation;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("exitAnimation")
	public UiExitAnimation getExitAnimation() {
		return exitAnimation;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundColor")
	public UiNotification setBackgroundColor(UiColor backgroundColor) {
		this.backgroundColor = backgroundColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("position")
	public UiNotification setPosition(Position position) {
		this.position = position;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("displayTimeInMillis")
	public UiNotification setDisplayTimeInMillis(int displayTimeInMillis) {
		this.displayTimeInMillis = displayTimeInMillis;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("dismissable")
	public UiNotification setDismissable(boolean dismissable) {
		this.dismissable = dismissable;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("showProgressBar")
	public UiNotification setShowProgressBar(boolean showProgressBar) {
		this.showProgressBar = showProgressBar;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("entranceAnimation")
	public UiNotification setEntranceAnimation(UiEntranceAnimation entranceAnimation) {
		this.entranceAnimation = entranceAnimation;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("exitAnimation")
	public UiNotification setExitAnimation(UiExitAnimation exitAnimation) {
		this.exitAnimation = exitAnimation;
		return this;
	}






}