/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiNetworkLink
implements UiObject {
    protected int source;
    protected int target;
    protected float width = 1.5f;
    protected int distance = 30;
    protected String color = "#333";

    @Deprecated
    public UiNetworkLink() {
    }

    public UiNetworkLink(int source, int target) {
        this.source = source;
        this.target = target;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_NETWORK_LINK;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("source=" + this.source) + ", " + ("target=" + this.target) + ", " + ("width=" + this.width) + ", " + ("distance=" + this.distance) + ", " + ("color=" + this.color);
    }

    @JsonGetter(value="source")
    public int getSource() {
        return this.source;
    }

    @JsonGetter(value="target")
    public int getTarget() {
        return this.target;
    }

    @JsonGetter(value="width")
    public float getWidth() {
        return this.width;
    }

    @JsonGetter(value="distance")
    public int getDistance() {
        return this.distance;
    }

    @JsonGetter(value="color")
    public String getColor() {
        return this.color;
    }

    @JsonSetter(value="width")
    public UiNetworkLink setWidth(float width) {
        this.width = width;
        return this;
    }

    @JsonSetter(value="distance")
    public UiNetworkLink setDistance(int distance) {
        this.distance = distance;
        return this;
    }

    @JsonSetter(value="color")
    public UiNetworkLink setColor(String color) {
        this.color = color;
        return this;
    }
}

