package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiNetworkNode implements UiObject {

	public enum ExpandState {
		NOT_EXPANDABLE, EXPANDED, COLLAPSED;

		@com.fasterxml.jackson.annotation.JsonValue
		public int jsonValue() {
			return ordinal();
		}
	}

	protected String id;
	protected int width;
	protected int height;
	protected UiColor backgroundColor = new UiColor(255, 255, 255);
	protected UiColor borderColor = new UiColor(100, 100, 100);
	protected float borderWidth = 1;
	protected float borderRadius = 0;
	protected float distanceFactor = 0.6f;
	protected UiTreeGraphNodeImage image;
	protected UiTreeGraphNodeIcon icon;
	protected UiTemplate template;
	protected UiClientRecord record;
	protected ExpandState expandState;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiNetworkNode() {
		// default constructor for Jackson
	}

	public UiNetworkNode(String id, int width, int height) {
		this.id = id;
		this.width = width;
		this.height = height;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_NETWORK_NODE;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("width=" + width).append(", ")
				.append("height=" + height).append(", ")
				.append("borderWidth=" + borderWidth).append(", ")
				.append("borderRadius=" + borderRadius).append(", ")
				.append("distanceFactor=" + distanceFactor).append(", ")
				.append(template != null ? "template={" + template.toString() + "}" : "").append(", ")
				.append("expandState=" + expandState).append(", ")
				.append(backgroundColor != null ? "backgroundColor={" + backgroundColor.toString() + "}" : "").append(", ")
				.append(borderColor != null ? "borderColor={" + borderColor.toString() + "}" : "").append(", ")
				.append(image != null ? "image={" + image.toString() + "}" : "").append(", ")
				.append(icon != null ? "icon={" + icon.toString() + "}" : "").append(", ")
				.append(record != null ? "record={" + record.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("id")
	public String getId() {
		return id;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("width")
	public int getWidth() {
		return width;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("height")
	public int getHeight() {
		return height;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
	public UiColor getBackgroundColor() {
		return backgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("borderColor")
	public UiColor getBorderColor() {
		return borderColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("borderWidth")
	public float getBorderWidth() {
		return borderWidth;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("borderRadius")
	public float getBorderRadius() {
		return borderRadius;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("distanceFactor")
	public float getDistanceFactor() {
		return distanceFactor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("image")
	public UiTreeGraphNodeImage getImage() {
		return image;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("icon")
	public UiTreeGraphNodeIcon getIcon() {
		return icon;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("template")
	public UiTemplate getTemplate() {
		return template;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("record")
	public UiClientRecord getRecord() {
		return record;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("expandState")
	public ExpandState getExpandState() {
		return expandState;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundColor")
	public UiNetworkNode setBackgroundColor(UiColor backgroundColor) {
		this.backgroundColor = backgroundColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("borderColor")
	public UiNetworkNode setBorderColor(UiColor borderColor) {
		this.borderColor = borderColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("borderWidth")
	public UiNetworkNode setBorderWidth(float borderWidth) {
		this.borderWidth = borderWidth;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("borderRadius")
	public UiNetworkNode setBorderRadius(float borderRadius) {
		this.borderRadius = borderRadius;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("distanceFactor")
	public UiNetworkNode setDistanceFactor(float distanceFactor) {
		this.distanceFactor = distanceFactor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("image")
	public UiNetworkNode setImage(UiTreeGraphNodeImage image) {
		this.image = image;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("icon")
	public UiNetworkNode setIcon(UiTreeGraphNodeIcon icon) {
		this.icon = icon;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("template")
	public UiNetworkNode setTemplate(UiTemplate template) {
		this.template = template;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("record")
	public UiNetworkNode setRecord(UiClientRecord record) {
		this.record = record;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("expandState")
	public UiNetworkNode setExpandState(ExpandState expandState) {
		this.expandState = expandState;
		return this;
	}






}