package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiTextField extends UiField implements UiTextInputHandlingField, UiObject {


	protected int maxCharacters;
	protected boolean showClearButton;
	protected String emptyText;
	protected boolean autofill = false;

	public UiTextField() {
		super();
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_TEXT_FIELD;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("debuggingId=" + debuggingId).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("editingMode=" + editingMode).append(", ")
				.append("value=" + value).append(", ")
				.append("maxCharacters=" + maxCharacters).append(", ")
				.append("showClearButton=" + showClearButton).append(", ")
				.append("emptyText=" + emptyText).append(", ")
				.append("autofill=" + autofill).append(", ")
				.append(fieldMessages != null ? "fieldMessages={" + fieldMessages.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("maxCharacters")
	public int getMaxCharacters() {
		return maxCharacters;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("showClearButton")
	public boolean getShowClearButton() {
		return showClearButton;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("emptyText")
	public String getEmptyText() {
		return emptyText;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("autofill")
	public boolean getAutofill() {
		return autofill;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("id")
	public UiTextField setId(String id) {
		this.id = id;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("debuggingId")
	public UiTextField setDebuggingId(String debuggingId) {
		this.debuggingId = debuggingId;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiTextField setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiTextField setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("editingMode")
	public UiTextField setEditingMode(UiFieldEditingMode editingMode) {
		this.editingMode = editingMode;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("value")
	public UiTextField setValue(Object value) {
		this.value = value;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("fieldMessages")
	public UiTextField setFieldMessages(List<UiFieldMessage> fieldMessages) {
		this.fieldMessages = fieldMessages;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("maxCharacters")
	public UiTextField setMaxCharacters(int maxCharacters) {
		this.maxCharacters = maxCharacters;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("showClearButton")
	public UiTextField setShowClearButton(boolean showClearButton) {
		this.showClearButton = showClearButton;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("emptyText")
	public UiTextField setEmptyText(String emptyText) {
		this.emptyText = emptyText;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("autofill")
	public UiTextField setAutofill(boolean autofill) {
		this.autofill = autofill;
		return this;
	}


	public static class SetMaxCharactersCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected int maxCharacters;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetMaxCharactersCommand() {
			// default constructor for Jackson
		}

		public SetMaxCharactersCommand(String componentId, int maxCharacters) {
			this.componentId = componentId;
			this.maxCharacters = maxCharacters;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("maxCharacters=" + maxCharacters)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("maxCharacters")
		public int getMaxCharacters() {
			return maxCharacters;
		}

	}

	public static class SetShowClearButtonCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected boolean showClearButton;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetShowClearButtonCommand() {
			// default constructor for Jackson
		}

		public SetShowClearButtonCommand(String componentId, boolean showClearButton) {
			this.componentId = componentId;
			this.showClearButton = showClearButton;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("showClearButton=" + showClearButton)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("showClearButton")
		public boolean getShowClearButton() {
			return showClearButton;
		}

	}

	public static class SetEmptyTextCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected String emptyText;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public SetEmptyTextCommand() {
			// default constructor for Jackson
		}

		public SetEmptyTextCommand(String componentId, String emptyText) {
			this.componentId = componentId;
			this.emptyText = emptyText;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append("emptyText=" + emptyText)
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("emptyText")
		public String getEmptyText() {
			return emptyText;
		}

	}




}