package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiGridTemplate implements UiTemplate, UiObject {


	protected List<UiGridColumn> columns;
	protected List<UiGridRow> rows;
	protected List<AbstractUiTemplateElement> elements;
	protected int minWidth = 0;
	protected int maxWidth = 0;
	protected int minHeight = 0;
	protected int maxHeight = 0;
	protected UiSpacing padding;
	protected int gridGap = 0;
	protected UiColor backgroundColor;
	protected UiBorder border;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiGridTemplate() {
		// default constructor for Jackson
	}

	public UiGridTemplate(List<UiGridColumn> columns, List<UiGridRow> rows, List<AbstractUiTemplateElement> elements) {
		this.columns = columns;
		this.rows = rows;
		this.elements = elements;
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_GRID_TEMPLATE;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("minWidth=" + minWidth).append(", ")
				.append("maxWidth=" + maxWidth).append(", ")
				.append("minHeight=" + minHeight).append(", ")
				.append("maxHeight=" + maxHeight).append(", ")
				.append("gridGap=" + gridGap).append(", ")
				.append(columns != null ? "columns={" + columns.toString() + "}" : "").append(", ")
				.append(rows != null ? "rows={" + rows.toString() + "}" : "").append(", ")
				.append(elements != null ? "elements={" + elements.toString() + "}" : "").append(", ")
				.append(padding != null ? "padding={" + padding.toString() + "}" : "").append(", ")
				.append(backgroundColor != null ? "backgroundColor={" + backgroundColor.toString() + "}" : "").append(", ")
				.append(border != null ? "border={" + border.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("columns")
	public List<UiGridColumn> getColumns() {
		return columns;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("rows")
	public List<UiGridRow> getRows() {
		return rows;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("elements")
	public List<AbstractUiTemplateElement> getElements() {
		return elements;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("minWidth")
	public int getMinWidth() {
		return minWidth;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("maxWidth")
	public int getMaxWidth() {
		return maxWidth;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("minHeight")
	public int getMinHeight() {
		return minHeight;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("maxHeight")
	public int getMaxHeight() {
		return maxHeight;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("padding")
	public UiSpacing getPadding() {
		return padding;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("gridGap")
	public int getGridGap() {
		return gridGap;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("backgroundColor")
	public UiColor getBackgroundColor() {
		return backgroundColor;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("border")
	public UiBorder getBorder() {
		return border;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("minWidth")
	public UiGridTemplate setMinWidth(int minWidth) {
		this.minWidth = minWidth;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("maxWidth")
	public UiGridTemplate setMaxWidth(int maxWidth) {
		this.maxWidth = maxWidth;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("minHeight")
	public UiGridTemplate setMinHeight(int minHeight) {
		this.minHeight = minHeight;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("maxHeight")
	public UiGridTemplate setMaxHeight(int maxHeight) {
		this.maxHeight = maxHeight;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("padding")
	public UiGridTemplate setPadding(UiSpacing padding) {
		this.padding = padding;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("gridGap")
	public UiGridTemplate setGridGap(int gridGap) {
		this.gridGap = gridGap;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("backgroundColor")
	public UiGridTemplate setBackgroundColor(UiColor backgroundColor) {
		this.backgroundColor = backgroundColor;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("border")
	public UiGridTemplate setBorder(UiBorder border) {
		this.border = border;
		return this;
	}






}