/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiChatMessage;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiChatDisplay
extends UiComponent
implements UiObject {
    protected List<UiChatMessage> messages;
    protected boolean includesFirstMessage;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_CHAT_DISPLAY;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("includesFirstMessage=" + this.includesFirstMessage) + ", " + (String)(this.messages != null ? "messages={" + this.messages.toString() + "}" : "");
    }

    @JsonGetter(value="messages")
    public List<UiChatMessage> getMessages() {
        return this.messages;
    }

    @JsonGetter(value="includesFirstMessage")
    public boolean getIncludesFirstMessage() {
        return this.includesFirstMessage;
    }

    @Override
    @JsonSetter(value="id")
    public UiChatDisplay setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiChatDisplay setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiChatDisplay setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiChatDisplay setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="messages")
    public UiChatDisplay setMessages(List<UiChatMessage> messages) {
        this.messages = messages;
        return this;
    }

    @JsonSetter(value="includesFirstMessage")
    public UiChatDisplay setIncludesFirstMessage(boolean includesFirstMessage) {
        this.includesFirstMessage = includesFirstMessage;
        return this;
    }

    public static class ReplaceChatMessagesCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<UiChatMessage> chatMessages;
        protected boolean includesFirstMessage;

        @Deprecated
        public ReplaceChatMessagesCommand() {
        }

        public ReplaceChatMessagesCommand(String componentId, List<UiChatMessage> chatMessages, boolean includesFirstMessage) {
            this.componentId = componentId;
            this.chatMessages = chatMessages;
            this.includesFirstMessage = includesFirstMessage;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("includesFirstMessage=" + this.includesFirstMessage) + ", " + (String)(this.chatMessages != null ? "chatMessages={" + this.chatMessages.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="chatMessages")
        public List<UiChatMessage> getChatMessages() {
            return this.chatMessages;
        }

        @JsonGetter(value="includesFirstMessage")
        public boolean getIncludesFirstMessage() {
            return this.includesFirstMessage;
        }
    }

    public static class AddChatMessagesCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected List<UiChatMessage> chatMessages;
        protected boolean prepend;
        protected boolean includesFirstMessage;

        @Deprecated
        public AddChatMessagesCommand() {
        }

        public AddChatMessagesCommand(String componentId, List<UiChatMessage> chatMessages, boolean prepend, boolean includesFirstMessage) {
            this.componentId = componentId;
            this.chatMessages = chatMessages;
            this.prepend = prepend;
            this.includesFirstMessage = includesFirstMessage;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("prepend=" + this.prepend) + ", " + ("includesFirstMessage=" + this.includesFirstMessage) + ", " + (String)(this.chatMessages != null ? "chatMessages={" + this.chatMessages.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="chatMessages")
        public List<UiChatMessage> getChatMessages() {
            return this.chatMessages;
        }

        @JsonGetter(value="prepend")
        public boolean getPrepend() {
            return this.prepend;
        }

        @JsonGetter(value="includesFirstMessage")
        public boolean getIncludesFirstMessage() {
            return this.includesFirstMessage;
        }
    }

    public static class PreviousMessagesRequestedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String earliestKnownMessageId;

        @Deprecated
        public PreviousMessagesRequestedEvent() {
        }

        public PreviousMessagesRequestedEvent(String componentId, String earliestKnownMessageId) {
            this.componentId = componentId;
            this.earliestKnownMessageId = earliestKnownMessageId;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_CHAT_DISPLAY_PREVIOUS_MESSAGES_REQUESTED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("earliestKnownMessageId=" + this.earliestKnownMessageId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="earliestKnownMessageId")
        public String getEarliestKnownMessageId() {
            return this.earliestKnownMessageId;
        }
    }
}

