/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiBorder;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiFieldEditingMode;
import org.teamapps.dto.UiFieldMessage;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiComponentField
extends UiField
implements UiObject {
    protected UiClientObjectReference component;
    protected int width;
    protected int height;
    protected UiBorder border;
    protected String backgroundColor = "rgb(255, 255, 255)";

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_COMPONENT_FIELD;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + ("editingMode=" + this.editingMode) + ", " + ("value=" + this.value) + ", " + ("width=" + this.width) + ", " + ("height=" + this.height) + ", " + ("backgroundColor=" + this.backgroundColor) + ", " + (String)(this.fieldMessages != null ? "fieldMessages={" + this.fieldMessages.toString() + "}" : "") + ", " + (String)(this.component != null ? "component={" + this.component.toString() + "}" : "") + ", " + (String)(this.border != null ? "border={" + this.border.toString() + "}" : "");
    }

    @JsonGetter(value="component")
    public UiClientObjectReference getComponent() {
        return this.component;
    }

    @JsonGetter(value="width")
    public int getWidth() {
        return this.width;
    }

    @JsonGetter(value="height")
    public int getHeight() {
        return this.height;
    }

    @JsonGetter(value="border")
    public UiBorder getBorder() {
        return this.border;
    }

    @JsonGetter(value="backgroundColor")
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    @JsonSetter(value="id")
    public UiComponentField setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiComponentField setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiComponentField setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiComponentField setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @Override
    @JsonSetter(value="editingMode")
    public UiComponentField setEditingMode(UiFieldEditingMode editingMode) {
        this.editingMode = editingMode;
        return this;
    }

    @Override
    @JsonSetter(value="value")
    public UiComponentField setValue(Object value) {
        this.value = value;
        return this;
    }

    @Override
    @JsonSetter(value="fieldMessages")
    public UiComponentField setFieldMessages(List<UiFieldMessage> fieldMessages) {
        this.fieldMessages = fieldMessages;
        return this;
    }

    @JsonSetter(value="component")
    public UiComponentField setComponent(UiClientObjectReference component) {
        this.component = component;
        return this;
    }

    @JsonSetter(value="width")
    public UiComponentField setWidth(int width) {
        this.width = width;
        return this;
    }

    @JsonSetter(value="height")
    public UiComponentField setHeight(int height) {
        this.height = height;
        return this;
    }

    @JsonSetter(value="border")
    public UiComponentField setBorder(UiBorder border) {
        this.border = border;
        return this;
    }

    @JsonSetter(value="backgroundColor")
    public UiComponentField setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public static class SetBackgroundColorCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String backgroundColor;

        @Deprecated
        public SetBackgroundColorCommand() {
        }

        public SetBackgroundColorCommand(String componentId, String backgroundColor) {
            this.componentId = componentId;
            this.backgroundColor = backgroundColor;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("backgroundColor=" + this.backgroundColor);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="backgroundColor")
        public String getBackgroundColor() {
            return this.backgroundColor;
        }
    }

    public static class SetBorderCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiBorder border;

        @Deprecated
        public SetBorderCommand() {
        }

        public SetBorderCommand(String componentId, UiBorder border) {
            this.componentId = componentId;
            this.border = border;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.border != null ? "border={" + this.border.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="border")
        public UiBorder getBorder() {
            return this.border;
        }
    }

    public static class SetSizeCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected int width;
        protected int height;

        @Deprecated
        public SetSizeCommand() {
        }

        public SetSizeCommand(String componentId, int width, int height) {
            this.componentId = componentId;
            this.width = width;
            this.height = height;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("width=" + this.width) + ", " + ("height=" + this.height);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="width")
        public int getWidth() {
            return this.width;
        }

        @JsonGetter(value="height")
        public int getHeight() {
            return this.height;
        }
    }

    public static class SetComponentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiClientObjectReference component;

        @Deprecated
        public SetComponentCommand() {
        }

        public SetComponentCommand(String componentId, UiClientObjectReference component) {
            this.componentId = componentId;
            this.component = component;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + (String)(this.component != null ? "component={" + this.component.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="component")
        public UiClientObjectReference getComponent() {
            return this.component;
        }
    }
}

