/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiNetworkLink
implements UiObject {
    protected String source;
    protected String target;
    protected String lineColor = "rgb(127, 127, 127)";
    protected float lineWidth = 1.5f;
    protected String lineDashArray;

    @Deprecated
    public UiNetworkLink() {
    }

    public UiNetworkLink(String source, String target) {
        this.source = source;
        this.target = target;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_NETWORK_LINK;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("source=" + this.source) + ", " + ("target=" + this.target) + ", " + ("lineColor=" + this.lineColor) + ", " + ("lineWidth=" + this.lineWidth) + ", " + ("lineDashArray=" + this.lineDashArray);
    }

    @JsonGetter(value="source")
    public String getSource() {
        return this.source;
    }

    @JsonGetter(value="target")
    public String getTarget() {
        return this.target;
    }

    @JsonGetter(value="lineColor")
    public String getLineColor() {
        return this.lineColor;
    }

    @JsonGetter(value="lineWidth")
    public float getLineWidth() {
        return this.lineWidth;
    }

    @JsonGetter(value="lineDashArray")
    public String getLineDashArray() {
        return this.lineDashArray;
    }

    @JsonSetter(value="lineColor")
    public UiNetworkLink setLineColor(String lineColor) {
        this.lineColor = lineColor;
        return this;
    }

    @JsonSetter(value="lineWidth")
    public UiNetworkLink setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }

    @JsonSetter(value="lineDashArray")
    public UiNetworkLink setLineDashArray(String lineDashArray) {
        this.lineDashArray = lineDashArray;
        return this;
    }
}

