/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiEntranceAnimation;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiEventType;
import org.teamapps.dto.UiExitAnimation;
import org.teamapps.dto.UiNotificationBarItem;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiNotificationBar
extends UiComponent
implements UiObject {
    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_NOTIFICATION_BAR;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector);
    }

    @Override
    @JsonSetter(value="id")
    public UiNotificationBar setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiNotificationBar setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiNotificationBar setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiNotificationBar setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    public static class RemoveItemCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected String id;
        protected UiExitAnimation exitAnimation;

        @Deprecated
        public RemoveItemCommand() {
        }

        public RemoveItemCommand(String componentId, String id, UiExitAnimation exitAnimation) {
            this.componentId = componentId;
            this.id = id;
            this.exitAnimation = exitAnimation;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("componentId=" + this.componentId) + ", " + ("exitAnimation=" + this.exitAnimation);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="id")
        public String getId() {
            return this.id;
        }

        @JsonGetter(value="exitAnimation")
        public UiExitAnimation getExitAnimation() {
            return this.exitAnimation;
        }
    }

    public static class AddItemCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiNotificationBarItem item;
        protected UiEntranceAnimation entranceAnimation;
        protected UiExitAnimation exitAnimation;

        @Deprecated
        public AddItemCommand() {
        }

        public AddItemCommand(String componentId, UiNotificationBarItem item, UiEntranceAnimation entranceAnimation, UiExitAnimation exitAnimation) {
            this.componentId = componentId;
            this.item = item;
            this.entranceAnimation = entranceAnimation;
            this.exitAnimation = exitAnimation;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("entranceAnimation=" + this.entranceAnimation) + ", " + ("exitAnimation=" + this.exitAnimation) + ", " + (String)(this.item != null ? "item={" + this.item.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="item")
        public UiNotificationBarItem getItem() {
            return this.item;
        }

        @JsonGetter(value="entranceAnimation")
        public UiEntranceAnimation getEntranceAnimation() {
            return this.entranceAnimation;
        }

        @JsonGetter(value="exitAnimation")
        public UiExitAnimation getExitAnimation() {
            return this.exitAnimation;
        }
    }

    public static class ItemClosedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String id;
        protected boolean wasTimeout;

        @Deprecated
        public ItemClosedEvent() {
        }

        public ItemClosedEvent(String componentId, String id, boolean wasTimeout) {
            this.componentId = componentId;
            this.id = id;
            this.wasTimeout = wasTimeout;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_NOTIFICATION_BAR_ITEM_CLOSED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("componentId=" + this.componentId) + ", " + ("wasTimeout=" + this.wasTimeout);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="id")
        public String getId() {
            return this.id;
        }

        @JsonGetter(value="wasTimeout")
        public boolean getWasTimeout() {
            return this.wasTimeout;
        }
    }

    public static class ItemClickedEvent
    implements UiEvent {
        @UiComponentId
        protected String componentId;
        protected String id;

        @Deprecated
        public ItemClickedEvent() {
        }

        public ItemClickedEvent(String componentId, String id) {
            this.componentId = componentId;
            this.id = id;
        }

        @Override
        public UiEventType getUiEventType() {
            return UiEventType.UI_NOTIFICATION_BAR_ITEM_CLICKED;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("componentId=" + this.componentId);
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="id")
        public String getId() {
            return this.id;
        }
    }
}

