/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.List;
import java.util.Map;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiClientObjectReference;
import org.teamapps.dto.UiCommand;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiComponentId;
import org.teamapps.dto.UiConfiguration;
import org.teamapps.dto.UiEntranceAnimation;
import org.teamapps.dto.UiExitAnimation;
import org.teamapps.dto.UiGenericErrorMessageOption;
import org.teamapps.dto.UiNotificationPosition;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiPageTransition;
import org.teamapps.dto.UiTemplate;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiRootPanel
extends UiComponent
implements UiObject {
    protected UiClientObjectReference content;

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_ROOT_PANEL;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("debuggingId=" + this.debuggingId) + ", " + ("visible=" + this.visible) + ", " + ("stylesBySelector=" + this.stylesBySelector) + ", " + (String)(this.content != null ? "content={" + this.content.toString() + "}" : "");
    }

    @JsonGetter(value="content")
    public UiClientObjectReference getContent() {
        return this.content;
    }

    @Override
    @JsonSetter(value="id")
    public UiRootPanel setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    @JsonSetter(value="debuggingId")
    public UiRootPanel setDebuggingId(String debuggingId) {
        this.debuggingId = debuggingId;
        return this;
    }

    @Override
    @JsonSetter(value="visible")
    public UiRootPanel setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Override
    @JsonSetter(value="stylesBySelector")
    public UiRootPanel setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
        this.stylesBySelector = stylesBySelector;
        return this;
    }

    @JsonSetter(value="content")
    public UiRootPanel setContent(UiClientObjectReference content) {
        this.content = content;
        return this;
    }

    public static class ShowPopupAtCurrentMousePositionCommand
    implements UiCommand<Void> {
        protected UiClientObjectReference popup;

        @Deprecated
        public ShowPopupAtCurrentMousePositionCommand() {
        }

        public ShowPopupAtCurrentMousePositionCommand(UiClientObjectReference popup) {
            this.popup = popup;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + (String)(this.popup != null ? "popup={" + this.popup.toString() + "}" : "");
        }

        @JsonGetter(value="popup")
        public UiClientObjectReference getPopup() {
            return this.popup;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class ShowPopupCommand
    implements UiCommand<Void> {
        protected UiClientObjectReference popup;

        @Deprecated
        public ShowPopupCommand() {
        }

        public ShowPopupCommand(UiClientObjectReference popup) {
            this.popup = popup;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + (String)(this.popup != null ? "popup={" + this.popup.toString() + "}" : "");
        }

        @JsonGetter(value="popup")
        public UiClientObjectReference getPopup() {
            return this.popup;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class ShowDialogMessageCommand
    implements UiCommand<Void> {
        protected String icon;
        protected String title;
        protected String message;
        protected List<UiGenericErrorMessageOption> options;

        @Deprecated
        public ShowDialogMessageCommand() {
        }

        public ShowDialogMessageCommand(String icon, String title, String message, List<UiGenericErrorMessageOption> options) {
            this.icon = icon;
            this.title = title;
            this.message = message;
            this.options = options;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("icon=" + this.icon) + ", " + ("title=" + this.title) + ", " + ("message=" + this.message) + ", " + ("options=" + this.options);
        }

        @JsonGetter(value="icon")
        public String getIcon() {
            return this.icon;
        }

        @JsonGetter(value="title")
        public String getTitle() {
            return this.title;
        }

        @JsonGetter(value="message")
        public String getMessage() {
            return this.message;
        }

        @JsonGetter(value="options")
        public List<UiGenericErrorMessageOption> getOptions() {
            return this.options;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class ShowNotificationCommand
    implements UiCommand<Void> {
        protected UiClientObjectReference notification;
        protected UiNotificationPosition position;
        protected UiEntranceAnimation entranceAnimation;
        protected UiExitAnimation exitAnimation;

        @Deprecated
        public ShowNotificationCommand() {
        }

        public ShowNotificationCommand(UiClientObjectReference notification, UiNotificationPosition position, UiEntranceAnimation entranceAnimation, UiExitAnimation exitAnimation) {
            this.notification = notification;
            this.position = position;
            this.entranceAnimation = entranceAnimation;
            this.exitAnimation = exitAnimation;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("position=" + this.position) + ", " + ("entranceAnimation=" + this.entranceAnimation) + ", " + ("exitAnimation=" + this.exitAnimation) + ", " + (String)(this.notification != null ? "notification={" + this.notification.toString() + "}" : "");
        }

        @JsonGetter(value="notification")
        public UiClientObjectReference getNotification() {
            return this.notification;
        }

        @JsonGetter(value="position")
        public UiNotificationPosition getPosition() {
            return this.position;
        }

        @JsonGetter(value="entranceAnimation")
        public UiEntranceAnimation getEntranceAnimation() {
            return this.entranceAnimation;
        }

        @JsonGetter(value="exitAnimation")
        public UiExitAnimation getExitAnimation() {
            return this.exitAnimation;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class ExitFullScreenCommand
    implements UiCommand<Void> {
        public String toString() {
            return this.getClass().getSimpleName() + ": ";
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class SetBackgroundColorCommand
    implements UiCommand<Void> {
        protected String color;
        protected int animationDuration = 1000;

        @Deprecated
        public SetBackgroundColorCommand() {
        }

        public SetBackgroundColorCommand(String color, int animationDuration) {
            this.color = color;
            this.animationDuration = animationDuration;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("color=" + this.color) + ", " + ("animationDuration=" + this.animationDuration);
        }

        @JsonGetter(value="color")
        public String getColor() {
            return this.color;
        }

        @JsonGetter(value="animationDuration")
        public int getAnimationDuration() {
            return this.animationDuration;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class SetBackgroundImageCommand
    implements UiCommand<Void> {
        protected String id;
        protected int animationDuration = 1000;

        @Deprecated
        public SetBackgroundImageCommand() {
        }

        public SetBackgroundImageCommand(String id, int animationDuration) {
            this.id = id;
            this.animationDuration = animationDuration;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("animationDuration=" + this.animationDuration);
        }

        @JsonGetter(value="id")
        public String getId() {
            return this.id;
        }

        @JsonGetter(value="animationDuration")
        public int getAnimationDuration() {
            return this.animationDuration;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class RegisterBackgroundImageCommand
    implements UiCommand<Void> {
        protected String id;
        protected String image;
        protected String blurredImage;

        @Deprecated
        public RegisterBackgroundImageCommand() {
        }

        public RegisterBackgroundImageCommand(String id, String image, String blurredImage) {
            this.id = id;
            this.image = image;
            this.blurredImage = blurredImage;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + ("image=" + this.image) + ", " + ("blurredImage=" + this.blurredImage);
        }

        @JsonGetter(value="id")
        public String getId() {
            return this.id;
        }

        @JsonGetter(value="image")
        public String getImage() {
            return this.image;
        }

        @JsonGetter(value="blurredImage")
        public String getBlurredImage() {
            return this.blurredImage;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class DownloadFileCommand
    implements UiCommand<Void> {
        protected String fileUrl;
        protected String downloadFileName;

        @Deprecated
        public DownloadFileCommand() {
        }

        public DownloadFileCommand(String fileUrl, String downloadFileName) {
            this.fileUrl = fileUrl;
            this.downloadFileName = downloadFileName;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("downloadFileName=" + this.downloadFileName) + ", " + ("fileUrl=" + this.fileUrl);
        }

        @JsonGetter(value="fileUrl")
        public String getFileUrl() {
            return this.fileUrl;
        }

        @JsonGetter(value="downloadFileName")
        public String getDownloadFileName() {
            return this.downloadFileName;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class ClearClientTokensCommand
    implements UiCommand<Void> {
        public String toString() {
            return this.getClass().getSimpleName() + ": ";
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class RemoveClientTokenCommand
    implements UiCommand<Void> {
        protected String token;

        @Deprecated
        public RemoveClientTokenCommand() {
        }

        public RemoveClientTokenCommand(String token) {
            this.token = token;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("token=" + this.token);
        }

        @JsonGetter(value="token")
        public String getToken() {
            return this.token;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class AddClientTokenCommand
    implements UiCommand<Void> {
        protected String token;

        @Deprecated
        public AddClientTokenCommand() {
        }

        public AddClientTokenCommand(String token) {
            this.token = token;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("token=" + this.token);
        }

        @JsonGetter(value="token")
        public String getToken() {
            return this.token;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class RegisterTemplatesCommand
    implements UiCommand<Void> {
        protected Map<String, UiTemplate> templates;

        @Deprecated
        public RegisterTemplatesCommand() {
        }

        public RegisterTemplatesCommand(Map<String, UiTemplate> templates) {
            this.templates = templates;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + (String)(this.templates != null ? "templates={" + this.templates.toString() + "}" : "");
        }

        @JsonGetter(value="templates")
        public Map<String, UiTemplate> getTemplates() {
            return this.templates;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class RegisterTemplateCommand
    implements UiCommand<Void> {
        protected String id;
        protected UiTemplate template;

        @Deprecated
        public RegisterTemplateCommand() {
        }

        public RegisterTemplateCommand(String id, UiTemplate template) {
            this.id = id;
            this.template = template;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("id=" + this.id) + ", " + (String)(this.template != null ? "template={" + this.template.toString() + "}" : "");
        }

        @JsonGetter(value="id")
        public String getId() {
            return this.id;
        }

        @JsonGetter(value="template")
        public UiTemplate getTemplate() {
            return this.template;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class BuildRootPanelCommand
    implements UiCommand<Void> {
        protected String containerElementId;
        protected UiClientObjectReference uiRootPanel;

        @Deprecated
        public BuildRootPanelCommand() {
        }

        public BuildRootPanelCommand(String containerElementId, UiClientObjectReference uiRootPanel) {
            this.containerElementId = containerElementId;
            this.uiRootPanel = uiRootPanel;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("containerElementId=" + this.containerElementId) + ", " + (String)(this.uiRootPanel != null ? "uiRootPanel={" + this.uiRootPanel.toString() + "}" : "");
        }

        @JsonGetter(value="containerElementId")
        public String getContainerElementId() {
            return this.containerElementId;
        }

        @JsonGetter(value="uiRootPanel")
        public UiClientObjectReference getUiRootPanel() {
            return this.uiRootPanel;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class SetPageTitleCommand
    implements UiCommand<Void> {
        protected String pageTitle;

        @Deprecated
        public SetPageTitleCommand() {
        }

        public SetPageTitleCommand(String pageTitle) {
            this.pageTitle = pageTitle;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("pageTitle=" + this.pageTitle);
        }

        @JsonGetter(value="pageTitle")
        public String getPageTitle() {
            return this.pageTitle;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class SetThemeClassNameCommand
    implements UiCommand<Void> {
        protected String theme;

        @Deprecated
        public SetThemeClassNameCommand() {
        }

        public SetThemeClassNameCommand(String theme) {
            this.theme = theme;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("theme=" + this.theme);
        }

        @JsonGetter(value="theme")
        public String getTheme() {
            return this.theme;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class SetConfigCommand
    implements UiCommand<Void> {
        protected UiConfiguration config;

        @Deprecated
        public SetConfigCommand() {
        }

        public SetConfigCommand(UiConfiguration config) {
            this.config = config;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + (String)(this.config != null ? "config={" + this.config.toString() + "}" : "");
        }

        @JsonGetter(value="config")
        public UiConfiguration getConfig() {
            return this.config;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class RefreshComponentCommand
    implements UiCommand<Void> {
        protected UiComponent component;

        @Deprecated
        public RefreshComponentCommand() {
        }

        public RefreshComponentCommand(UiComponent component) {
            this.component = component;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + (String)(this.component != null ? "component={" + this.component.toString() + "}" : "");
        }

        @JsonGetter(value="component")
        public UiComponent getComponent() {
            return this.component;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class DestroyComponentCommand
    implements UiCommand<Void> {
        protected String id;

        @Deprecated
        public DestroyComponentCommand() {
        }

        public DestroyComponentCommand(String id) {
            this.id = id;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("id=" + this.id);
        }

        @JsonGetter(value="id")
        public String getId() {
            return this.id;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class CreateComponentCommand
    implements UiCommand<Void> {
        protected UiComponent component;

        @Deprecated
        public CreateComponentCommand() {
        }

        public CreateComponentCommand(UiComponent component) {
            this.component = component;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + (String)(this.component != null ? "component={" + this.component.toString() + "}" : "");
        }

        @JsonGetter(value="component")
        public UiComponent getComponent() {
            return this.component;
        }

        @Override
        public String getComponentId() {
            return null;
        }
    }

    public static class SetContentCommand
    implements UiCommand<Void> {
        @UiComponentId
        protected String componentId;
        protected UiClientObjectReference content;
        protected UiPageTransition transition;
        protected long animationDuration;

        @Deprecated
        public SetContentCommand() {
        }

        public SetContentCommand(String componentId, UiClientObjectReference content, UiPageTransition transition, long animationDuration) {
            this.componentId = componentId;
            this.content = content;
            this.transition = transition;
            this.animationDuration = animationDuration;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + ("componentId=" + this.componentId) + ", " + ("transition=" + this.transition) + ", " + ("animationDuration=" + this.animationDuration) + ", " + (String)(this.content != null ? "content={" + this.content.toString() + "}" : "");
        }

        @Override
        @JsonGetter(value="componentId")
        public String getComponentId() {
            return this.componentId;
        }

        @JsonGetter(value="content")
        public UiClientObjectReference getContent() {
            return this.content;
        }

        @JsonGetter(value="transition")
        public UiPageTransition getTransition() {
            return this.transition;
        }

        @JsonGetter(value="animationDuration")
        public long getAnimationDuration() {
            return this.animationDuration;
        }
    }
}

