package org.teamapps.dto;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;

/**
 * THIS IS GENERATED CODE!
 * PLEASE DO NOT MODIFY - ALL YOUR WORK WOULD BE LOST!
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CUSTOM, property = "_type")
@JsonTypeIdResolver(TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class UiVerticalLayout extends UiComponent implements UiObject {


	protected List<UiComponentReference> components;
	protected Integer fixedChildHeight = null;

	/**
	 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
	 */
	@Deprecated
	public UiVerticalLayout() {
		// default constructor for Jackson
	}

	public UiVerticalLayout(String id) {
		super(id);
	}

	@com.fasterxml.jackson.annotation.JsonIgnore
	public UiObjectType getUiObjectType() {
		return UiObjectType.UI_VERTICAL_LAYOUT;
	}

	@SuppressWarnings("unchecked")
	public String toString() {
		return new StringBuilder(getClass().getSimpleName()).append(": ")
				.append("id=" + id).append(", ")
				.append("visible=" + visible).append(", ")
				.append("stylesBySelector=" + stylesBySelector).append(", ")
				.append("fixedChildHeight=" + fixedChildHeight).append(", ")
				.append(components != null ? "components={" + components.toString() + "}" : "")
				.toString();
	}

	@com.fasterxml.jackson.annotation.JsonGetter("components")
	public List<UiComponentReference> getComponents() {
		return components;
	}

	@com.fasterxml.jackson.annotation.JsonGetter("fixedChildHeight")
	public Integer getFixedChildHeight() {
		return fixedChildHeight;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("visible")
	public UiVerticalLayout setVisible(boolean visible) {
		this.visible = visible;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("stylesBySelector")
	public UiVerticalLayout setStylesBySelector(Map<String, Map<String, String>> stylesBySelector) {
		this.stylesBySelector = stylesBySelector;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("components")
	public UiVerticalLayout setComponents(List<UiComponentReference> components) {
		this.components = components;
		return this;
	}

	@com.fasterxml.jackson.annotation.JsonSetter("fixedChildHeight")
	public UiVerticalLayout setFixedChildHeight(Integer fixedChildHeight) {
		this.fixedChildHeight = fixedChildHeight;
		return this;
	}


	public static class AddComponentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiComponentReference component;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public AddComponentCommand() {
			// default constructor for Jackson
		}

		public AddComponentCommand(String componentId, UiComponentReference component) {
			this.componentId = componentId;
			this.component = component;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(component != null ? "component={" + component.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("component")
		public UiComponentReference getComponent() {
			return component;
		}

	}

	public static class RemoveComponentCommand implements UiCommand<Void> {

		@UiComponentId protected String componentId;
		protected UiComponentReference component;

		/**
		 * @deprecated Only for Jackson deserialization. Use the other constructor instead.
		 */
		@Deprecated
		public RemoveComponentCommand() {
			// default constructor for Jackson
		}

		public RemoveComponentCommand(String componentId, UiComponentReference component) {
			this.componentId = componentId;
			this.component = component;
		}

		@SuppressWarnings("unchecked")
		public String toString() {
			return new StringBuilder(getClass().getSimpleName()).append(": ")
					.append("componentId=" + componentId).append(", ")
					.append(component != null ? "component={" + component.toString() + "}" : "")
					.toString();
		}

		@com.fasterxml.jackson.annotation.JsonGetter("componentId")
		public String getComponentId() {
			return componentId;
		}

		@com.fasterxml.jackson.annotation.JsonGetter("component")
		public UiComponentReference getComponent() {
			return component;
		}

	}




}