/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiNetworkNode
implements UiObject {
    protected String nodeId;
    protected String caption;
    protected String imageId;
    protected int size;
    protected int charge = -300;
    protected float border;
    protected String borderColor;

    @Deprecated
    public UiNetworkNode() {
    }

    public UiNetworkNode(String nodeId, String caption, String imageId, int size) {
        this.nodeId = nodeId;
        this.caption = caption;
        this.imageId = imageId;
        this.size = size;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_NETWORK_NODE;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + ("nodeId=" + this.nodeId) + ", " + ("imageId=" + this.imageId) + ", " + ("caption=" + this.caption) + ", " + ("size=" + this.size) + ", " + ("charge=" + this.charge) + ", " + ("border=" + this.border) + ", " + ("borderColor=" + this.borderColor);
    }

    @JsonGetter(value="nodeId")
    public String getNodeId() {
        return this.nodeId;
    }

    @JsonGetter(value="caption")
    public String getCaption() {
        return this.caption;
    }

    @JsonGetter(value="imageId")
    public String getImageId() {
        return this.imageId;
    }

    @JsonGetter(value="size")
    public int getSize() {
        return this.size;
    }

    @JsonGetter(value="charge")
    public int getCharge() {
        return this.charge;
    }

    @JsonGetter(value="border")
    public float getBorder() {
        return this.border;
    }

    @JsonGetter(value="borderColor")
    public String getBorderColor() {
        return this.borderColor;
    }

    @JsonSetter(value="charge")
    public UiNetworkNode setCharge(int charge) {
        this.charge = charge;
        return this;
    }

    @JsonSetter(value="border")
    public UiNetworkNode setBorder(float border) {
        this.border = border;
        return this;
    }

    @JsonSetter(value="borderColor")
    public UiNetworkNode setBorderColor(String borderColor) {
        this.borderColor = borderColor;
        return this;
    }
}

