/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.dto;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import org.teamapps.dto.ObjectDeserializer;
import org.teamapps.dto.ObjectSerializer;
import org.teamapps.dto.TeamAppsJacksonTypeIdResolver;
import org.teamapps.dto.UiColor;
import org.teamapps.dto.UiEntranceAnimation;
import org.teamapps.dto.UiExitAnimation;
import org.teamapps.dto.UiObject;
import org.teamapps.dto.UiObjectType;
import org.teamapps.dto.UiTemplate;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_type")
@JsonTypeIdResolver(value=TeamAppsJacksonTypeIdResolver.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UiNotification
implements UiObject {
    protected UiTemplate template;
    @JsonSerialize(using=ObjectSerializer.class)
    @JsonDeserialize(using=ObjectDeserializer.class)
    protected Object data;
    protected UiColor backgroundColor;
    protected Position position = Position.TOP_RIGHT;
    protected int displayTimeInMillis = 3000;
    protected boolean dismissable = true;
    protected boolean showProgressBar = false;
    protected UiEntranceAnimation entranceAnimation = UiEntranceAnimation.FADE_IN;
    protected UiExitAnimation exitAnimation = UiExitAnimation.FADE_OUT;

    @Deprecated
    public UiNotification() {
    }

    public UiNotification(UiTemplate template, Object data) {
        this.template = template;
        this.data = data;
    }

    @Override
    @JsonIgnore
    public UiObjectType getUiObjectType() {
        return UiObjectType.UI_NOTIFICATION;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + (String)(this.template != null ? "template={" + this.template.toString() + "}" : "") + ", " + ("data=" + this.data) + ", " + ("position=" + this.position) + ", " + ("displayTimeInMillis=" + this.displayTimeInMillis) + ", " + ("dismissable=" + this.dismissable) + ", " + ("showProgressBar=" + this.showProgressBar) + ", " + ("entranceAnimation=" + this.entranceAnimation) + ", " + ("exitAnimation=" + this.exitAnimation) + ", " + (String)(this.backgroundColor != null ? "backgroundColor={" + this.backgroundColor.toString() + "}" : "");
    }

    @JsonGetter(value="template")
    public UiTemplate getTemplate() {
        return this.template;
    }

    @JsonGetter(value="data")
    public Object getData() {
        return this.data;
    }

    @JsonGetter(value="backgroundColor")
    public UiColor getBackgroundColor() {
        return this.backgroundColor;
    }

    @JsonGetter(value="position")
    public Position getPosition() {
        return this.position;
    }

    @JsonGetter(value="displayTimeInMillis")
    public int getDisplayTimeInMillis() {
        return this.displayTimeInMillis;
    }

    @JsonGetter(value="dismissable")
    public boolean getDismissable() {
        return this.dismissable;
    }

    @JsonGetter(value="showProgressBar")
    public boolean getShowProgressBar() {
        return this.showProgressBar;
    }

    @JsonGetter(value="entranceAnimation")
    public UiEntranceAnimation getEntranceAnimation() {
        return this.entranceAnimation;
    }

    @JsonGetter(value="exitAnimation")
    public UiExitAnimation getExitAnimation() {
        return this.exitAnimation;
    }

    @JsonSetter(value="backgroundColor")
    public UiNotification setBackgroundColor(UiColor backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    @JsonSetter(value="position")
    public UiNotification setPosition(Position position) {
        this.position = position;
        return this;
    }

    @JsonSetter(value="displayTimeInMillis")
    public UiNotification setDisplayTimeInMillis(int displayTimeInMillis) {
        this.displayTimeInMillis = displayTimeInMillis;
        return this;
    }

    @JsonSetter(value="dismissable")
    public UiNotification setDismissable(boolean dismissable) {
        this.dismissable = dismissable;
        return this;
    }

    @JsonSetter(value="showProgressBar")
    public UiNotification setShowProgressBar(boolean showProgressBar) {
        this.showProgressBar = showProgressBar;
        return this;
    }

    @JsonSetter(value="entranceAnimation")
    public UiNotification setEntranceAnimation(UiEntranceAnimation entranceAnimation) {
        this.entranceAnimation = entranceAnimation;
        return this;
    }

    @JsonSetter(value="exitAnimation")
    public UiNotification setExitAnimation(UiExitAnimation exitAnimation) {
        this.exitAnimation = exitAnimation;
        return this;
    }

    public static enum Position {
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;


        @JsonValue
        public int jsonValue() {
            return this.ordinal();
        }
    }
}

